/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */




package opale.mathtools;

/**
* This class implements the fix point method to solve the equation f(x) = x, where f is a function R^n->R^n.
* @since Opale-Mathtools 0.12
* @author O.C.
* @date 01/2001
*/
public final class FixPoint
{
/**
* This value represents the square of the solution precision.
*/
public static double PRECISION = 1.e-18;

/**
* This value fixes the maximum number of iterations in the algorithm.
*/ 
public static int MAXITERATION = 100;
/**
* This variable contains the number of iterations after convergence.
*/ 
public static int NITER = 0;
/**
* This variable indicates if method converges.
*/ 
//public static boolean CVG = false;

/**
* To call this method runs the resolution of the equation f(x) = x.
* @param IFnn, the function f.
* @param int, the dimension of the definition spaces of the function.
* @param DVect x0, the initial condition for the algorithm.
* @param DVect sol, the solution.
* @return boolean, true if the method converges.
*/ 
public static boolean solve(IFnn f, int n, DVect x0, DVect sol)
	{
	//tester la taille de DVect avec n ?
	
	int sortie=0;
//	double[] tab = new double[n];
	double norm1,norm2,tmp;
	NITER=0;
	//initialisation des conditions initiales
	DVect x = new DVect(x0.size());	
	sol.set(x0);
	while ( (NITER<MAXITERATION) && (sortie == 0) )
		{
		x.set(sol);
		sol.set(f.val(sol));
		
		norm1=norm2=0.;
		for (int j=0;j<x.size();j++)
			{
/* norm inf*/
/*			tmp = Math.abs(x.get(j)-sol.get(j));
			if (tmp > norm1) norm1=tmp;
			tmp =  Math.abs(x.get(j));
			if (tmp > norm2) norm2=tmp;*/
/* ... or norm 2*/
			norm1+=(x.get(j)-sol.get(j))*(x.get(j)-sol.get(j));
			norm2+=(x.get(j))*(x.get(j));
			}			

		// prepare the next iteration
		if (norm1 <= PRECISION*norm2) 
			sortie = 1;
		NITER++;
		}
	//if (opale.tools.Debug.On) opale.tools.Debug.print("Fix point NITER = "+NITER);	
	if 	(sortie == 0) return false;
	else return true;
	}
	
public static void main(String[] arg)
	{
	DVect x0 = new DVect(1);
	DVect sol = new DVect(1);
/*	FixPoint.solve(new IFnn()
		{
		public DVect val(DVect x)
			{
			DVect y =new DVect(2);
			y.set(0,1.+0.1*x.get(0)*x.get(1)-x.get(1));
			y.set(1,0.5*x.get(0)+0.5*x.get(0)*x.get(1));
			return y;
			}
		},2,x0,sol);*/
	FixPoint.solve(new IFnn()
		{
		public DVect val(DVect x)
			{
			DVect y =new DVect(1);
			y.set(0,-0.5*x.get(0)+1e19);
			return y;
			}
		},1,x0,sol);
	System.err.println(sol);
	}
}

