/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package opale.mathtools.parser;

abstract class  TypeOp
{
private Parser parser; // instance of the courant parser


/**
* Associates an instance of Parser to this operator ; this makes it possibe to get information about courant parser during the evaluation of this operator (for instance the units of angles : rad or deg).
*/ 
protected void setParser(Parser p) 
{
parser = p;
}

/**
* Returns the instance of Parser contained in this class.
*/
protected Parser getParser()
{
return parser;
}


/**
* Return an integer that represent the precedence of this operation. Higher is this number, higher will be the precedence of the operation 
*/
abstract int precedence();


/**
* Return the keyword that will be recognized in a string to identify this operation.
*/
public abstract String keyword();


}
