/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.mathtools.*;
import java.awt.*;
import java.awt.event.*;

	
public class fonction extends Frame
	{
	OIJ repere;
	LinLinCS vue;
	GAxis2D axes;
	GyFx sin,x3; //deux fonctions y=f(x)
	GData2D xy ; //une fonction paramtrique
	//Gexp exp ; //une fonction exponentielle
	
	public fonction() 
		{
		setSize(400,400);
		
		repere = new OIJ();
		vue = new LinLinCS(repere,25,25,350,350);
		
		axes = new GAxis2D(vue);
		axes.drawLabel(false);
		axes.drawScale(false);
		((InfoAxis) axes.getInfo()).setTick(0,1,0,1);

		sin = new GyFx(repere);
		sin.set(new IyFx() { public double val(double x) {return Math.sin(x);}},"sin(x)",-5,5,100);
		sin.getInfo().setColor(Color.red);

		x3 = new GyFx(repere);
		x3.set(new IyFx() { public double val(double x) {return x*x*x-x;}},"x*x*x-x",-5,5,100);
		x3.getInfo().setColor(Color.blue);
		
		xy = new GData2D(repere);
		xy.set(new opale.mathtools.IxyFt() 
				{ 
				public double x(double t) { return 7*Math.sin(t);}; 
				public double y(double t) { return 7*Math.cos(3*t);} 
				} ,-9,9,100);
				
		//exp = new Gexp(repere,0.1,-1,-5);
		//exp.set(-10,4,100);
		//exp.getInfo().setColor(Color.green);
				
		addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(25,25,getWidth()-50,getHeight()-50);
			vue.autoadjust();
			repaint();
			}
		});



		}
		
	public void paint(Graphics g)
		{
		
		Pen2D c = new Pen2D(g,vue);
		c.clip();
		
		axes.draw(c);

		sin.draw(c);
		x3.draw(c);
		xy.draw(c);
		//exp.draw(c);
		}
		
		
	
	
	
	public static void main(String[] arg) 		{
		fonction t = new fonction();
		t.show();
		}
	}
