/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.components.JFireBorder;

public class JComponentFactory {
    public static JLabel createJLabel(JComponent comp, String name) {
        JLabel label = new JLabel();
        label.setName(comp.getClass().getName() + ".label." + name);
        return label;
    }

    public static JLabel createJLabel(String name) {
        JLabel label = new JLabel(name);
        return label;
    }

    public static JCheckBox createSettingsJCheckBox(final PulseFireUISettingKeys key) {
        JCheckBox c = new JCheckBox();
        c.setSelected(PulseFireUI.getInstance().getSettingBoolean(key));
        c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PulseFireUI.getInstance().getSettings().setProperty(key.name(), "" + ((JCheckBox)e.getSource()).isSelected());
                PulseFireUI.getInstance().saveSettings();
            }
        });
        return c;
    }

    public static JPanel createJPanelJWrap(JComponent comp) {
        JPanel panel = new JPanel();
        panel.add(comp);
        return panel;
    }

    public static JPanel createJFirePanel() {
        return JComponentFactory.createJFirePanel(null);
    }

    public static JPanel createJFirePanel(Object nameObject, String name) {
        String i18nName = PulseFireUI.getInstance().getContext().getResourceMap().getString(nameObject.getClass().getName() + ".firepanel." + name + ".text", new Object[0]);
        return JComponentFactory.createJFirePanel(i18nName);
    }

    public static JPanel createJFirePanel(String name) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        JFireBorder fireBorder = new JFireBorder(name, panel);
        panel.setBorder(fireBorder);
        return panel;
    }

    public static void showWarningDialog(JComponent parent, String title, String message) {
        JOptionPane.showMessageDialog(parent, message, title, 2);
    }
}

