/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.DocumentFilter;
import javax.swing.text.InternationalFormatter;
import org.nongnu.pulsefire.device.DeviceConnectListener;
import org.nongnu.pulsefire.device.DeviceData;
import org.nongnu.pulsefire.device.ui.PulseFireUI;
import org.nongnu.pulsefire.wire.Command;
import org.nongnu.pulsefire.wire.CommandName;

public class JFireQMapTable
extends JPanel {
    private static final long serialVersionUID = 6413723813214593946L;
    private DeviceConfigVariableTableModel tableModel = null;
    private JTable qmapTable = null;

    public JFireQMapTable(CommandName commandName, String colNameA, String colNameB) {
        this.tableModel = new DeviceConfigVariableTableModel(commandName, colNameA, colNameB);
        this.qmapTable = new JTable(this.tableModel);
        this.qmapTable.getTableHeader().setReorderingAllowed(false);
        this.qmapTable.getTableHeader().setResizingAllowed(false);
        this.qmapTable.setAutoResizeMode(0);
        this.qmapTable.setFillsViewportHeight(true);
        this.qmapTable.setShowHorizontalLines(true);
        this.qmapTable.setRowMargin(2);
        this.qmapTable.setRowHeight(26);
        ToolTipManager.sharedInstance().unregisterComponent(this.qmapTable);
        ToolTipManager.sharedInstance().unregisterComponent(this.qmapTable.getTableHeader());
        TableColumn mapNum = this.qmapTable.getColumnModel().getColumn(0);
        mapNum.setPreferredWidth(50);
        TableColumn varId = this.qmapTable.getColumnModel().getColumn(1);
        varId.setPreferredWidth(160);
        varId.setCellEditor(new MapVariableIdInputCellEditor());
        varId.setCellRenderer(new MapVariableIdInputCellRenderer());
        TableColumn colA = this.qmapTable.getColumnModel().getColumn(2);
        colA.setPreferredWidth(90);
        colA.setCellEditor(new MapArguInputCellEditor());
        TableColumn colB = this.qmapTable.getColumnModel().getColumn(3);
        colB.setCellEditor(new MapArguInputCellEditor());
        colB.setPreferredWidth(90);
        TableColumn varIdx = this.qmapTable.getColumnModel().getColumn(4);
        varIdx.setPreferredWidth(55);
        varIdx.setCellEditor(new MapVariableIdxInputCellEditor());
        this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.add((Component)this.qmapTable.getTableHeader(), "First");
        this.add((Component)this.qmapTable, "Center");
    }

    public class MapVariableIdxInputCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private static final long serialVersionUID = 1890108511408714142L;
        private JComboBox component = new JComboBox();

        public MapVariableIdxInputCellEditor() {
            this.component.addActionListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            String cmdName = (String)table.getModel().getValueAt(rowIndex, 1);
            if (cmdName.isEmpty() | "65535".equals(value)) {
                this.component.addItem(value.toString());
                return this.component;
            }
            Integer mapIdx = new Integer(cmdName);
            for (CommandName c : CommandName.values()) {
                if (!c.isMappable() || !mapIdx.equals(c.getMapIndex())) continue;
                if (!c.isIndexedA()) {
                    return this.component;
                }
                this.component.removeAllItems();
                for (int i = 0; i < c.getMaxIndexA(); ++i) {
                    String item = "" + i;
                    this.component.addItem(item);
                    if (!item.equals(value)) continue;
                    this.component.setSelectedIndex(i);
                }
                String allItem = "255";
                this.component.addItem(allItem);
                if (allItem.equals(value)) {
                    this.component.setSelectedIndex(this.component.getItemCount() - 1);
                }
                return this.component;
            }
            this.component.addItem(value.toString());
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.component.getSelectedItem() == null) {
                return "0";
            }
            return this.component.getSelectedItem().toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }
    }

    public class MapVariableIdInputCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    DeviceConnectListener,
    ActionListener {
        private static final long serialVersionUID = -5036452317089888791L;
        private JComboBox component = new JComboBox();

        public MapVariableIdInputCellEditor() {
            this.component.addActionListener(this);
            PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int vColIndex) {
            for (int i = 0; i < this.component.getItemCount(); ++i) {
                CommandName var;
                String varName = (String)this.component.getItemAt(i);
                if ("NONE".equals(varName) || !(var = CommandName.valueOf((String)varName)).isMappable() || !new Integer(var.getMapIndex()).equals(new Integer(value.toString()))) continue;
                this.component.setSelectedIndex(i);
            }
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            if (this.component.getSelectedItem() == null) {
                return "";
            }
            if (this.component.getSelectedIndex() == 0) {
                return "65535";
            }
            return "" + CommandName.valueOf((String)this.component.getSelectedItem().toString()).getMapIndex();
        }

        public void deviceConnect() {
            this.component.addItem("NONE");
            ArrayList<String> mapVars = new ArrayList<String>(50);
            for (CommandName var : CommandName.values()) {
                if (!var.isMappable()) continue;
                mapVars.add(var.name());
            }
            Collections.sort(mapVars);
            for (String mapVar : mapVars) {
                this.component.addItem(mapVar);
            }
        }

        public void deviceDisconnect() {
            this.component.removeAllItems();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }
    }

    public class MapVariableIdInputCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4124140489638626053L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            MapVariableIdInputCellRenderer component = this;
            if ("65535".equals(value)) {
                component.setText("NONE");
                return component;
            }
            if (value.toString().isEmpty()) {
                component.setText("");
                return component;
            }
            for (CommandName var : CommandName.values()) {
                if (!var.isMappable() || !new Integer((String)value).equals(var.getMapIndex())) continue;
                component.setText(var.name());
                return component;
            }
            this.setText("");
            return this;
        }
    }

    class IntegerDocumentFilter
    extends DocumentFilter {
        IntegerDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            if (this.stringContainsOnlyDigits(string)) {
                super.insertString(fb, offset, string, attr);
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (this.stringContainsOnlyDigits(text)) {
                super.replace(fb, offset, length, text, attrs);
            }
        }

        private boolean stringContainsOnlyDigits(String text) {
            for (int i = 0; i < text.length(); ++i) {
                if (Character.isDigit(text.charAt(i))) continue;
                return false;
            }
            return true;
        }
    }

    public class MapArguInputCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ChangeListener {
        private static final long serialVersionUID = -8600090390794431579L;
        JSpinner component = new JSpinner();
        int rowIndex = 0;
        int colIndex = 0;
        JFormattedTextField.AbstractFormatterFactory formatFactory = null;

        public MapArguInputCellEditor() {
            this.component.addChangeListener(this);
            NumberFormat format = NumberFormat.getIntegerInstance();
            format.setGroupingUsed(false);
            this.formatFactory = new DefaultFormatterFactory(new InternationalFormatter(format){

                @Override
                protected DocumentFilter getDocumentFilter() {
                    return new IntegerDocumentFilter();
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int rowIndex, int colIndex) {
            this.rowIndex = rowIndex;
            this.colIndex = colIndex;
            if (value.toString().isEmpty()) {
                return this.component;
            }
            Integer valueInt = new Integer(value.toString());
            this.component.setModel(new SpinnerNumberModel(valueInt, 0, 65535, 1));
            return this.component;
        }

        @Override
        public Object getCellEditorValue() {
            return this.component.getValue().toString();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            JFireQMapTable.this.qmapTable.getModel().setValueAt(this.getCellEditorValue(), this.rowIndex, this.colIndex);
        }
    }

    public class DeviceConfigVariableTableModel
    extends AbstractTableModel
    implements DeviceConnectListener {
        private static final long serialVersionUID = 3636761640345147211L;
        private String[] columnNames = new String[]{"num", "variable", "a", "b", "idx"};
        private CommandName variableName = null;
        private volatile int indexMaxA = 2;
        private DeviceData deviceData = null;
        private String colNameA = null;
        private String colNameB = null;
        private boolean connected = false;
        JLabel l = new JLabel();

        public DeviceConfigVariableTableModel(CommandName variableName, String colNameA, String colNameB) {
            this.variableName = variableName;
            this.colNameA = colNameA;
            this.colNameB = colNameB;
            this.deviceData = PulseFireUI.getInstance().getDeviceData();
            PulseFireUI.getInstance().getDeviceManager().addDeviceConnectListener((DeviceConnectListener)this);
        }

        public void deviceConnect() {
            this.indexMaxA = this.variableName.getMaxIndexA();
            this.connected = true;
            this.fireTableDataChanged();
        }

        public void deviceDisconnect() {
            this.indexMaxA = 2;
            this.connected = false;
            this.fireTableDataChanged();
        }

        @Override
        public String getColumnName(int col) {
            if (col == 2) {
                return this.colNameA;
            }
            if (col == 3) {
                return this.colNameB;
            }
            return this.columnNames[col];
        }

        @Override
        public int getRowCount() {
            return this.indexMaxA;
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Command cmd = this.deviceData.getDeviceParameterIndexed(this.variableName, Integer.valueOf(row));
            if (cmd == null) {
                return "";
            }
            if (!this.connected) {
                return "";
            }
            if (col == 0) {
                return row;
            }
            if (col == 1) {
                return cmd.getArgu1();
            }
            if (col == 2) {
                return cmd.getArgu2();
            }
            if (col == 3) {
                return cmd.getArgu3();
            }
            if (col == 4) {
                return cmd.getArgu4();
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (!this.connected) {
                return false;
            }
            if (col == 0) {
                return false;
            }
            if (col == 1) {
                return true;
            }
            String cmdName = (String)this.getValueAt(row, 1);
            if (cmdName.isEmpty() | "65535".equals(cmdName)) {
                return false;
            }
            if (col != 4) {
                return true;
            }
            Integer mapIdx = new Integer(cmdName);
            for (CommandName c : CommandName.values()) {
                if (!c.isMappable() || !mapIdx.equals(c.getMapIndex()) || !c.isIndexedA()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            Command cmd = this.deviceData.getDeviceParameterIndexed(this.variableName, Integer.valueOf(row));
            if (cmd == null) {
                return;
            }
            if (col == 0) {
                return;
            }
            if (col == 1) {
                cmd.setArgu1((String)value);
            }
            if (col == 2) {
                cmd.setArgu2((String)value);
            }
            if (col == 3) {
                cmd.setArgu3((String)value);
            }
            if (col == 4) {
                cmd.setArgu4((String)value);
            }
            PulseFireUI.getInstance().getDeviceManager().requestCommand(cmd);
            this.fireTableCellUpdated(row, col);
        }
    }
}

