/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.jdesktop.application.ApplicationContext;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingKeys;
import org.nongnu.pulsefire.device.ui.PulseFireUISettingListener;

public class PulseFireUISettingManager {
    private static final String STORAGE_FILE = "pulsefire-settings.xml";
    private ApplicationContext context = null;
    private Properties settings = null;
    private Logger logger = null;
    private Map<PulseFireUISettingKeys, List<PulseFireUISettingListener>> listeners = null;

    public PulseFireUISettingManager(ApplicationContext context) {
        if (context == null) {
            throw new NullPointerException("Can work with null ApplicationContext.");
        }
        this.context = context;
        this.settings = new Properties();
        this.logger = Logger.getLogger(PulseFireUISettingManager.class.getName());
        this.listeners = new HashMap<PulseFireUISettingKeys, List<PulseFireUISettingListener>>(5);
    }

    public String getSettingString(PulseFireUISettingKeys key) {
        return this.settings.getProperty(key.name(), key.getDefaultValue());
    }

    public void setSettingString(PulseFireUISettingKeys key, String value) {
        this.settings.setProperty(key.name(), value);
        List<PulseFireUISettingListener> list = this.listeners.get((Object)key);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            PulseFireUISettingListener listener = list.get(i);
            listener.settingUpdated(key, value);
        }
    }

    public Boolean getSettingBoolean(PulseFireUISettingKeys key) {
        return new Boolean(this.getSettingString(key));
    }

    public Integer getSettingInteger(PulseFireUISettingKeys key) {
        return new Integer(this.getSettingString(key));
    }

    public void setSettingInteger(PulseFireUISettingKeys key, Integer value) {
        this.setSettingString(key, "" + value);
    }

    public void saveSettings() {
        try {
            this.context.getLocalStorage().save((Object)this.settings, STORAGE_FILE);
        }
        catch (IOException e) {
            this.logger.warning("Could not save settings error: " + e.getMessage());
        }
    }

    public void loadSettings() {
        try {
            Properties loadSettings = (Properties)this.context.getLocalStorage().load(STORAGE_FILE);
            if (loadSettings != null) {
                this.settings = loadSettings;
                this.logger.info("Loaded pulsefire-settings.xml with " + loadSettings.size() + " settings.");
            }
        }
        catch (IOException e) {
            this.logger.warning("Could not load settings error: " + e.getMessage());
        }
    }

    public void addSettingListener(PulseFireUISettingKeys key, PulseFireUISettingListener listener) {
        List<PulseFireUISettingListener> list = this.listeners.get((Object)key);
        if (list == null) {
            list = new ArrayList<PulseFireUISettingListener>(10);
            this.listeners.put(key, list);
        }
        list.add(listener);
    }

    public void removeSettingListener(PulseFireUISettingKeys key, PulseFireUISettingListener listener) {
        List<PulseFireUISettingListener> list = this.listeners.get((Object)key);
        if (list == null) {
            return;
        }
        list.remove(listener);
    }
}

