/*
 * Decompiled with CFR 0.152.
 */
package org.nongnu.pulsefire.device.ui.components;

import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import org.nongnu.pulsefire.device.ui.components.JIntegerTextField;

public class JFireDial
extends JComponent {
    private static final long serialVersionUID = 7895789282149616239L;
    private boolean mouseDialing = false;
    private boolean entered = false;
    private String text = null;
    private int value = 0;
    private int valueOld = 0;
    private int valueMin = 0;
    private int valueMax = 0;
    private int radiusSize = 0;
    private int dotIndex = -1;
    private int spinStartX = 0;
    private int spinStartY = 0;
    private int spinStartValue = 0;
    private static Popup globalPopup = null;

    public JFireDial() {
        this(0, 100, 0);
    }

    public JFireDial(int minValue, int maxValue, int value) {
        this.setMinimum(minValue);
        this.setMaximum(maxValue);
        this.setValue(value);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JFireDial.this.spin(e);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && !e.isConsumed()) {
                    e.consume();
                    JFireDial.this.showPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (globalPopup != null) {
                    globalPopup.hide();
                    globalPopup = null;
                }
                JFireDial.this.spinStartValue = JFireDial.this.getValue();
                JFireDial.this.spinStartX = e.getX();
                JFireDial.this.spinStartY = e.getY();
                JFireDial.this.mouseDialing = true;
                JFireDial.this.spin(e);
                JFireDial.this.repaint();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                JFireDial.this.mouseDialing = false;
                JFireDial.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
                JFireDial.this.entered = true;
                JFireDial.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
                JFireDial.this.entered = false;
                JFireDial.this.repaint();
            }
        });
    }

    private void showPopup(MouseEvent e) {
        if (globalPopup != null) {
            globalPopup.hide();
            globalPopup = null;
        }
        JPanel PopUpPanel = new JPanel();
        PopUpPanel.setPreferredSize(new Dimension(80, 30));
        PopUpPanel.setLayout(new BoxLayout(PopUpPanel, 1));
        PopupFactory factory = PopupFactory.getSharedInstance();
        globalPopup = factory.getPopup(((JFireDial)e.getSource()).getRootPane(), PopUpPanel, e.getXOnScreen() - 10, e.getYOnScreen() - 10);
        JIntegerTextField textField = new JIntegerTextField(this.getValue(), 10);
        textField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                globalPopup.hide();
                globalPopup = null;
                JFireDial.this.setValue(((JIntegerTextField)e.getSource()).getValue());
            }
        });
        PopUpPanel.add(textField);
        globalPopup.show();
        textField.requestFocus();
    }

    protected void spin(MouseEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        double valueNewTh = Math.atan((1.0 * (double)e.getY() - (double)this.radiusSize) / (double)(e.getX() - this.radiusSize));
        int valueNewOffset = (int)(valueNewTh / (Math.PI * 2) * (double)(this.valueMax - this.valueMin));
        int valueNew = 0;
        valueNew = e.getX() < this.radiusSize ? valueNewOffset + (this.valueMax - this.valueMin) / 2 + this.valueMin : (e.getY() < this.radiusSize ? valueNewOffset + this.valueMax : valueNewOffset + this.valueMin);
        double valueStartTh = Math.atan((1.0 * (double)this.spinStartY - (double)this.radiusSize) / (double)(this.spinStartX - this.radiusSize));
        int valueStartOffset = (int)(valueStartTh / (Math.PI * 2) * (double)(this.valueMax - this.valueMin));
        int valueStart = 0;
        valueStart = this.spinStartX < this.radiusSize ? valueStartOffset + (this.valueMax - this.valueMin) / 2 + this.valueMin : (this.spinStartY < this.radiusSize ? valueStartOffset + this.valueMax : valueStartOffset + this.valueMin);
        int valueChange = this.spinStartValue - valueStart;
        int valueNewRelative = valueNew + valueChange;
        if (valueNewRelative < 0) {
            valueNewRelative = this.valueMax + valueNewRelative;
        } else if (valueNewRelative > this.valueMax) {
            valueNewRelative -= this.valueMax;
        }
        this.setValue(valueNewRelative);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int h = this.getSize().height;
        int h2 = h / 2;
        int w = this.getSize().width;
        int w2 = w / 2;
        this.radiusSize = Math.min(w, h) / 2 - 1;
        int radiusInner = Math.min(w2, h2) - 1;
        double th = (double)this.value * (Math.PI * 2) / (double)(this.valueMax - this.valueMin) + 1.5707963267948966;
        if (this.isEnabled()) {
            if (this.entered | this.mouseDialing) {
                g2.setColor(UIManager.getColor("nimbusOrange"));
            } else {
                g2.setColor(this.getForeground());
            }
        } else {
            g2.setColor(UIManager.getColor("nimbusDisabledText"));
        }
        g2.setStroke(new BasicStroke(2.0f));
        int xI = (int)(Math.cos(th) * (double)(this.radiusSize / 4));
        int yI = (int)(Math.sin(th) * (double)(this.radiusSize / 4));
        int xV = (int)(Math.cos(th) * (double)this.radiusSize);
        int yV = (int)(Math.sin(th) * (double)this.radiusSize);
        g2.drawLine(xI + radiusInner, yI + radiusInner, xV + radiusInner, yV + radiusInner);
        if (this.isEnabled()) {
            if (this.mouseDialing) {
                g2.setColor(UIManager.getColor("nimbusOrange"));
            } else if (this.entered) {
                g2.setColor(UIManager.getColor("nimbusFocus"));
            } else {
                g2.setColor(UIManager.getColor("controlShadow"));
            }
        } else {
            g2.setColor(UIManager.getColor("controlDkShadow"));
        }
        g2.setStroke(new BasicStroke(2.0f));
        g2.drawArc(1, 1, this.radiusSize * 2, this.radiusSize * 2, 45, 180);
        g2.drawArc(1, 1, this.radiusSize * 2, this.radiusSize * 2, 225, 180);
        g2.setColor(UIManager.getColor("controlDkShadow"));
        g2.fillRect(2, h - 16, w - 2, h + 16);
        if (this.isEnabled()) {
            g2.setColor(this.getForeground());
        } else {
            g2.setColor(UIManager.getColor("nimbusDisabledText"));
        }
        g2.setFont(UIManager.getFont("FireDial.font"));
        if (this.entered && this.isEnabled() && !this.mouseDialing && this.text != null) {
            g2.setColor(UIManager.getColor("nimbusOrange"));
            g2.drawString(this.text, 4, h - 4);
        } else {
            String valueStr = "" + this.getValue();
            if (this.dotIndex > 0) {
                if (valueStr.length() > this.dotIndex) {
                    int idx = valueStr.length() - this.dotIndex;
                    String dotValue = valueStr.substring(idx, valueStr.length());
                    if (dotValue.length() == 1) {
                        dotValue = "0" + dotValue;
                    }
                    valueStr = valueStr.substring(0, idx) + "." + dotValue;
                } else {
                    valueStr = "0." + valueStr;
                }
            }
            g2.drawString(valueStr, 4, h - 4);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(36, 56);
    }

    public boolean isMouseDialing() {
        return this.mouseDialing;
    }

    public void setValue(int valueSet) {
        this.value = valueSet - this.valueMin;
        if (this.value == this.valueOld) {
            return;
        }
        this.valueOld = this.value;
        this.repaint();
        this.fireDialEvent();
    }

    public int getValue() {
        return this.value + this.valueMin;
    }

    public void setMinimum(int minValue) {
        this.valueMin = minValue;
    }

    public int getMinimum() {
        return this.valueMin;
    }

    public void setMaximum(int maxValue) {
        this.valueMax = maxValue;
    }

    public int getMaximum() {
        return this.valueMax;
    }

    public void addDialListener(DialListener listener) {
        this.listenerList.add(DialListener.class, listener);
    }

    public void removeDialListener(DialListener listener) {
        this.listenerList.remove(DialListener.class, listener);
    }

    protected void fireDialEvent() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != DialListener.class) continue;
            ((DialListener)listeners[i + 1]).dialAdjusted(new DialEvent(this, this.getValue()));
        }
    }

    public int getDotIndex() {
        return this.dotIndex;
    }

    public void setDotIndex(int dotIndex) {
        this.dotIndex = dotIndex;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public static interface DialListener
    extends EventListener {
        public void dialAdjusted(DialEvent var1);
    }

    public class DialEvent
    extends EventObject {
        private static final long serialVersionUID = -2060054863081294219L;
        int value;

        protected DialEvent(JFireDial source, int value) {
            super(source);
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

