import random

import Equipment


class Creature:
    def __init__(self, name):
        self.name = name

        self.hp = 1
        self.hp_max = 1

        self.str = 1
        self.int = 1
        self.wis = 1
        self.dex = 1
        self.con = 1
        self.cha = 1

        self.weapon = Equipment.Weapon(self)
        self.armor = Equipment.Armor()

    def damage(self, damage):
        self.hp -= damage

    def attack(self, other):
        chance = self.weapon.chance_against(other)
        r = random.randrange(100)

        if r <= chance:
            damage = self.weapon.damage_against(other)
            other.damage(damage)
            print other.name, 'takes', damage, ' and now has', other.hp, 'hp'
            if other.hp <= 0:
                print other.name, 'is dead'
        else:
            print other.name, 'dodges'


class Character(Creature):
    def __init__(self, name):
        Creature.__init__(self, name)


class Monster(Creature):
    def __init__(self, name):
        Creature.__init__(self, name)




def test_battle():
    c = Character('hero')
    c.hp = 40
    c.weapon = Equipment.Dagger(c)
    c.armor = Equipment.Chain()

    m = Monster('foe')
    m.hp = 40
    m.weapon = Equipment.Fist(m)
    m.armor = Equipment.Leather()

    while c.hp > 0 and m.hp > 0:
        if c.hp > 0 and m.hp > 0:
            c.attack(m)

        if c.hp > 0 and m.hp > 0:
            m.attack(c)


if __name__ == '__main__':
    test_battle()



