import random

from pygsear.Drawable import MultiImage, Circle, AnimatedImage
from pygsear.Event import KEY_Event, Repeat_KEY_Event, TIMEOUT_Event
from pygsear.Game import Game
from pygsear import conf
from pygsear.locals import RED
from pygame.locals import K_LEFT, K_RIGHT, K_UP, K_SPACE


class Remote(MultiImage):
    filenames = ['r_top.png', 'r_left.png', 'r_right.png']

    def __init__(self):
        self._left = 0
        self._right = 0
        MultiImage.__init__(self)
        self.center(y=-80)
        self.crect.width -= 20
        self.straight()

        self.path.set_restriction(speed=250)

        self.shots = conf.game.addGroup()
        self.shots_max = 8

    def control_left(self, ev=None):
        self._left = 1
    def control_unleft(self, ev=None):
        self._left = 0
    def control_right(self, ev=None):
        self._right = 1
    def control_unright(self, ev=None):
        self._right = 0

    def straight(self):
        #print 'r', self.crect,
        self.flip('r_top.png')
        #print self.crect
        self.path.decelerate(50)
    def left(self):
        self.flip('r_left.png')
        self.path.set_acceleration(ax=-180)
    def right(self):
        self.flip('r_right.png')
        self.path.set_acceleration(ax=180)

    def shoot(self, ev=None):
        if len(self.shots) < self.shots_max:
            shot = Beam()
            x, y = self.get_position()
            vx, vy = self.path.get_velocity()
            x += 23
            y -= 3

            vy = -200
            if self._left and not self._right:
                x -= 15
                vx -= 80
            elif self._right and not self._left:
                x += 10
                vx += 80

            shot.set_position(x, y)
            shot.path.set_velocity(vx=vx, vy=vy)
            conf.game.sprites.add(shot)
            self.shots.add(shot)

    def kill_shots(self, ev=None):
        self.shots.kill()

    def move(self):
        if not self.onscreen(right=-20, jail=1):
            self.path.set_velocity(vx=0)
            self._right = 0
            self.straight()
        elif not self.onscreen(left=-20, jail=1):
            self.path.set_velocity(vx=0)
            self._left = 0
            self.straight()

        if self._left and not self._right:
            self.left()
        elif self._right and not self._left:
            self.right()
        else:
            self.straight()

        MultiImage.move(self)


class Beam(Circle):
    def __init__(self):
        Circle.__init__(self, radius=3, color=RED)

    def move(self):
        if not self.onscreen():
            self.kill()

        Circle.move(self)


class Coin(AnimatedImage):
    def __init__(self):
        AnimatedImage.__init__(self, dirname='coin', flipticks=100)
        self.center(y=0)
        self.path.set_velocity(vy=20)

    def move(self):
        print 'r', self.crect,
        if not self.onscreen():
            self.kill()
        AnimatedImage.move(self)
        print self.crect


class Shoe(AnimatedImage):
    def __init__(self):
        AnimatedImage.__init__(self, dirname='shoe', flipticks=500)
        self.center(y=0)
        self.crect.width -= 20
        self.path.set_velocity(vy=20)
        self.path.set_acceleration(ay=30)

    def move(self):
        #print 's', self.crect,
        if not self.onscreen():
            self.kill()
        AnimatedImage.move(self)
        #print self.crect


class RGame(Game):
    def initialize(self):
        remote = Remote()
        self.remote = remote
        self.sprites.add(remote)

        self.events.add(KEY_Event(key=K_LEFT, on_press=remote.control_left, on_release=remote.control_unleft))
        self.events.add(KEY_Event(key=K_RIGHT, on_press=remote.control_right, on_release=remote.control_unright))

        self.events.add(Repeat_KEY_Event(key=K_UP, on_hold=remote.shoot, delay=0, period=250))

        self.events.add(KEY_Event(key=K_SPACE, on_press=remote.kill_shots))

        self.targets = self.addGroup()
        self.new_target()

    def checkCollisions(self):
        for shot in self.remote.shots.sprites():
            for target in self.targets.sprites():
                if target.collide(shot):
                    target.kill()
                    shot.kill()
                    break

        for target in self.targets.sprites():
            if target.collide(self.remote):
                target.kill()
                print 'poof'

    def new_target(self, ev=None):
        #coin = Coin()
        coin = Shoe()
        x = random.randrange(20, conf.WINWIDTH-80)
        coin.set_position((x, 0))
        self.sprites.add(coin)
        self.targets.add(coin)
        self.events.add(TIMEOUT_Event(2000, callback=self.new_target))


if __name__ == '__main__':
    g = RGame()
    g.mainloop()

