with System;
package ada_main is
   pragma Warnings (Off);

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: 3.4.5 (mingw special)";
   pragma Export (C, GNAT_Version, "__gnat_version");

   Ada_Main_Program_Name : constant String := "_ada_rapid" & Ascii.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adafinal;
   pragma Export (C, adafinal, "adafinal");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   procedure Break_Start;
   pragma Import (C, Break_Start, "__gnat_break_start");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#e45d59f4#;
   u00002 : constant Version_32 := 16#9d9c3691#;
   u00003 : constant Version_32 := 16#fcd73e35#;
   u00004 : constant Version_32 := 16#a0108083#;
   u00005 : constant Version_32 := 16#0409dd0c#;
   u00006 : constant Version_32 := 16#97b393d9#;
   u00007 : constant Version_32 := 16#0fccca55#;
   u00008 : constant Version_32 := 16#0eaa7c0d#;
   u00009 : constant Version_32 := 16#f5fe57c5#;
   u00010 : constant Version_32 := 16#bb122ec6#;
   u00011 : constant Version_32 := 16#99654be1#;
   u00012 : constant Version_32 := 16#54c8a078#;
   u00013 : constant Version_32 := 16#1d1ca407#;
   u00014 : constant Version_32 := 16#ab74c53c#;
   u00015 : constant Version_32 := 16#4d245d62#;
   u00016 : constant Version_32 := 16#36338a7b#;
   u00017 : constant Version_32 := 16#3f795639#;
   u00018 : constant Version_32 := 16#68ed2972#;
   u00019 : constant Version_32 := 16#8d9445da#;
   u00020 : constant Version_32 := 16#94979d51#;
   u00021 : constant Version_32 := 16#38297a36#;
   u00022 : constant Version_32 := 16#c3165cea#;
   u00023 : constant Version_32 := 16#2298e582#;
   u00024 : constant Version_32 := 16#9aeea643#;
   u00025 : constant Version_32 := 16#a223afde#;
   u00026 : constant Version_32 := 16#b9ba5e54#;
   u00027 : constant Version_32 := 16#6e859da6#;
   u00028 : constant Version_32 := 16#cf943c5d#;
   u00029 : constant Version_32 := 16#18ff916e#;
   u00030 : constant Version_32 := 16#1c775a3d#;
   u00031 : constant Version_32 := 16#367f6935#;
   u00032 : constant Version_32 := 16#e67db754#;
   u00033 : constant Version_32 := 16#60b487a2#;
   u00034 : constant Version_32 := 16#944c55a5#;
   u00035 : constant Version_32 := 16#1a18fd0f#;
   u00036 : constant Version_32 := 16#717f4299#;
   u00037 : constant Version_32 := 16#c4504387#;
   u00038 : constant Version_32 := 16#cc5a967d#;
   u00039 : constant Version_32 := 16#39162d55#;
   u00040 : constant Version_32 := 16#95f1ae19#;
   u00041 : constant Version_32 := 16#a09484f4#;
   u00042 : constant Version_32 := 16#7f70d6fb#;
   u00043 : constant Version_32 := 16#841ddc3f#;
   u00044 : constant Version_32 := 16#0f36abd2#;
   u00045 : constant Version_32 := 16#0c033dfd#;
   u00046 : constant Version_32 := 16#3b5d70a3#;
   u00047 : constant Version_32 := 16#060f352a#;
   u00048 : constant Version_32 := 16#a0be30a8#;
   u00049 : constant Version_32 := 16#6b03b68b#;
   u00050 : constant Version_32 := 16#ebae4dd3#;
   u00051 : constant Version_32 := 16#b3a2acc9#;
   u00052 : constant Version_32 := 16#37ee6228#;
   u00053 : constant Version_32 := 16#dec8b4cc#;
   u00054 : constant Version_32 := 16#0af0a97f#;
   u00055 : constant Version_32 := 16#2707dc21#;
   u00056 : constant Version_32 := 16#3cdde02e#;
   u00057 : constant Version_32 := 16#7bf62c37#;
   u00058 : constant Version_32 := 16#ce67505f#;
   u00059 : constant Version_32 := 16#ec0a26f5#;
   u00060 : constant Version_32 := 16#b1912198#;
   u00061 : constant Version_32 := 16#085ee784#;
   u00062 : constant Version_32 := 16#9d5e2b8a#;
   u00063 : constant Version_32 := 16#62397285#;
   u00064 : constant Version_32 := 16#474b0583#;
   u00065 : constant Version_32 := 16#7650601a#;
   u00066 : constant Version_32 := 16#2f0e9cd7#;
   u00067 : constant Version_32 := 16#17c8c8bd#;
   u00068 : constant Version_32 := 16#753e9209#;
   u00069 : constant Version_32 := 16#de85c6b4#;
   u00070 : constant Version_32 := 16#4973d243#;
   u00071 : constant Version_32 := 16#f5995467#;
   u00072 : constant Version_32 := 16#5fb535be#;
   u00073 : constant Version_32 := 16#a070e8b2#;
   u00074 : constant Version_32 := 16#9ab2cf23#;
   u00075 : constant Version_32 := 16#f6447ab9#;
   u00076 : constant Version_32 := 16#46d230ec#;
   u00077 : constant Version_32 := 16#6b21310c#;
   u00078 : constant Version_32 := 16#337e8ac6#;
   u00079 : constant Version_32 := 16#1d83992e#;
   u00080 : constant Version_32 := 16#a3942187#;
   u00081 : constant Version_32 := 16#bcb38f2c#;
   u00082 : constant Version_32 := 16#1efe2fa9#;
   u00083 : constant Version_32 := 16#00d6eef8#;
   u00084 : constant Version_32 := 16#20526e88#;
   u00085 : constant Version_32 := 16#ffad3e68#;
   u00086 : constant Version_32 := 16#29e5afbc#;
   u00087 : constant Version_32 := 16#7be0dea5#;
   u00088 : constant Version_32 := 16#f3aba486#;
   u00089 : constant Version_32 := 16#70f6a786#;
   u00090 : constant Version_32 := 16#68dfcf82#;
   u00091 : constant Version_32 := 16#2479cffe#;
   u00092 : constant Version_32 := 16#aacc3d3d#;
   u00093 : constant Version_32 := 16#7383b1ae#;
   u00094 : constant Version_32 := 16#8bdf89ba#;
   u00095 : constant Version_32 := 16#102af15f#;
   u00096 : constant Version_32 := 16#26a0b027#;
   u00097 : constant Version_32 := 16#74e6db33#;
   u00098 : constant Version_32 := 16#758d87ef#;
   u00099 : constant Version_32 := 16#c060067c#;
   u00100 : constant Version_32 := 16#97e2cedc#;
   u00101 : constant Version_32 := 16#223a434b#;
   u00102 : constant Version_32 := 16#188cda68#;
   u00103 : constant Version_32 := 16#2d4ef990#;
   u00104 : constant Version_32 := 16#ce2bcda9#;
   u00105 : constant Version_32 := 16#f5e787a0#;
   u00106 : constant Version_32 := 16#5d3ebc10#;
   u00107 : constant Version_32 := 16#b5c40dad#;
   u00108 : constant Version_32 := 16#19f14644#;
   u00109 : constant Version_32 := 16#4d586519#;
   u00110 : constant Version_32 := 16#d8088025#;
   u00111 : constant Version_32 := 16#3e241a90#;
   u00112 : constant Version_32 := 16#f6ef9e24#;
   u00113 : constant Version_32 := 16#21635c57#;
   u00114 : constant Version_32 := 16#63f5e940#;
   u00115 : constant Version_32 := 16#0ff1f788#;
   u00116 : constant Version_32 := 16#1b490ea4#;
   u00117 : constant Version_32 := 16#1528e471#;
   u00118 : constant Version_32 := 16#87ad0654#;
   u00119 : constant Version_32 := 16#483c344f#;
   u00120 : constant Version_32 := 16#58c81565#;
   u00121 : constant Version_32 := 16#c6a71890#;
   u00122 : constant Version_32 := 16#efa37476#;
   u00123 : constant Version_32 := 16#881024e6#;
   u00124 : constant Version_32 := 16#b84e495c#;
   u00125 : constant Version_32 := 16#3c483919#;
   u00126 : constant Version_32 := 16#32480be2#;
   u00127 : constant Version_32 := 16#cb5ca577#;
   u00128 : constant Version_32 := 16#ad931dca#;
   u00129 : constant Version_32 := 16#50c99732#;
   u00130 : constant Version_32 := 16#f02ff885#;
   u00131 : constant Version_32 := 16#c0c392f0#;
   u00132 : constant Version_32 := 16#218dca24#;
   u00133 : constant Version_32 := 16#32239e30#;
   u00134 : constant Version_32 := 16#23153183#;
   u00135 : constant Version_32 := 16#4ed143cd#;
   u00136 : constant Version_32 := 16#575a3d3a#;
   u00137 : constant Version_32 := 16#4e001756#;
   u00138 : constant Version_32 := 16#966b502a#;
   u00139 : constant Version_32 := 16#89c00a1e#;
   u00140 : constant Version_32 := 16#682fa91a#;
   u00141 : constant Version_32 := 16#69a90141#;
   u00142 : constant Version_32 := 16#87d63e0c#;
   u00143 : constant Version_32 := 16#97c362dd#;
   u00144 : constant Version_32 := 16#40a0d75a#;
   u00145 : constant Version_32 := 16#88bf8836#;
   u00146 : constant Version_32 := 16#2b6dce41#;
   u00147 : constant Version_32 := 16#9d7abb4a#;
   u00148 : constant Version_32 := 16#cf9df275#;
   u00149 : constant Version_32 := 16#f992038e#;
   u00150 : constant Version_32 := 16#fb52b2cc#;
   u00151 : constant Version_32 := 16#a2ee625a#;
   u00152 : constant Version_32 := 16#07f4f7a8#;
   u00153 : constant Version_32 := 16#4a889bed#;
   u00154 : constant Version_32 := 16#cfb745b6#;
   u00155 : constant Version_32 := 16#a5a16747#;
   u00156 : constant Version_32 := 16#ec185bba#;
   u00157 : constant Version_32 := 16#ce55d702#;
   u00158 : constant Version_32 := 16#0be25a15#;
   u00159 : constant Version_32 := 16#31ee4ab1#;
   u00160 : constant Version_32 := 16#9f5528ce#;
   u00161 : constant Version_32 := 16#4556fc0b#;
   u00162 : constant Version_32 := 16#2b8a2e82#;
   u00163 : constant Version_32 := 16#5faf173a#;
   u00164 : constant Version_32 := 16#b9ab1bcd#;
   u00165 : constant Version_32 := 16#e32d294d#;
   u00166 : constant Version_32 := 16#b9049277#;
   u00167 : constant Version_32 := 16#ec3911be#;
   u00168 : constant Version_32 := 16#351cb2b8#;
   u00169 : constant Version_32 := 16#0f1ad7d0#;
   u00170 : constant Version_32 := 16#f21c56e3#;
   u00171 : constant Version_32 := 16#1cfde1b6#;
   u00172 : constant Version_32 := 16#c7aeb4de#;
   u00173 : constant Version_32 := 16#56f02327#;
   u00174 : constant Version_32 := 16#35f82779#;
   u00175 : constant Version_32 := 16#ab972a8c#;
   u00176 : constant Version_32 := 16#c74fb7ce#;
   u00177 : constant Version_32 := 16#84f33c46#;
   u00178 : constant Version_32 := 16#d54bb105#;
   u00179 : constant Version_32 := 16#5ef1d8fa#;
   u00180 : constant Version_32 := 16#29a39906#;
   u00181 : constant Version_32 := 16#fa51067d#;
   u00182 : constant Version_32 := 16#5c069ab3#;
   u00183 : constant Version_32 := 16#6fdfe09d#;
   u00184 : constant Version_32 := 16#717f363f#;
   u00185 : constant Version_32 := 16#1ddb73b8#;
   u00186 : constant Version_32 := 16#c7726af2#;
   u00187 : constant Version_32 := 16#19581da3#;
   u00188 : constant Version_32 := 16#17d993aa#;
   u00189 : constant Version_32 := 16#04ae2f26#;
   u00190 : constant Version_32 := 16#51e39b18#;
   u00191 : constant Version_32 := 16#a5b4ed90#;
   u00192 : constant Version_32 := 16#a7f2de7f#;
   u00193 : constant Version_32 := 16#52e3adbf#;
   u00194 : constant Version_32 := 16#415760bc#;
   u00195 : constant Version_32 := 16#9e9e2ffe#;
   u00196 : constant Version_32 := 16#bf4f5249#;
   u00197 : constant Version_32 := 16#6b664b28#;
   u00198 : constant Version_32 := 16#210e7b40#;
   u00199 : constant Version_32 := 16#2eb532a0#;
   u00200 : constant Version_32 := 16#97e7b655#;
   u00201 : constant Version_32 := 16#3e639e4d#;
   u00202 : constant Version_32 := 16#9e0d0a87#;
   u00203 : constant Version_32 := 16#726bb6bb#;
   u00204 : constant Version_32 := 16#b906562f#;
   u00205 : constant Version_32 := 16#e9918401#;
   u00206 : constant Version_32 := 16#1e010f75#;
   u00207 : constant Version_32 := 16#25d96cc3#;
   u00208 : constant Version_32 := 16#9a24f623#;
   u00209 : constant Version_32 := 16#ea616d8e#;
   u00210 : constant Version_32 := 16#cf029f29#;
   u00211 : constant Version_32 := 16#895d9b9b#;
   u00212 : constant Version_32 := 16#57708efd#;
   u00213 : constant Version_32 := 16#64b8ee50#;
   u00214 : constant Version_32 := 16#8cc5245f#;
   u00215 : constant Version_32 := 16#57a75ad7#;
   u00216 : constant Version_32 := 16#18a321c1#;
   u00217 : constant Version_32 := 16#27966c0a#;
   u00218 : constant Version_32 := 16#d6733cf0#;
   u00219 : constant Version_32 := 16#2f4ab60a#;
   u00220 : constant Version_32 := 16#3c1f69c3#;
   u00221 : constant Version_32 := 16#8cc0914e#;
   u00222 : constant Version_32 := 16#56410b43#;
   u00223 : constant Version_32 := 16#9f563f68#;
   u00224 : constant Version_32 := 16#c7b88f96#;
   u00225 : constant Version_32 := 16#145ce8a7#;
   u00226 : constant Version_32 := 16#69d83e68#;
   u00227 : constant Version_32 := 16#f18953e4#;
   u00228 : constant Version_32 := 16#6b04de39#;
   u00229 : constant Version_32 := 16#e0342ae3#;
   u00230 : constant Version_32 := 16#b95f5282#;
   u00231 : constant Version_32 := 16#e1a41493#;
   u00232 : constant Version_32 := 16#d6a44aee#;
   u00233 : constant Version_32 := 16#01a8a2ae#;
   u00234 : constant Version_32 := 16#31a3f161#;
   u00235 : constant Version_32 := 16#cf19c2c5#;
   u00236 : constant Version_32 := 16#84788de3#;
   u00237 : constant Version_32 := 16#227dffd4#;
   u00238 : constant Version_32 := 16#316a2190#;
   u00239 : constant Version_32 := 16#9ea2fef8#;
   u00240 : constant Version_32 := 16#c115ba90#;
   u00241 : constant Version_32 := 16#2f1f61f6#;
   u00242 : constant Version_32 := 16#8843962f#;
   u00243 : constant Version_32 := 16#1783881d#;
   u00244 : constant Version_32 := 16#eb2e51ff#;
   u00245 : constant Version_32 := 16#6c4e743c#;
   u00246 : constant Version_32 := 16#1e6bdbbd#;
   u00247 : constant Version_32 := 16#b4631551#;
   u00248 : constant Version_32 := 16#7c9ab59d#;
   u00249 : constant Version_32 := 16#29e2a2b9#;
   u00250 : constant Version_32 := 16#2775402c#;
   u00251 : constant Version_32 := 16#8d5e9b5a#;
   u00252 : constant Version_32 := 16#0a0f4c39#;
   u00253 : constant Version_32 := 16#70e36d02#;
   u00254 : constant Version_32 := 16#026faa5e#;
   u00255 : constant Version_32 := 16#31cde6a7#;
   u00256 : constant Version_32 := 16#85fa3af3#;
   u00257 : constant Version_32 := 16#444fda7d#;
   u00258 : constant Version_32 := 16#ba8d3830#;
   u00259 : constant Version_32 := 16#e1671040#;
   u00260 : constant Version_32 := 16#76d77086#;
   u00261 : constant Version_32 := 16#4e9723c1#;
   u00262 : constant Version_32 := 16#f196b6f5#;
   u00263 : constant Version_32 := 16#01f4dd90#;
   u00264 : constant Version_32 := 16#68424144#;
   u00265 : constant Version_32 := 16#e7f85d82#;
   u00266 : constant Version_32 := 16#b9f2b118#;
   u00267 : constant Version_32 := 16#2515da26#;
   u00268 : constant Version_32 := 16#a581f3c5#;
   u00269 : constant Version_32 := 16#e318a813#;
   u00270 : constant Version_32 := 16#f3490783#;
   u00271 : constant Version_32 := 16#94ea4480#;
   u00272 : constant Version_32 := 16#49d99b0d#;
   u00273 : constant Version_32 := 16#ca16cd94#;
   u00274 : constant Version_32 := 16#33a2d9a6#;
   u00275 : constant Version_32 := 16#8523b7c7#;
   u00276 : constant Version_32 := 16#d79c2eb5#;
   u00277 : constant Version_32 := 16#f1e6f6d8#;
   u00278 : constant Version_32 := 16#a6e5810a#;
   u00279 : constant Version_32 := 16#93743a50#;
   u00280 : constant Version_32 := 16#facb58d7#;
   u00281 : constant Version_32 := 16#00e1297e#;
   u00282 : constant Version_32 := 16#a9d3f0a6#;
   u00283 : constant Version_32 := 16#388bbb5c#;
   u00284 : constant Version_32 := 16#d295c2af#;
   u00285 : constant Version_32 := 16#9a6321fa#;
   u00286 : constant Version_32 := 16#d012284e#;
   u00287 : constant Version_32 := 16#274e02d0#;
   u00288 : constant Version_32 := 16#e52ddb9a#;
   u00289 : constant Version_32 := 16#782d6e14#;
   u00290 : constant Version_32 := 16#d988d606#;
   u00291 : constant Version_32 := 16#ad0b522c#;
   u00292 : constant Version_32 := 16#b8007951#;
   u00293 : constant Version_32 := 16#a36a8d34#;
   u00294 : constant Version_32 := 16#6ca8b992#;
   u00295 : constant Version_32 := 16#978f78d3#;
   u00296 : constant Version_32 := 16#6e018086#;
   u00297 : constant Version_32 := 16#48d5600a#;
   u00298 : constant Version_32 := 16#d093cc50#;
   u00299 : constant Version_32 := 16#e2c20847#;
   u00300 : constant Version_32 := 16#82ba0a96#;
   u00301 : constant Version_32 := 16#882dbec4#;
   u00302 : constant Version_32 := 16#d1863740#;
   u00303 : constant Version_32 := 16#e9b4b7ab#;
   u00304 : constant Version_32 := 16#a4761def#;
   u00305 : constant Version_32 := 16#50ef431c#;
   u00306 : constant Version_32 := 16#ba0639ae#;
   u00307 : constant Version_32 := 16#4af50e85#;
   u00308 : constant Version_32 := 16#1d010411#;
   u00309 : constant Version_32 := 16#e52eedd5#;
   u00310 : constant Version_32 := 16#f1d41efe#;
   u00311 : constant Version_32 := 16#95817dde#;
   u00312 : constant Version_32 := 16#057c86fa#;
   u00313 : constant Version_32 := 16#4ae59d57#;
   u00314 : constant Version_32 := 16#b9b0ce61#;
   u00315 : constant Version_32 := 16#7973c7f8#;
   u00316 : constant Version_32 := 16#2e764cc6#;
   u00317 : constant Version_32 := 16#04fae28d#;
   u00318 : constant Version_32 := 16#a7e67c15#;
   u00319 : constant Version_32 := 16#f4f86d33#;
   u00320 : constant Version_32 := 16#dd888093#;
   u00321 : constant Version_32 := 16#7170b763#;
   u00322 : constant Version_32 := 16#36322aef#;
   u00323 : constant Version_32 := 16#cd0b7f03#;
   u00324 : constant Version_32 := 16#76f67a8a#;
   u00325 : constant Version_32 := 16#4c7a1812#;
   u00326 : constant Version_32 := 16#f964966d#;
   u00327 : constant Version_32 := 16#368511f9#;
   u00328 : constant Version_32 := 16#c9dddf08#;
   u00329 : constant Version_32 := 16#0485ce5d#;
   u00330 : constant Version_32 := 16#13cd7871#;
   u00331 : constant Version_32 := 16#a8a862bf#;
   u00332 : constant Version_32 := 16#cc50a605#;
   u00333 : constant Version_32 := 16#71e67440#;
   u00334 : constant Version_32 := 16#fe162e35#;
   u00335 : constant Version_32 := 16#66c24afb#;
   u00336 : constant Version_32 := 16#a36c89e4#;
   u00337 : constant Version_32 := 16#4fc2b3c2#;
   u00338 : constant Version_32 := 16#6f753aa9#;
   u00339 : constant Version_32 := 16#7fad4da1#;
   u00340 : constant Version_32 := 16#b438fb40#;
   u00341 : constant Version_32 := 16#0cc0b896#;
   u00342 : constant Version_32 := 16#ff84ace3#;
   u00343 : constant Version_32 := 16#6380ea48#;
   u00344 : constant Version_32 := 16#7905bc5c#;
   u00345 : constant Version_32 := 16#fc40e26f#;
   u00346 : constant Version_32 := 16#d7990982#;
   u00347 : constant Version_32 := 16#ede7643b#;
   u00348 : constant Version_32 := 16#1d1cd3a0#;
   u00349 : constant Version_32 := 16#635d1177#;
   u00350 : constant Version_32 := 16#b571cdab#;
   u00351 : constant Version_32 := 16#778280c6#;

   pragma Export (C, u00001, "rapidB");
   pragma Export (C, u00002, "system__standard_libraryB");
   pragma Export (C, u00003, "system__standard_libraryS");
   pragma Export (C, u00004, "adaS");
   pragma Export (C, u00005, "ada__exceptionsB");
   pragma Export (C, u00006, "ada__exceptionsS");
   pragma Export (C, u00007, "ada__exceptions__last_chance_handlerB");
   pragma Export (C, u00008, "ada__exceptions__last_chance_handlerS");
   pragma Export (C, u00009, "system__secondary_stackB");
   pragma Export (C, u00010, "system__secondary_stackS");
   pragma Export (C, u00011, "systemS");
   pragma Export (C, u00012, "system__parametersB");
   pragma Export (C, u00013, "system__parametersS");
   pragma Export (C, u00014, "system__soft_linksB");
   pragma Export (C, u00015, "system__soft_linksS");
   pragma Export (C, u00016, "system__machine_state_operationsB");
   pragma Export (C, u00017, "system__machine_state_operationsS");
   pragma Export (C, u00018, "system__machine_codeS");
   pragma Export (C, u00019, "system__memoryB");
   pragma Export (C, u00020, "system__memoryS");
   pragma Export (C, u00021, "system__storage_elementsB");
   pragma Export (C, u00022, "system__storage_elementsS");
   pragma Export (C, u00023, "system__exceptionsS");
   pragma Export (C, u00024, "system__stack_checkingB");
   pragma Export (C, u00025, "system__stack_checkingS");
   pragma Export (C, u00026, "system__crtlS");
   pragma Export (C, u00027, "interfacesS");
   pragma Export (C, u00028, "system__exception_tableB");
   pragma Export (C, u00029, "system__exception_tableS");
   pragma Export (C, u00030, "system__htableB");
   pragma Export (C, u00031, "system__htableS");
   pragma Export (C, u00032, "system__tracebackB");
   pragma Export (C, u00033, "system__tracebackS");
   pragma Export (C, u00034, "system__unsigned_typesS");
   pragma Export (C, u00035, "system__traceback_entriesB");
   pragma Export (C, u00036, "system__traceback_entriesS");
   pragma Export (C, u00037, "ada__stringsS");
   pragma Export (C, u00038, "ada__strings__unboundedB");
   pragma Export (C, u00039, "ada__strings__unboundedS");
   pragma Export (C, u00040, "ada__strings__fixedB");
   pragma Export (C, u00041, "ada__strings__fixedS");
   pragma Export (C, u00042, "ada__strings__mapsB");
   pragma Export (C, u00043, "ada__strings__mapsS");
   pragma Export (C, u00044, "system__bit_opsB");
   pragma Export (C, u00045, "system__bit_opsS");
   pragma Export (C, u00046, "system__pure_exceptionsS");
   pragma Export (C, u00047, "ada__charactersS");
   pragma Export (C, u00048, "ada__characters__latin_1S");
   pragma Export (C, u00049, "ada__strings__searchB");
   pragma Export (C, u00050, "ada__strings__searchS");
   pragma Export (C, u00051, "system__compare_array_unsigned_8B");
   pragma Export (C, u00052, "system__compare_array_unsigned_8S");
   pragma Export (C, u00053, "ada__finalizationB");
   pragma Export (C, u00054, "ada__finalizationS");
   pragma Export (C, u00055, "system__finalization_rootB");
   pragma Export (C, u00056, "system__finalization_rootS");
   pragma Export (C, u00057, "ada__streamsS");
   pragma Export (C, u00058, "ada__tagsB");
   pragma Export (C, u00059, "ada__tagsS");
   pragma Export (C, u00060, "system__finalization_implementationB");
   pragma Export (C, u00061, "system__finalization_implementationS");
   pragma Export (C, u00062, "system__string_ops_concat_3B");
   pragma Export (C, u00063, "system__string_ops_concat_3S");
   pragma Export (C, u00064, "system__string_opsB");
   pragma Export (C, u00065, "system__string_opsS");
   pragma Export (C, u00066, "system__stream_attributesB");
   pragma Export (C, u00067, "system__stream_attributesS");
   pragma Export (C, u00068, "ada__io_exceptionsS");
   pragma Export (C, u00069, "file_menuB");
   pragma Export (C, u00070, "file_menuS");
   pragma Export (C, u00071, "guiS");
   pragma Export (C, u00072, "limitsS");
   pragma Export (C, u00073, "gui__windowB");
   pragma Export (C, u00074, "gui__windowS");
   pragma Export (C, u00075, "ada__characters__handlingB");
   pragma Export (C, u00076, "ada__characters__handlingS");
   pragma Export (C, u00077, "ada__strings__maps__constantsS");
   pragma Export (C, u00078, "ada__text_ioB");
   pragma Export (C, u00079, "ada__text_ioS");
   pragma Export (C, u00080, "interfaces__c_streamsB");
   pragma Export (C, u00081, "interfaces__c_streamsS");
   pragma Export (C, u00082, "system__file_ioB");
   pragma Export (C, u00083, "system__file_ioS");
   pragma Export (C, u00084, "system__file_control_blockS");
   pragma Export (C, u00085, "ada__finalization__list_controllerB");
   pragma Export (C, u00086, "ada__finalization__list_controllerS");
   pragma Export (C, u00087, "file_helpersB");
   pragma Export (C, u00088, "file_helpersS");
   pragma Export (C, u00089, "system__img_intB");
   pragma Export (C, u00090, "system__img_intS");
   pragma Export (C, u00091, "generate_helpersB");
   pragma Export (C, u00092, "generate_helpersS");
   pragma Export (C, u00093, "gui__menuB");
   pragma Export (C, u00094, "gui__menuS");
   pragma Export (C, u00095, "lists_genericB");
   pragma Export (C, u00096, "lists_genericS");
   pragma Export (C, u00097, "gui__widgetB");
   pragma Export (C, u00098, "gui__widgetS");
   pragma Export (C, u00099, "font_actionsB");
   pragma Export (C, u00100, "font_actionsS");
   pragma Export (C, u00101, "font_selection_dialog_windowB");
   pragma Export (C, u00102, "font_selection_dialog_windowS");
   pragma Export (C, u00103, "mccB");
   pragma Export (C, u00104, "mccS");
   pragma Export (C, u00105, "mcc__guiB");
   pragma Export (C, u00106, "mcc__guiS");
   pragma Export (C, u00107, "cargvB");
   pragma Export (C, u00108, "cargvS");
   pragma Export (C, u00109, "ada__command_lineB");
   pragma Export (C, u00110, "ada__command_lineS");
   pragma Export (C, u00111, "chelperB");
   pragma Export (C, u00112, "chelperS");
   pragma Export (C, u00113, "interfaces__cB");
   pragma Export (C, u00114, "interfaces__cS");
   pragma Export (C, u00115, "interfaces__c__stringsB");
   pragma Export (C, u00116, "interfaces__c__stringsS");
   pragma Export (C, u00117, "text_ioS");
   pragma Export (C, u00118, "cargv_helpersB");
   pragma Export (C, u00119, "cargv_helpersS");
   pragma Export (C, u00120, "ada__integer_text_ioB");
   pragma Export (C, u00121, "ada__integer_text_ioS");
   pragma Export (C, u00122, "ada__text_io__integer_auxB");
   pragma Export (C, u00123, "ada__text_io__integer_auxS");
   pragma Export (C, u00124, "ada__text_io__generic_auxB");
   pragma Export (C, u00125, "ada__text_io__generic_auxS");
   pragma Export (C, u00126, "system__img_biuB");
   pragma Export (C, u00127, "system__img_biuS");
   pragma Export (C, u00128, "system__img_llbB");
   pragma Export (C, u00129, "system__img_llbS");
   pragma Export (C, u00130, "system__img_lliB");
   pragma Export (C, u00131, "system__img_lliS");
   pragma Export (C, u00132, "system__img_llwB");
   pragma Export (C, u00133, "system__img_llwS");
   pragma Export (C, u00134, "system__img_wiuB");
   pragma Export (C, u00135, "system__img_wiuS");
   pragma Export (C, u00136, "system__val_intB");
   pragma Export (C, u00137, "system__val_intS");
   pragma Export (C, u00138, "system__val_unsB");
   pragma Export (C, u00139, "system__val_unsS");
   pragma Export (C, u00140, "system__val_utilB");
   pragma Export (C, u00141, "system__val_utilS");
   pragma Export (C, u00142, "system__case_utilB");
   pragma Export (C, u00143, "system__case_utilS");
   pragma Export (C, u00144, "system__val_lliB");
   pragma Export (C, u00145, "system__val_lliS");
   pragma Export (C, u00146, "system__val_lluB");
   pragma Export (C, u00147, "system__val_lluS");
   pragma Export (C, u00148, "mcc__gui__containerS");
   pragma Export (C, u00149, "mcc__gui__container__windowB");
   pragma Export (C, u00150, "mcc__gui__container__windowS");
   pragma Export (C, u00151, "my_expanding_arrayS");
   pragma Export (C, u00152, "expanding_arrayB");
   pragma Export (C, u00153, "expanding_arrayS");
   pragma Export (C, u00154, "system__string_ops_concat_4B");
   pragma Export (C, u00155, "system__string_ops_concat_4S");
   pragma Export (C, u00156, "system__string_ops_concat_5B");
   pragma Export (C, u00157, "system__string_ops_concat_5S");
   pragma Export (C, u00158, "tclB");
   pragma Export (C, u00159, "tclS");
   pragma Export (C, u00160, "tcl__tkB");
   pragma Export (C, u00161, "tcl__tkS");
   pragma Export (C, u00162, "mcc__gui__widgetB");
   pragma Export (C, u00163, "mcc__gui__widgetS");
   pragma Export (C, u00164, "mcc__gui__widget__dropdownB");
   pragma Export (C, u00165, "mcc__gui__widget__dropdownS");
   pragma Export (C, u00166, "mcc__common_dialogsB");
   pragma Export (C, u00167, "mcc__common_dialogsS");
   pragma Export (C, u00168, "peerB");
   pragma Export (C, u00169, "peerS");
   pragma Export (C, u00170, "tcl__adaB");
   pragma Export (C, u00171, "tcl__adaS");
   pragma Export (C, u00172, "tcl_utilitiesB");
   pragma Export (C, u00173, "tcl_utilitiesS");
   pragma Export (C, u00174, "ada__float_text_ioB");
   pragma Export (C, u00175, "ada__float_text_ioS");
   pragma Export (C, u00176, "ada__text_io__float_auxB");
   pragma Export (C, u00177, "ada__text_io__float_auxS");
   pragma Export (C, u00178, "system__img_realB");
   pragma Export (C, u00179, "system__img_realS");
   pragma Export (C, u00180, "system__fat_llfS");
   pragma Export (C, u00181, "system__img_lluB");
   pragma Export (C, u00182, "system__img_lluS");
   pragma Export (C, u00183, "system__img_unsB");
   pragma Export (C, u00184, "system__img_unsS");
   pragma Export (C, u00185, "system__powten_tableS");
   pragma Export (C, u00186, "system__val_realB");
   pragma Export (C, u00187, "system__val_realS");
   pragma Export (C, u00188, "system__exn_llfB");
   pragma Export (C, u00189, "system__exn_llfS");
   pragma Export (C, u00190, "system__fat_fltS");
   pragma Export (C, u00191, "mcc__gui__widget__listboxB");
   pragma Export (C, u00192, "mcc__gui__widget__listboxS");
   pragma Export (C, u00193, "mcc__gui__widget__progressB");
   pragma Export (C, u00194, "mcc__gui__widget__progressS");
   pragma Export (C, u00195, "mcc__gui__widget__textboxB");
   pragma Export (C, u00196, "mcc__gui__widget__textboxS");
   pragma Export (C, u00197, "mcc__gui__widget__labelB");
   pragma Export (C, u00198, "mcc__gui__widget__labelS");
   pragma Export (C, u00199, "mcc__gui__colorsB");
   pragma Export (C, u00200, "mcc__gui__colorsS");
   pragma Export (C, u00201, "ada__text_io__enumeration_auxB");
   pragma Export (C, u00202, "ada__text_io__enumeration_auxS");
   pragma Export (C, u00203, "system__img_enumB");
   pragma Export (C, u00204, "system__img_enumS");
   pragma Export (C, u00205, "system__val_enumB");
   pragma Export (C, u00206, "system__val_enumS");
   pragma Export (C, u00207, "mcc__gui__widget__buttonB");
   pragma Export (C, u00208, "mcc__gui__widget__buttonS");
   pragma Export (C, u00209, "mcc__gui__widget__button__textB");
   pragma Export (C, u00210, "mcc__gui__widget__button__textS");
   pragma Export (C, u00211, "mcc__gui__fontsB");
   pragma Export (C, u00212, "mcc__gui__fontsS");
   pragma Export (C, u00213, "subwindow_actionsB");
   pragma Export (C, u00214, "subwindow_actionsS");
   pragma Export (C, u00215, "gui_enumB");
   pragma Export (C, u00216, "gui_enumS");
   pragma Export (C, u00217, "gui__widget__buttonB");
   pragma Export (C, u00218, "gui__widget__buttonS");
   pragma Export (C, u00219, "mcc__gui__widget__button__pictureB");
   pragma Export (C, u00220, "mcc__gui__widget__button__pictureS");
   pragma Export (C, u00221, "mcc__gui__imageB");
   pragma Export (C, u00222, "mcc__gui__imageS");
   pragma Export (C, u00223, "picturebutton_dialog_windowB");
   pragma Export (C, u00224, "picturebutton_dialog_windowS");
   pragma Export (C, u00225, "mcc__gui__widget__text_entryB");
   pragma Export (C, u00226, "mcc__gui__widget__text_entryS");
   pragma Export (C, u00227, "mcc__text_entry_typesB");
   pragma Export (C, u00228, "mcc__text_entry_typesS");
   pragma Export (C, u00229, "stateB");
   pragma Export (C, u00230, "stateS");
   pragma Export (C, u00231, "mcc__gui__keysS");
   pragma Export (C, u00232, "peer__keysS");
   pragma Export (C, u00233, "textbutton_dialog_windowB");
   pragma Export (C, u00234, "textbutton_dialog_windowS");
   pragma Export (C, u00235, "gui__widget__check_buttonB");
   pragma Export (C, u00236, "gui__widget__check_buttonS");
   pragma Export (C, u00237, "check_button_dialog_windowB");
   pragma Export (C, u00238, "check_button_dialog_windowS");
   pragma Export (C, u00239, "mcc__gui__widget__button__checkB");
   pragma Export (C, u00240, "mcc__gui__widget__button__checkS");
   pragma Export (C, u00241, "gui__widget__dropdownB");
   pragma Export (C, u00242, "gui__widget__dropdownS");
   pragma Export (C, u00243, "dropdown_dialog_windowB");
   pragma Export (C, u00244, "dropdown_dialog_windowS");
   pragma Export (C, u00245, "gui__widget__frameB");
   pragma Export (C, u00246, "gui__widget__frameS");
   pragma Export (C, u00247, "frame_dialog_windowB");
   pragma Export (C, u00248, "frame_dialog_windowS");
   pragma Export (C, u00249, "mcc__gui__widget__frameB");
   pragma Export (C, u00250, "mcc__gui__widget__frameS");
   pragma Export (C, u00251, "gui__widget__listboxB");
   pragma Export (C, u00252, "gui__widget__listboxS");
   pragma Export (C, u00253, "listbox_dialog_windowB");
   pragma Export (C, u00254, "listbox_dialog_windowS");
   pragma Export (C, u00255, "system__img_boolB");
   pragma Export (C, u00256, "system__img_boolS");
   pragma Export (C, u00257, "system__val_boolB");
   pragma Export (C, u00258, "system__val_boolS");
   pragma Export (C, u00259, "gui__widget__pictureB");
   pragma Export (C, u00260, "gui__widget__pictureS");
   pragma Export (C, u00261, "mcc__gui__widget__pictureB");
   pragma Export (C, u00262, "mcc__gui__widget__pictureS");
   pragma Export (C, u00263, "picture_dialog_windowB");
   pragma Export (C, u00264, "picture_dialog_windowS");
   pragma Export (C, u00265, "gui__widget__progressB");
   pragma Export (C, u00266, "gui__widget__progressS");
   pragma Export (C, u00267, "progress_dialog_windowB");
   pragma Export (C, u00268, "progress_dialog_windowS");
   pragma Export (C, u00269, "gui__widget__radio_buttonB");
   pragma Export (C, u00270, "gui__widget__radio_buttonS");
   pragma Export (C, u00271, "group_managerB");
   pragma Export (C, u00272, "group_managerS");
   pragma Export (C, u00273, "lists_generic__keyB");
   pragma Export (C, u00274, "lists_generic__keyS");
   pragma Export (C, u00275, "mcc__gui__widget__button__radioB");
   pragma Export (C, u00276, "mcc__gui__widget__button__radioS");
   pragma Export (C, u00277, "radio_button_dialog_windowB");
   pragma Export (C, u00278, "radio_button_dialog_windowS");
   pragma Export (C, u00279, "gui__widget__scaleB");
   pragma Export (C, u00280, "gui__widget__scaleS");
   pragma Export (C, u00281, "mcc__gui__widget__scaleB");
   pragma Export (C, u00282, "mcc__gui__widget__scaleS");
   pragma Export (C, u00283, "scale_dialog_windowB");
   pragma Export (C, u00284, "scale_dialog_windowS");
   pragma Export (C, u00285, "gui__widget__staticB");
   pragma Export (C, u00286, "gui__widget__staticS");
   pragma Export (C, u00287, "label_dialog_windowB");
   pragma Export (C, u00288, "label_dialog_windowS");
   pragma Export (C, u00289, "gui__widget__textB");
   pragma Export (C, u00290, "gui__widget__textS");
   pragma Export (C, u00291, "textentry_dialog_windowB");
   pragma Export (C, u00292, "textentry_dialog_windowS");
   pragma Export (C, u00293, "gui__widget__textboxB");
   pragma Export (C, u00294, "gui__widget__textboxS");
   pragma Export (C, u00295, "textbox_dialog_windowB");
   pragma Export (C, u00296, "textbox_dialog_windowS");
   pragma Export (C, u00297, "menu_editB");
   pragma Export (C, u00298, "menu_editS");
   pragma Export (C, u00299, "menu_generateB");
   pragma Export (C, u00300, "menu_generateS");
   pragma Export (C, u00301, "mcc__gui__menuB");
   pragma Export (C, u00302, "mcc__gui__menuS");
   pragma Export (C, u00303, "ada__strings__boundedB");
   pragma Export (C, u00304, "ada__strings__boundedS");
   pragma Export (C, u00305, "ada__strings__superboundedB");
   pragma Export (C, u00306, "ada__strings__superboundedS");
   pragma Export (C, u00307, "mcc__gui__container__frameB");
   pragma Export (C, u00308, "mcc__gui__container__frameS");
   pragma Export (C, u00309, "menuedit_windowB");
   pragma Export (C, u00310, "menuedit_windowS");
   pragma Export (C, u00311, "menuitem_dialog_windowB");
   pragma Export (C, u00312, "menuitem_dialog_windowS");
   pragma Export (C, u00313, "submenu_dialog_windowB");
   pragma Export (C, u00314, "submenu_dialog_windowS");
   pragma Export (C, u00315, "toolbarB");
   pragma Export (C, u00316, "toolbarS");
   pragma Export (C, u00317, "main_windowB");
   pragma Export (C, u00318, "main_windowS");
   pragma Export (C, u00319, "edit_menuB");
   pragma Export (C, u00320, "edit_menuS");
   pragma Export (C, u00321, "change_window_dialog_windowB");
   pragma Export (C, u00322, "change_window_dialog_windowS");
   pragma Export (C, u00323, "help_menuB");
   pragma Export (C, u00324, "help_menuS");
   pragma Export (C, u00325, "tools_menuB");
   pragma Export (C, u00326, "tools_menuS");
   pragma Export (C, u00327, "mcc__gui__widget__rectangleB");
   pragma Export (C, u00328, "mcc__gui__widget__rectangleS");
   pragma Export (C, u00329, "lists_generic_2keysS");
   pragma Export (C, u00330, "lists_generic__generic_keyB");
   pragma Export (C, u00331, "lists_generic__generic_keyS");
   pragma Export (C, u00332, "menu_ioB");
   pragma Export (C, u00333, "menu_ioS");
   pragma Export (C, u00334, "novice_modeB");
   pragma Export (C, u00335, "novice_modeS");
   pragma Export (C, u00336, "widget_ioB");
   pragma Export (C, u00337, "widget_ioS");
   pragma Export (C, u00338, "new_dialog_windowB");
   pragma Export (C, u00339, "new_dialog_windowS");
   pragma Export (C, u00340, "mcc__decode_command_lineB");
   pragma Export (C, u00341, "mcc__decode_command_lineS");
   pragma Export (C, u00342, "mcc__directory_operationsS");
   pragma Export (C, u00343, "gnatS");
   pragma Export (C, u00344, "gnat__directory_operationsB");
   pragma Export (C, u00345, "gnat__directory_operationsS");
   pragma Export (C, u00346, "gnat__os_libB");
   pragma Export (C, u00347, "gnat__os_libS");
   pragma Export (C, u00348, "gnat__stringsB");
   pragma Export (C, u00349, "gnat__stringsS");
   pragma Export (C, u00350, "rapid_helpersB");
   pragma Export (C, u00351, "rapid_helpersS");

   --  BEGIN ELABORATION ORDER
   --  ada (spec)
   --  ada.characters (spec)
   --  ada.characters.handling (spec)
   --  ada.characters.latin_1 (spec)
   --  ada.command_line (spec)
   --  gnat (spec)
   --  gnat.strings (spec)
   --  gnat.strings (body)
   --  interfaces (spec)
   --  system (spec)
   --  system.bit_ops (spec)
   --  system.case_util (spec)
   --  system.case_util (body)
   --  system.compare_array_unsigned_8 (spec)
   --  system.compare_array_unsigned_8 (body)
   --  system.exn_llf (spec)
   --  system.exn_llf (body)
   --  system.htable (spec)
   --  system.htable (body)
   --  system.img_bool (spec)
   --  system.img_enum (spec)
   --  system.img_int (spec)
   --  system.img_lli (spec)
   --  system.img_real (spec)
   --  system.machine_code (spec)
   --  system.parameters (spec)
   --  system.parameters (body)
   --  system.crtl (spec)
   --  interfaces.c_streams (spec)
   --  interfaces.c_streams (body)
   --  system.powten_table (spec)
   --  system.pure_exceptions (spec)
   --  system.standard_library (spec)
   --  system.storage_elements (spec)
   --  system.storage_elements (body)
   --  system.secondary_stack (spec)
   --  system.img_lli (body)
   --  system.img_int (body)
   --  system.img_enum (body)
   --  system.img_bool (body)
   --  ada.command_line (body)
   --  system.stack_checking (spec)
   --  system.string_ops (spec)
   --  system.string_ops (body)
   --  system.string_ops_concat_3 (spec)
   --  system.string_ops_concat_3 (body)
   --  system.string_ops_concat_4 (spec)
   --  system.string_ops_concat_4 (body)
   --  system.string_ops_concat_5 (spec)
   --  system.string_ops_concat_5 (body)
   --  system.traceback (spec)
   --  system.traceback (body)
   --  system.traceback_entries (spec)
   --  system.traceback_entries (body)
   --  ada.exceptions (spec)
   --  ada.exceptions.last_chance_handler (spec)
   --  system.exceptions (spec)
   --  system.machine_state_operations (spec)
   --  system.soft_links (spec)
   --  system.soft_links (body)
   --  ada.exceptions.last_chance_handler (body)
   --  system.stack_checking (body)
   --  system.secondary_stack (body)
   --  system.exception_table (spec)
   --  system.exception_table (body)
   --  ada.io_exceptions (spec)
   --  ada.strings (spec)
   --  ada.tags (spec)
   --  ada.tags (body)
   --  ada.streams (spec)
   --  gnat.os_lib (spec)
   --  gnat.os_lib (body)
   --  interfaces.c (spec)
   --  interfaces.c (body)
   --  interfaces.c.strings (spec)
   --  interfaces.c.strings (body)
   --  system.finalization_root (spec)
   --  system.finalization_root (body)
   --  system.memory (spec)
   --  system.memory (body)
   --  system.machine_state_operations (body)
   --  system.standard_library (body)
   --  system.unsigned_types (spec)
   --  ada.exceptions (body)
   --  system.bit_ops (body)
   --  ada.strings.maps (spec)
   --  ada.strings.maps (body)
   --  ada.strings.fixed (spec)
   --  ada.strings.maps.constants (spec)
   --  ada.characters.handling (body)
   --  ada.strings.search (spec)
   --  ada.strings.search (body)
   --  ada.strings.fixed (body)
   --  ada.strings.superbounded (spec)
   --  ada.strings.superbounded (body)
   --  ada.strings.bounded (spec)
   --  ada.strings.bounded (body)
   --  system.fat_flt (spec)
   --  system.fat_llf (spec)
   --  system.img_biu (spec)
   --  system.img_biu (body)
   --  system.img_llb (spec)
   --  system.img_llb (body)
   --  system.img_llu (spec)
   --  system.img_llu (body)
   --  system.img_llw (spec)
   --  system.img_llw (body)
   --  system.img_uns (spec)
   --  system.img_uns (body)
   --  system.img_real (body)
   --  system.img_wiu (spec)
   --  system.img_wiu (body)
   --  system.stream_attributes (spec)
   --  system.stream_attributes (body)
   --  system.finalization_implementation (spec)
   --  system.finalization_implementation (body)
   --  ada.finalization (spec)
   --  ada.finalization (body)
   --  ada.finalization.list_controller (spec)
   --  ada.finalization.list_controller (body)
   --  ada.strings.unbounded (spec)
   --  ada.strings.unbounded (body)
   --  gnat.directory_operations (spec)
   --  gnat.directory_operations (body)
   --  system.file_control_block (spec)
   --  system.file_io (spec)
   --  system.file_io (body)
   --  ada.text_io (spec)
   --  ada.text_io (body)
   --  ada.text_io.enumeration_aux (spec)
   --  ada.text_io.float_aux (spec)
   --  ada.float_text_io (spec)
   --  ada.float_text_io (body)
   --  ada.text_io.generic_aux (spec)
   --  ada.text_io.generic_aux (body)
   --  ada.text_io.enumeration_aux (body)
   --  ada.text_io.integer_aux (spec)
   --  ada.integer_text_io (spec)
   --  ada.integer_text_io (body)
   --  system.val_bool (spec)
   --  system.val_enum (spec)
   --  system.val_int (spec)
   --  system.val_lli (spec)
   --  ada.text_io.integer_aux (body)
   --  system.val_llu (spec)
   --  system.val_real (spec)
   --  ada.text_io.float_aux (body)
   --  system.val_uns (spec)
   --  system.val_util (spec)
   --  system.val_util (body)
   --  system.val_uns (body)
   --  system.val_real (body)
   --  system.val_llu (body)
   --  system.val_lli (body)
   --  system.val_int (body)
   --  system.val_enum (body)
   --  system.val_bool (body)
   --  text_io (spec)
   --  cargv (spec)
   --  cargv_helpers (spec)
   --  cargv_helpers (body)
   --  chelper (spec)
   --  chelper (body)
   --  cargv (body)
   --  expanding_array (spec)
   --  expanding_array (body)
   --  file_helpers (spec)
   --  file_helpers (body)
   --  generate_helpers (spec)
   --  generate_helpers (body)
   --  help_menu (spec)
   --  limits (spec)
   --  gui (spec)
   --  lists_generic (spec)
   --  lists_generic (body)
   --  gui.menu (spec)
   --  gui.menu (body)
   --  lists_generic.generic_key (spec)
   --  lists_generic.generic_key (body)
   --  lists_generic.key (spec)
   --  lists_generic.key (body)
   --  lists_generic_2keys (spec)
   --  mcc (spec)
   --  mcc (body)
   --  mcc.decode_command_line (spec)
   --  mcc.directory_operations (spec)
   --  mcc.decode_command_line (body)
   --  mcc.text_entry_types (spec)
   --  mcc.text_entry_types (body)
   --  menu_io (spec)
   --  tcl (spec)
   --  tcl (body)
   --  tcl.ada (spec)
   --  tcl.ada (body)
   --  peer (spec)
   --  mcc.gui (spec)
   --  mcc.gui.colors (spec)
   --  mcc.gui.colors (body)
   --  mcc.gui.container (spec)
   --  mcc.gui.container.frame (spec)
   --  mcc.gui.container.frame (body)
   --  mcc.gui.container.window (spec)
   --  mcc.common_dialogs (spec)
   --  help_menu (body)
   --  mcc.gui.fonts (spec)
   --  mcc.gui.image (spec)
   --  mcc.gui.image (body)
   --  mcc.gui.menu (spec)
   --  mcc.gui.menu (body)
   --  mcc.gui.widget (spec)
   --  mcc.gui.widget.button (spec)
   --  edit_menu (spec)
   --  file_menu (spec)
   --  mcc.gui.widget.button.check (spec)
   --  mcc.gui.widget.button.check (body)
   --  mcc.gui.widget.button.picture (spec)
   --  mcc.gui.widget.button.picture (body)
   --  mcc.gui.widget.button.radio (spec)
   --  group_manager (spec)
   --  group_manager (body)
   --  mcc.gui.widget.button.text (spec)
   --  mcc.gui.widget.button.text (body)
   --  mcc.gui.widget.dropdown (spec)
   --  mcc.gui.widget.dropdown (body)
   --  mcc.gui.widget.frame (spec)
   --  mcc.gui.widget.frame (body)
   --  mcc.gui.widget.label (spec)
   --  mcc.gui.widget.label (body)
   --  main_window (spec)
   --  mcc.gui.widget.listbox (spec)
   --  mcc.gui.widget.listbox (body)
   --  mcc.gui.fonts (body)
   --  font_selection_dialog_window (spec)
   --  mcc.gui.widget.picture (spec)
   --  mcc.gui.widget.picture (body)
   --  mcc.gui.widget.progress (spec)
   --  mcc.gui.widget.progress (body)
   --  mcc.gui.widget.rectangle (spec)
   --  mcc.gui.widget.rectangle (body)
   --  mcc.gui.widget.scale (spec)
   --  mcc.gui.widget.text_entry (spec)
   --  mcc.gui.widget.text_entry (body)
   --  change_window_dialog_window (spec)
   --  check_button_dialog_window (spec)
   --  dropdown_dialog_window (spec)
   --  frame_dialog_window (spec)
   --  gui.widget (spec)
   --  font_actions (spec)
   --  font_selection_dialog_window (body)
   --  gui.widget.button (spec)
   --  gui.widget.check_button (spec)
   --  gui.widget.dropdown (spec)
   --  gui.widget.frame (spec)
   --  gui.widget.listbox (spec)
   --  gui.widget.picture (spec)
   --  gui.widget.progress (spec)
   --  gui.widget.radio_button (spec)
   --  gui.widget.scale (spec)
   --  gui.widget.static (spec)
   --  gui.widget.text (spec)
   --  gui.widget.textbox (spec)
   --  gui_enum (spec)
   --  gui_enum (body)
   --  gui.widget.frame (body)
   --  change_window_dialog_window (body)
   --  gui.window (spec)
   --  label_dialog_window (spec)
   --  gui.widget.static (body)
   --  listbox_dialog_window (spec)
   --  gui.widget.listbox (body)
   --  mcc.gui.widget.textbox (spec)
   --  mcc.gui.widget.textbox (body)
   --  mcc.gui.widget (body)
   --  menu_edit (spec)
   --  menu_io (body)
   --  menu_generate (spec)
   --  menu_generate (body)
   --  menuedit_window (spec)
   --  menuedit_window (body)
   --  menuitem_dialog_window (spec)
   --  menuitem_dialog_window (body)
   --  my_expanding_array (spec)
   --  mcc.gui.widget.scale (body)
   --  mcc.gui.widget.button.radio (body)
   --  mcc.gui.widget.button (body)
   --  mcc.gui (body)
   --  new_dialog_window (spec)
   --  new_dialog_window (body)
   --  novice_mode (spec)
   --  novice_mode (body)
   --  peer.keys (spec)
   --  mcc.gui.keys (spec)
   --  picture_dialog_window (spec)
   --  gui.widget.picture (body)
   --  picturebutton_dialog_window (spec)
   --  progress_dialog_window (spec)
   --  gui.widget.progress (body)
   --  radio_button_dialog_window (spec)
   --  gui.widget.radio_button (body)
   --  rapid_helpers (spec)
   --  rapid_helpers (body)
   --  scale_dialog_window (spec)
   --  gui.widget.scale (body)
   --  state (spec)
   --  state (body)
   --  gui.widget.dropdown (body)
   --  gui.widget.check_button (body)
   --  file_menu (body)
   --  submenu_dialog_window (spec)
   --  submenu_dialog_window (body)
   --  menu_edit (body)
   --  subwindow_actions (spec)
   --  scale_dialog_window (body)
   --  radio_button_dialog_window (body)
   --  progress_dialog_window (body)
   --  picturebutton_dialog_window (body)
   --  picture_dialog_window (body)
   --  listbox_dialog_window (body)
   --  label_dialog_window (body)
   --  font_actions (body)
   --  gui.widget (body)
   --  frame_dialog_window (body)
   --  dropdown_dialog_window (body)
   --  check_button_dialog_window (body)
   --  edit_menu (body)
   --  tcl.tk (spec)
   --  tcl.tk (body)
   --  mcc.gui.container.window (body)
   --  peer (body)
   --  tcl_utilities (spec)
   --  tcl_utilities (body)
   --  mcc.common_dialogs (body)
   --  textbox_dialog_window (spec)
   --  textbox_dialog_window (body)
   --  gui.widget.textbox (body)
   --  textbutton_dialog_window (spec)
   --  textbutton_dialog_window (body)
   --  gui.widget.button (body)
   --  textentry_dialog_window (spec)
   --  textentry_dialog_window (body)
   --  gui.widget.text (body)
   --  toolbar (spec)
   --  toolbar (body)
   --  subwindow_actions (body)
   --  rapid (body)
   --  tools_menu (spec)
   --  tools_menu (body)
   --  main_window (body)
   --  widget_io (spec)
   --  widget_io (body)
   --  gui.window (body)
   --  END ELABORATION ORDER

end ada_main;
