with System;
package ada_main is
   pragma Warnings (Off);

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: 3.4.5 (mingw special)";
   pragma Export (C, GNAT_Version, "__gnat_version");

   Ada_Main_Program_Name : constant String := "_ada_simple" & Ascii.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adafinal;
   pragma Export (C, adafinal, "adafinal");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   procedure Break_Start;
   pragma Import (C, Break_Start, "__gnat_break_start");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#89d36716#;
   u00002 : constant Version_32 := 16#9d9c3691#;
   u00003 : constant Version_32 := 16#fcd73e35#;
   u00004 : constant Version_32 := 16#15b10da5#;
   u00005 : constant Version_32 := 16#1953197b#;
   u00006 : constant Version_32 := 16#ef482ecc#;
   u00007 : constant Version_32 := 16#089a2010#;
   u00008 : constant Version_32 := 16#2d4ef990#;
   u00009 : constant Version_32 := 16#ce2bcda9#;
   u00010 : constant Version_32 := 16#70f6a786#;
   u00011 : constant Version_32 := 16#68dfcf82#;
   u00012 : constant Version_32 := 16#99654be1#;
   u00013 : constant Version_32 := 16#f5fe57c5#;
   u00014 : constant Version_32 := 16#bb122ec6#;
   u00015 : constant Version_32 := 16#54c8a078#;
   u00016 : constant Version_32 := 16#1d1ca407#;
   u00017 : constant Version_32 := 16#ab74c53c#;
   u00018 : constant Version_32 := 16#4d245d62#;
   u00019 : constant Version_32 := 16#36338a7b#;
   u00020 : constant Version_32 := 16#3f795639#;
   u00021 : constant Version_32 := 16#68ed2972#;
   u00022 : constant Version_32 := 16#8d9445da#;
   u00023 : constant Version_32 := 16#94979d51#;
   u00024 : constant Version_32 := 16#a0108083#;
   u00025 : constant Version_32 := 16#0409dd0c#;
   u00026 : constant Version_32 := 16#97b393d9#;
   u00027 : constant Version_32 := 16#0fccca55#;
   u00028 : constant Version_32 := 16#0eaa7c0d#;
   u00029 : constant Version_32 := 16#6e859da6#;
   u00030 : constant Version_32 := 16#cf943c5d#;
   u00031 : constant Version_32 := 16#18ff916e#;
   u00032 : constant Version_32 := 16#1c775a3d#;
   u00033 : constant Version_32 := 16#367f6935#;
   u00034 : constant Version_32 := 16#38297a36#;
   u00035 : constant Version_32 := 16#c3165cea#;
   u00036 : constant Version_32 := 16#e67db754#;
   u00037 : constant Version_32 := 16#60b487a2#;
   u00038 : constant Version_32 := 16#944c55a5#;
   u00039 : constant Version_32 := 16#1a18fd0f#;
   u00040 : constant Version_32 := 16#717f4299#;
   u00041 : constant Version_32 := 16#2298e582#;
   u00042 : constant Version_32 := 16#9aeea643#;
   u00043 : constant Version_32 := 16#a223afde#;
   u00044 : constant Version_32 := 16#b9ba5e54#;
   u00045 : constant Version_32 := 16#b9049277#;
   u00046 : constant Version_32 := 16#ec3911be#;
   u00047 : constant Version_32 := 16#ce67505f#;
   u00048 : constant Version_32 := 16#ec0a26f5#;
   u00049 : constant Version_32 := 16#351cb2b8#;
   u00050 : constant Version_32 := 16#0f1ad7d0#;
   u00051 : constant Version_32 := 16#58c81565#;
   u00052 : constant Version_32 := 16#c6a71890#;
   u00053 : constant Version_32 := 16#337e8ac6#;
   u00054 : constant Version_32 := 16#1d83992e#;
   u00055 : constant Version_32 := 16#7bf62c37#;
   u00056 : constant Version_32 := 16#a3942187#;
   u00057 : constant Version_32 := 16#bcb38f2c#;
   u00058 : constant Version_32 := 16#1efe2fa9#;
   u00059 : constant Version_32 := 16#00d6eef8#;
   u00060 : constant Version_32 := 16#dec8b4cc#;
   u00061 : constant Version_32 := 16#0af0a97f#;
   u00062 : constant Version_32 := 16#2707dc21#;
   u00063 : constant Version_32 := 16#3cdde02e#;
   u00064 : constant Version_32 := 16#b1912198#;
   u00065 : constant Version_32 := 16#085ee784#;
   u00066 : constant Version_32 := 16#9d5e2b8a#;
   u00067 : constant Version_32 := 16#62397285#;
   u00068 : constant Version_32 := 16#474b0583#;
   u00069 : constant Version_32 := 16#7650601a#;
   u00070 : constant Version_32 := 16#2f0e9cd7#;
   u00071 : constant Version_32 := 16#17c8c8bd#;
   u00072 : constant Version_32 := 16#753e9209#;
   u00073 : constant Version_32 := 16#20526e88#;
   u00074 : constant Version_32 := 16#ffad3e68#;
   u00075 : constant Version_32 := 16#29e5afbc#;
   u00076 : constant Version_32 := 16#efa37476#;
   u00077 : constant Version_32 := 16#881024e6#;
   u00078 : constant Version_32 := 16#b84e495c#;
   u00079 : constant Version_32 := 16#3c483919#;
   u00080 : constant Version_32 := 16#32480be2#;
   u00081 : constant Version_32 := 16#cb5ca577#;
   u00082 : constant Version_32 := 16#ad931dca#;
   u00083 : constant Version_32 := 16#50c99732#;
   u00084 : constant Version_32 := 16#f02ff885#;
   u00085 : constant Version_32 := 16#c0c392f0#;
   u00086 : constant Version_32 := 16#218dca24#;
   u00087 : constant Version_32 := 16#32239e30#;
   u00088 : constant Version_32 := 16#23153183#;
   u00089 : constant Version_32 := 16#4ed143cd#;
   u00090 : constant Version_32 := 16#575a3d3a#;
   u00091 : constant Version_32 := 16#4e001756#;
   u00092 : constant Version_32 := 16#966b502a#;
   u00093 : constant Version_32 := 16#89c00a1e#;
   u00094 : constant Version_32 := 16#682fa91a#;
   u00095 : constant Version_32 := 16#69a90141#;
   u00096 : constant Version_32 := 16#87d63e0c#;
   u00097 : constant Version_32 := 16#97c362dd#;
   u00098 : constant Version_32 := 16#40a0d75a#;
   u00099 : constant Version_32 := 16#88bf8836#;
   u00100 : constant Version_32 := 16#2b6dce41#;
   u00101 : constant Version_32 := 16#9d7abb4a#;
   u00102 : constant Version_32 := 16#b5c40dad#;
   u00103 : constant Version_32 := 16#19f14644#;
   u00104 : constant Version_32 := 16#4d586519#;
   u00105 : constant Version_32 := 16#d8088025#;
   u00106 : constant Version_32 := 16#3e241a90#;
   u00107 : constant Version_32 := 16#f6ef9e24#;
   u00108 : constant Version_32 := 16#c4504387#;
   u00109 : constant Version_32 := 16#95f1ae19#;
   u00110 : constant Version_32 := 16#a09484f4#;
   u00111 : constant Version_32 := 16#7f70d6fb#;
   u00112 : constant Version_32 := 16#841ddc3f#;
   u00113 : constant Version_32 := 16#0f36abd2#;
   u00114 : constant Version_32 := 16#0c033dfd#;
   u00115 : constant Version_32 := 16#3b5d70a3#;
   u00116 : constant Version_32 := 16#060f352a#;
   u00117 : constant Version_32 := 16#a0be30a8#;
   u00118 : constant Version_32 := 16#6b03b68b#;
   u00119 : constant Version_32 := 16#ebae4dd3#;
   u00120 : constant Version_32 := 16#b3a2acc9#;
   u00121 : constant Version_32 := 16#37ee6228#;
   u00122 : constant Version_32 := 16#21635c57#;
   u00123 : constant Version_32 := 16#63f5e940#;
   u00124 : constant Version_32 := 16#0ff1f788#;
   u00125 : constant Version_32 := 16#1b490ea4#;
   u00126 : constant Version_32 := 16#1528e471#;
   u00127 : constant Version_32 := 16#0be25a15#;
   u00128 : constant Version_32 := 16#31ee4ab1#;
   u00129 : constant Version_32 := 16#f21c56e3#;
   u00130 : constant Version_32 := 16#1cfde1b6#;
   u00131 : constant Version_32 := 16#9f5528ce#;
   u00132 : constant Version_32 := 16#4556fc0b#;
   u00133 : constant Version_32 := 16#cfb745b6#;
   u00134 : constant Version_32 := 16#a5a16747#;
   u00135 : constant Version_32 := 16#ec185bba#;
   u00136 : constant Version_32 := 16#ce55d702#;
   u00137 : constant Version_32 := 16#c7aeb4de#;
   u00138 : constant Version_32 := 16#56f02327#;
   u00139 : constant Version_32 := 16#f6447ab9#;
   u00140 : constant Version_32 := 16#46d230ec#;
   u00141 : constant Version_32 := 16#6b21310c#;
   u00142 : constant Version_32 := 16#35f82779#;
   u00143 : constant Version_32 := 16#ab972a8c#;
   u00144 : constant Version_32 := 16#c74fb7ce#;
   u00145 : constant Version_32 := 16#84f33c46#;
   u00146 : constant Version_32 := 16#d54bb105#;
   u00147 : constant Version_32 := 16#5ef1d8fa#;
   u00148 : constant Version_32 := 16#29a39906#;
   u00149 : constant Version_32 := 16#fa51067d#;
   u00150 : constant Version_32 := 16#5c069ab3#;
   u00151 : constant Version_32 := 16#6fdfe09d#;
   u00152 : constant Version_32 := 16#717f363f#;
   u00153 : constant Version_32 := 16#1ddb73b8#;
   u00154 : constant Version_32 := 16#c7726af2#;
   u00155 : constant Version_32 := 16#19581da3#;
   u00156 : constant Version_32 := 16#17d993aa#;
   u00157 : constant Version_32 := 16#04ae2f26#;
   u00158 : constant Version_32 := 16#51e39b18#;
   u00159 : constant Version_32 := 16#f5e787a0#;
   u00160 : constant Version_32 := 16#5d3ebc10#;
   u00161 : constant Version_32 := 16#cc5a967d#;
   u00162 : constant Version_32 := 16#39162d55#;
   u00163 : constant Version_32 := 16#87ad0654#;
   u00164 : constant Version_32 := 16#483c344f#;
   u00165 : constant Version_32 := 16#cf9df275#;
   u00166 : constant Version_32 := 16#f992038e#;
   u00167 : constant Version_32 := 16#fb52b2cc#;
   u00168 : constant Version_32 := 16#a2ee625a#;
   u00169 : constant Version_32 := 16#07f4f7a8#;
   u00170 : constant Version_32 := 16#4a889bed#;
   u00171 : constant Version_32 := 16#2b8a2e82#;
   u00172 : constant Version_32 := 16#5faf173a#;
   u00173 : constant Version_32 := 16#b9ab1bcd#;
   u00174 : constant Version_32 := 16#e32d294d#;
   u00175 : constant Version_32 := 16#a5b4ed90#;
   u00176 : constant Version_32 := 16#a7f2de7f#;
   u00177 : constant Version_32 := 16#52e3adbf#;
   u00178 : constant Version_32 := 16#415760bc#;
   u00179 : constant Version_32 := 16#9e9e2ffe#;
   u00180 : constant Version_32 := 16#bf4f5249#;
   u00181 : constant Version_32 := 16#6b664b28#;
   u00182 : constant Version_32 := 16#210e7b40#;
   u00183 : constant Version_32 := 16#25d96cc3#;
   u00184 : constant Version_32 := 16#9a24f623#;
   u00185 : constant Version_32 := 16#895d9b9b#;
   u00186 : constant Version_32 := 16#57708efd#;
   u00187 : constant Version_32 := 16#8cc0914e#;
   u00188 : constant Version_32 := 16#56410b43#;
   u00189 : constant Version_32 := 16#882dbec4#;
   u00190 : constant Version_32 := 16#d1863740#;
   u00191 : constant Version_32 := 16#e9b4b7ab#;
   u00192 : constant Version_32 := 16#a4761def#;
   u00193 : constant Version_32 := 16#50ef431c#;
   u00194 : constant Version_32 := 16#ba0639ae#;
   u00195 : constant Version_32 := 16#4af50e85#;
   u00196 : constant Version_32 := 16#1d010411#;
   u00197 : constant Version_32 := 16#2f4ab60a#;
   u00198 : constant Version_32 := 16#3c1f69c3#;
   u00199 : constant Version_32 := 16#ea616d8e#;
   u00200 : constant Version_32 := 16#cf029f29#;

   pragma Export (C, u00001, "simpleB");
   pragma Export (C, u00002, "system__standard_libraryB");
   pragma Export (C, u00003, "system__standard_libraryS");
   pragma Export (C, u00004, "main_windowB");
   pragma Export (C, u00005, "main_windowS");
   pragma Export (C, u00006, "actionsB");
   pragma Export (C, u00007, "actionsS");
   pragma Export (C, u00008, "mccB");
   pragma Export (C, u00009, "mccS");
   pragma Export (C, u00010, "system__img_intB");
   pragma Export (C, u00011, "system__img_intS");
   pragma Export (C, u00012, "systemS");
   pragma Export (C, u00013, "system__secondary_stackB");
   pragma Export (C, u00014, "system__secondary_stackS");
   pragma Export (C, u00015, "system__parametersB");
   pragma Export (C, u00016, "system__parametersS");
   pragma Export (C, u00017, "system__soft_linksB");
   pragma Export (C, u00018, "system__soft_linksS");
   pragma Export (C, u00019, "system__machine_state_operationsB");
   pragma Export (C, u00020, "system__machine_state_operationsS");
   pragma Export (C, u00021, "system__machine_codeS");
   pragma Export (C, u00022, "system__memoryB");
   pragma Export (C, u00023, "system__memoryS");
   pragma Export (C, u00024, "adaS");
   pragma Export (C, u00025, "ada__exceptionsB");
   pragma Export (C, u00026, "ada__exceptionsS");
   pragma Export (C, u00027, "ada__exceptions__last_chance_handlerB");
   pragma Export (C, u00028, "ada__exceptions__last_chance_handlerS");
   pragma Export (C, u00029, "interfacesS");
   pragma Export (C, u00030, "system__exception_tableB");
   pragma Export (C, u00031, "system__exception_tableS");
   pragma Export (C, u00032, "system__htableB");
   pragma Export (C, u00033, "system__htableS");
   pragma Export (C, u00034, "system__storage_elementsB");
   pragma Export (C, u00035, "system__storage_elementsS");
   pragma Export (C, u00036, "system__tracebackB");
   pragma Export (C, u00037, "system__tracebackS");
   pragma Export (C, u00038, "system__unsigned_typesS");
   pragma Export (C, u00039, "system__traceback_entriesB");
   pragma Export (C, u00040, "system__traceback_entriesS");
   pragma Export (C, u00041, "system__exceptionsS");
   pragma Export (C, u00042, "system__stack_checkingB");
   pragma Export (C, u00043, "system__stack_checkingS");
   pragma Export (C, u00044, "system__crtlS");
   pragma Export (C, u00045, "mcc__common_dialogsB");
   pragma Export (C, u00046, "mcc__common_dialogsS");
   pragma Export (C, u00047, "ada__tagsB");
   pragma Export (C, u00048, "ada__tagsS");
   pragma Export (C, u00049, "peerB");
   pragma Export (C, u00050, "peerS");
   pragma Export (C, u00051, "ada__integer_text_ioB");
   pragma Export (C, u00052, "ada__integer_text_ioS");
   pragma Export (C, u00053, "ada__text_ioB");
   pragma Export (C, u00054, "ada__text_ioS");
   pragma Export (C, u00055, "ada__streamsS");
   pragma Export (C, u00056, "interfaces__c_streamsB");
   pragma Export (C, u00057, "interfaces__c_streamsS");
   pragma Export (C, u00058, "system__file_ioB");
   pragma Export (C, u00059, "system__file_ioS");
   pragma Export (C, u00060, "ada__finalizationB");
   pragma Export (C, u00061, "ada__finalizationS");
   pragma Export (C, u00062, "system__finalization_rootB");
   pragma Export (C, u00063, "system__finalization_rootS");
   pragma Export (C, u00064, "system__finalization_implementationB");
   pragma Export (C, u00065, "system__finalization_implementationS");
   pragma Export (C, u00066, "system__string_ops_concat_3B");
   pragma Export (C, u00067, "system__string_ops_concat_3S");
   pragma Export (C, u00068, "system__string_opsB");
   pragma Export (C, u00069, "system__string_opsS");
   pragma Export (C, u00070, "system__stream_attributesB");
   pragma Export (C, u00071, "system__stream_attributesS");
   pragma Export (C, u00072, "ada__io_exceptionsS");
   pragma Export (C, u00073, "system__file_control_blockS");
   pragma Export (C, u00074, "ada__finalization__list_controllerB");
   pragma Export (C, u00075, "ada__finalization__list_controllerS");
   pragma Export (C, u00076, "ada__text_io__integer_auxB");
   pragma Export (C, u00077, "ada__text_io__integer_auxS");
   pragma Export (C, u00078, "ada__text_io__generic_auxB");
   pragma Export (C, u00079, "ada__text_io__generic_auxS");
   pragma Export (C, u00080, "system__img_biuB");
   pragma Export (C, u00081, "system__img_biuS");
   pragma Export (C, u00082, "system__img_llbB");
   pragma Export (C, u00083, "system__img_llbS");
   pragma Export (C, u00084, "system__img_lliB");
   pragma Export (C, u00085, "system__img_lliS");
   pragma Export (C, u00086, "system__img_llwB");
   pragma Export (C, u00087, "system__img_llwS");
   pragma Export (C, u00088, "system__img_wiuB");
   pragma Export (C, u00089, "system__img_wiuS");
   pragma Export (C, u00090, "system__val_intB");
   pragma Export (C, u00091, "system__val_intS");
   pragma Export (C, u00092, "system__val_unsB");
   pragma Export (C, u00093, "system__val_unsS");
   pragma Export (C, u00094, "system__val_utilB");
   pragma Export (C, u00095, "system__val_utilS");
   pragma Export (C, u00096, "system__case_utilB");
   pragma Export (C, u00097, "system__case_utilS");
   pragma Export (C, u00098, "system__val_lliB");
   pragma Export (C, u00099, "system__val_lliS");
   pragma Export (C, u00100, "system__val_lluB");
   pragma Export (C, u00101, "system__val_lluS");
   pragma Export (C, u00102, "cargvB");
   pragma Export (C, u00103, "cargvS");
   pragma Export (C, u00104, "ada__command_lineB");
   pragma Export (C, u00105, "ada__command_lineS");
   pragma Export (C, u00106, "chelperB");
   pragma Export (C, u00107, "chelperS");
   pragma Export (C, u00108, "ada__stringsS");
   pragma Export (C, u00109, "ada__strings__fixedB");
   pragma Export (C, u00110, "ada__strings__fixedS");
   pragma Export (C, u00111, "ada__strings__mapsB");
   pragma Export (C, u00112, "ada__strings__mapsS");
   pragma Export (C, u00113, "system__bit_opsB");
   pragma Export (C, u00114, "system__bit_opsS");
   pragma Export (C, u00115, "system__pure_exceptionsS");
   pragma Export (C, u00116, "ada__charactersS");
   pragma Export (C, u00117, "ada__characters__latin_1S");
   pragma Export (C, u00118, "ada__strings__searchB");
   pragma Export (C, u00119, "ada__strings__searchS");
   pragma Export (C, u00120, "system__compare_array_unsigned_8B");
   pragma Export (C, u00121, "system__compare_array_unsigned_8S");
   pragma Export (C, u00122, "interfaces__cB");
   pragma Export (C, u00123, "interfaces__cS");
   pragma Export (C, u00124, "interfaces__c__stringsB");
   pragma Export (C, u00125, "interfaces__c__stringsS");
   pragma Export (C, u00126, "text_ioS");
   pragma Export (C, u00127, "tclB");
   pragma Export (C, u00128, "tclS");
   pragma Export (C, u00129, "tcl__adaB");
   pragma Export (C, u00130, "tcl__adaS");
   pragma Export (C, u00131, "tcl__tkB");
   pragma Export (C, u00132, "tcl__tkS");
   pragma Export (C, u00133, "system__string_ops_concat_4B");
   pragma Export (C, u00134, "system__string_ops_concat_4S");
   pragma Export (C, u00135, "system__string_ops_concat_5B");
   pragma Export (C, u00136, "system__string_ops_concat_5S");
   pragma Export (C, u00137, "tcl_utilitiesB");
   pragma Export (C, u00138, "tcl_utilitiesS");
   pragma Export (C, u00139, "ada__characters__handlingB");
   pragma Export (C, u00140, "ada__characters__handlingS");
   pragma Export (C, u00141, "ada__strings__maps__constantsS");
   pragma Export (C, u00142, "ada__float_text_ioB");
   pragma Export (C, u00143, "ada__float_text_ioS");
   pragma Export (C, u00144, "ada__text_io__float_auxB");
   pragma Export (C, u00145, "ada__text_io__float_auxS");
   pragma Export (C, u00146, "system__img_realB");
   pragma Export (C, u00147, "system__img_realS");
   pragma Export (C, u00148, "system__fat_llfS");
   pragma Export (C, u00149, "system__img_lluB");
   pragma Export (C, u00150, "system__img_lluS");
   pragma Export (C, u00151, "system__img_unsB");
   pragma Export (C, u00152, "system__img_unsS");
   pragma Export (C, u00153, "system__powten_tableS");
   pragma Export (C, u00154, "system__val_realB");
   pragma Export (C, u00155, "system__val_realS");
   pragma Export (C, u00156, "system__exn_llfB");
   pragma Export (C, u00157, "system__exn_llfS");
   pragma Export (C, u00158, "system__fat_fltS");
   pragma Export (C, u00159, "mcc__guiB");
   pragma Export (C, u00160, "mcc__guiS");
   pragma Export (C, u00161, "ada__strings__unboundedB");
   pragma Export (C, u00162, "ada__strings__unboundedS");
   pragma Export (C, u00163, "cargv_helpersB");
   pragma Export (C, u00164, "cargv_helpersS");
   pragma Export (C, u00165, "mcc__gui__containerS");
   pragma Export (C, u00166, "mcc__gui__container__windowB");
   pragma Export (C, u00167, "mcc__gui__container__windowS");
   pragma Export (C, u00168, "my_expanding_arrayS");
   pragma Export (C, u00169, "expanding_arrayB");
   pragma Export (C, u00170, "expanding_arrayS");
   pragma Export (C, u00171, "mcc__gui__widgetB");
   pragma Export (C, u00172, "mcc__gui__widgetS");
   pragma Export (C, u00173, "mcc__gui__widget__dropdownB");
   pragma Export (C, u00174, "mcc__gui__widget__dropdownS");
   pragma Export (C, u00175, "mcc__gui__widget__listboxB");
   pragma Export (C, u00176, "mcc__gui__widget__listboxS");
   pragma Export (C, u00177, "mcc__gui__widget__progressB");
   pragma Export (C, u00178, "mcc__gui__widget__progressS");
   pragma Export (C, u00179, "mcc__gui__widget__textboxB");
   pragma Export (C, u00180, "mcc__gui__widget__textboxS");
   pragma Export (C, u00181, "mcc__gui__widget__labelB");
   pragma Export (C, u00182, "mcc__gui__widget__labelS");
   pragma Export (C, u00183, "mcc__gui__widget__buttonB");
   pragma Export (C, u00184, "mcc__gui__widget__buttonS");
   pragma Export (C, u00185, "mcc__gui__fontsB");
   pragma Export (C, u00186, "mcc__gui__fontsS");
   pragma Export (C, u00187, "mcc__gui__imageB");
   pragma Export (C, u00188, "mcc__gui__imageS");
   pragma Export (C, u00189, "mcc__gui__menuB");
   pragma Export (C, u00190, "mcc__gui__menuS");
   pragma Export (C, u00191, "ada__strings__boundedB");
   pragma Export (C, u00192, "ada__strings__boundedS");
   pragma Export (C, u00193, "ada__strings__superboundedB");
   pragma Export (C, u00194, "ada__strings__superboundedS");
   pragma Export (C, u00195, "mcc__gui__container__frameB");
   pragma Export (C, u00196, "mcc__gui__container__frameS");
   pragma Export (C, u00197, "mcc__gui__widget__button__pictureB");
   pragma Export (C, u00198, "mcc__gui__widget__button__pictureS");
   pragma Export (C, u00199, "mcc__gui__widget__button__textB");
   pragma Export (C, u00200, "mcc__gui__widget__button__textS");

   --  BEGIN ELABORATION ORDER
   --  ada (spec)
   --  ada.characters (spec)
   --  ada.characters.handling (spec)
   --  ada.characters.latin_1 (spec)
   --  ada.command_line (spec)
   --  interfaces (spec)
   --  system (spec)
   --  system.bit_ops (spec)
   --  system.case_util (spec)
   --  system.case_util (body)
   --  system.compare_array_unsigned_8 (spec)
   --  system.compare_array_unsigned_8 (body)
   --  system.exn_llf (spec)
   --  system.exn_llf (body)
   --  system.htable (spec)
   --  system.htable (body)
   --  system.img_int (spec)
   --  system.img_lli (spec)
   --  system.img_real (spec)
   --  system.machine_code (spec)
   --  system.parameters (spec)
   --  system.parameters (body)
   --  system.crtl (spec)
   --  interfaces.c_streams (spec)
   --  interfaces.c_streams (body)
   --  system.powten_table (spec)
   --  system.pure_exceptions (spec)
   --  system.standard_library (spec)
   --  system.storage_elements (spec)
   --  system.storage_elements (body)
   --  system.secondary_stack (spec)
   --  system.img_lli (body)
   --  system.img_int (body)
   --  ada.command_line (body)
   --  system.stack_checking (spec)
   --  system.string_ops (spec)
   --  system.string_ops (body)
   --  system.string_ops_concat_3 (spec)
   --  system.string_ops_concat_3 (body)
   --  system.string_ops_concat_4 (spec)
   --  system.string_ops_concat_4 (body)
   --  system.string_ops_concat_5 (spec)
   --  system.string_ops_concat_5 (body)
   --  system.traceback (spec)
   --  system.traceback (body)
   --  system.traceback_entries (spec)
   --  system.traceback_entries (body)
   --  ada.exceptions (spec)
   --  ada.exceptions.last_chance_handler (spec)
   --  system.exceptions (spec)
   --  system.machine_state_operations (spec)
   --  system.soft_links (spec)
   --  system.soft_links (body)
   --  ada.exceptions.last_chance_handler (body)
   --  system.stack_checking (body)
   --  system.secondary_stack (body)
   --  system.exception_table (spec)
   --  system.exception_table (body)
   --  ada.io_exceptions (spec)
   --  ada.strings (spec)
   --  ada.tags (spec)
   --  ada.tags (body)
   --  ada.streams (spec)
   --  interfaces.c (spec)
   --  interfaces.c (body)
   --  interfaces.c.strings (spec)
   --  interfaces.c.strings (body)
   --  system.finalization_root (spec)
   --  system.finalization_root (body)
   --  system.memory (spec)
   --  system.memory (body)
   --  system.machine_state_operations (body)
   --  system.standard_library (body)
   --  system.unsigned_types (spec)
   --  ada.exceptions (body)
   --  system.bit_ops (body)
   --  ada.strings.maps (spec)
   --  ada.strings.maps (body)
   --  ada.strings.fixed (spec)
   --  ada.strings.maps.constants (spec)
   --  ada.characters.handling (body)
   --  ada.strings.search (spec)
   --  ada.strings.search (body)
   --  ada.strings.fixed (body)
   --  ada.strings.superbounded (spec)
   --  ada.strings.superbounded (body)
   --  ada.strings.bounded (spec)
   --  ada.strings.bounded (body)
   --  system.fat_flt (spec)
   --  system.fat_llf (spec)
   --  system.img_biu (spec)
   --  system.img_biu (body)
   --  system.img_llb (spec)
   --  system.img_llb (body)
   --  system.img_llu (spec)
   --  system.img_llu (body)
   --  system.img_llw (spec)
   --  system.img_llw (body)
   --  system.img_uns (spec)
   --  system.img_uns (body)
   --  system.img_real (body)
   --  system.img_wiu (spec)
   --  system.img_wiu (body)
   --  system.stream_attributes (spec)
   --  system.stream_attributes (body)
   --  system.finalization_implementation (spec)
   --  system.finalization_implementation (body)
   --  ada.finalization (spec)
   --  ada.finalization (body)
   --  ada.finalization.list_controller (spec)
   --  ada.finalization.list_controller (body)
   --  ada.strings.unbounded (spec)
   --  ada.strings.unbounded (body)
   --  system.file_control_block (spec)
   --  system.file_io (spec)
   --  system.file_io (body)
   --  ada.text_io (spec)
   --  ada.text_io (body)
   --  ada.text_io.float_aux (spec)
   --  ada.float_text_io (spec)
   --  ada.float_text_io (body)
   --  ada.text_io.generic_aux (spec)
   --  ada.text_io.generic_aux (body)
   --  ada.text_io.integer_aux (spec)
   --  ada.integer_text_io (spec)
   --  ada.integer_text_io (body)
   --  system.val_int (spec)
   --  system.val_lli (spec)
   --  ada.text_io.integer_aux (body)
   --  system.val_llu (spec)
   --  system.val_real (spec)
   --  ada.text_io.float_aux (body)
   --  system.val_uns (spec)
   --  system.val_util (spec)
   --  system.val_util (body)
   --  system.val_uns (body)
   --  system.val_real (body)
   --  system.val_llu (body)
   --  system.val_lli (body)
   --  system.val_int (body)
   --  text_io (spec)
   --  cargv (spec)
   --  cargv_helpers (spec)
   --  cargv_helpers (body)
   --  chelper (spec)
   --  chelper (body)
   --  cargv (body)
   --  expanding_array (spec)
   --  expanding_array (body)
   --  mcc (spec)
   --  mcc (body)
   --  tcl (spec)
   --  tcl (body)
   --  tcl.ada (spec)
   --  tcl.ada (body)
   --  peer (spec)
   --  mcc.gui (spec)
   --  mcc.gui.container (spec)
   --  mcc.gui.container.frame (spec)
   --  mcc.gui.container.frame (body)
   --  mcc.gui.container.window (spec)
   --  mcc.common_dialogs (spec)
   --  mcc.gui.fonts (spec)
   --  mcc.gui.image (spec)
   --  mcc.gui.image (body)
   --  mcc.gui.menu (spec)
   --  mcc.gui.menu (body)
   --  mcc.gui.widget (spec)
   --  mcc.gui.widget.button (spec)
   --  actions (spec)
   --  actions (body)
   --  mcc.gui.widget.button.picture (spec)
   --  mcc.gui.widget.button.picture (body)
   --  mcc.gui.widget.button.text (spec)
   --  mcc.gui.widget.button.text (body)
   --  main_window (spec)
   --  main_window (body)
   --  simple (body)
   --  mcc.gui.widget.dropdown (spec)
   --  mcc.gui.widget.dropdown (body)
   --  mcc.gui.widget.label (spec)
   --  mcc.gui.widget.label (body)
   --  mcc.gui.widget.listbox (spec)
   --  mcc.gui.widget.listbox (body)
   --  mcc.gui.fonts (body)
   --  mcc.gui.widget.progress (spec)
   --  mcc.gui.widget.progress (body)
   --  mcc.gui.widget.textbox (spec)
   --  mcc.gui.widget.textbox (body)
   --  mcc.gui.widget (body)
   --  my_expanding_array (spec)
   --  mcc.gui.widget.button (body)
   --  mcc.gui (body)
   --  tcl.tk (spec)
   --  tcl.tk (body)
   --  mcc.gui.container.window (body)
   --  peer (body)
   --  tcl_utilities (spec)
   --  tcl_utilities (body)
   --  mcc.common_dialogs (body)
   --  END ELABORATION ORDER

end ada_main;
