-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
-----------------------------------------------------------------------------
with Gdk;
with Gdk.Font;
with Gtk.Style;
with Gtk.Widget;
with peer.Style;
with System;
with Ada.Unchecked_Conversion;
with Glib.Object;

package body mcc.Gui.Fonts is
   type String_Pointer is access all String;
   type Family_Array is array (Font_Family) of String_Pointer;
   type Style_Array is array (Font_Style) of String_Pointer;
   Family_Names : Family_Array :=
     (Serif      => new String'("times"),
      Sans_Serif => new String'("helvetica"),
      Monospaced => new String'("courier"));
   Style_Names  : Style_Array  :=
     (Plain       => new String'("-medium-r-"),
      Bold        => new String'("-bold-r-"),
      Italic      => new String'("-medium-i-"),
      Bold_Italic => new String'("-bold-i-"));
   function Convert is new Ada.Unchecked_Conversion (
      Gdk.Font.Gdk_Font,
      peer.peer);
   function Convert is new Ada.Unchecked_Conversion (
      peer.peer,
      Gdk.Font.Gdk_Font);
   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Font;
      Family : in Font_Family := Serif;
      Size   : in Font_Size   := 12;
      Style  : in Font_Style  := Plain)
   is
      function Font_Image (Size : Font_Size) return String is
         x : String := Font_Size'Image (Size);
      begin
         return x (x'First + 1 .. x'Last);
      end Font_Image;
      Font : Gdk.Font.Gdk_Font;
   begin
      -- -foundry-family-weight-slant-width- -pixel sz-pt sz-res x-res y
      -- -spacing-avg width-registry-encoding
      Gdk.Font.Load
        (Font      => Font,
         Font_Name => "-*-" &
                      Family_Names (Family).all &
                      Style_Names (Style).all &
                      "*- -" &
                      Font_Image (Size) &
                      "-*-*-*-*-*-*-*");
      Obj.My_Peer := Convert (Font);
   end Create;

   --------------
   -- Set_Font --
   --------------

   -- This function is no longer available through GtkAda
   -- as it has been deprecated in gtk:
   -- void gtk_style_set_font (GtkStyle     *style,
   --                           GdkFont      *font);
   procedure gtk_style_set_font
     (style : System.Address;
      font  : Gdk.Font.Gdk_Font);
   pragma Import (C, gtk_style_set_font, "gtk_style_set_font");

   procedure Set_Font (Obj : in out Sized_Object'Class; New_Font : in Font) is
      old_style : Gtk.Style.Gtk_Style;
      new_style : Gtk.Style.Gtk_Style;
   begin
      --create a new_style
      old_style :=
         Gtk.Widget.Get_Style (Gtk.Widget.Gtk_Widget (Obj.My_Peer));
      new_style := Gtk.Style.Copy (old_style);
      gtk_style_set_font
        (Glib.Object.Get_Object (new_style),
         Convert (New_Font.My_Peer));
      peer.Style.Set_Style_Recursively
        (Widget => Gtk.Widget.Gtk_Widget (Obj.My_Peer),
         Style  => new_style);
   end Set_Font;

end Mcc.Gui.Fonts;
