-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Gdk;
with Gtk.Object;
with Gtk.Container;
with Gtk.Event_Box;
with Gtk.Label;
with mcc.Gui.Widget.Peer;
with mcc.Gui.Colors;      use mcc.Gui.Colors;
package body mcc.Gui.Widget.Rectangle is

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Rectangle;
      Parent : in mcc.Gui.Container.Container'Class;
      X      : in Integer;
      Y      : in Integer;
      Width  : in Natural;
      Height : in Natural)
   is
      New_Label     : Gtk.Label.Gtk_Label;
      New_Event_Box : Gtk.Event_Box.Gtk_Event_Box;
   begin
      Gtk.Event_Box.Gtk_New (New_Event_Box);
      Obj.My_Peer := Gtk.Object.Gtk_Object (New_Event_Box);
      mcc.Gui.Widget.Peer.Setup
        (Obj    => Obj,
         X      => X,
         Y      => Y,
         Width  => Width,
         Height => Height,
         Parent => Parent);

      Gtk.Label.Gtk_New (Label => New_Label, Str => "");
      Gtk.Container.Add
        (Container => Gtk.Container.Gtk_Container (New_Event_Box),
         Widget    => New_Label);
      Gtk.Label.Show (New_Label);
      Set_Background_Color (Obj, mcc.Gui.Colors.Named_Color (Black));
   end Create;

end Mcc.Gui.Widget.Rectangle;
