-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER         
--           MCC GUI PACKAGE LIBRARY                               
--           Copyright (C) 1999 Martin C. Carlisle.                
--                                                                 
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published  
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that 
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the 
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.  
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the 
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston, 
-- MA 02111-1307, USA.                                                 
--                                                                     
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an 
-- executable, this unit does not by itself cause the resulting 
-- executable to be covered by the GNU General Public License.  
-- This exception does not however invalidate any other reasons 
-- why the executable file might be covered by the GNU Public 
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
with Glib;
use Glib;
with Gdk;
with Gtk.Enums;
with Gtk.Widget;
with Gtk.Window;
with Gtk.Fixed;
with Gtk.Main;
with Gtk.Signal;
with mcc.Gtk_Signals;

package body Mcc.Gui.Container.Window is
   package Mcc_Window_Callback is new Mcc.Gtk_Signals.Object_Callback_Return(
      Base_Type    => Window,
      Return_Value => Glib.Guint);

   procedure Mcc_Resize_Callback(Mcc_Window : access Window) is
   begin
      if Mcc_Window.Resize_Callback /= null then
         Mcc_Window.Resize_Callback.all(Mcc_Window.all,
            Height =>0, Width => 0);
      end if;
   end Mcc_Resize_Callback;

   function Mcc_Close_Callback(Mcc_Window : access Window) return Glib.Guint is
   begin
      delay 3.0;
      Gtk.Signal.Emit_Stop_By_Name(
         Gtk.Fixed.Get_Parent(Gtk.Fixed.Gtk_Fixed (Mcc_Window.My_Peer)),
         "delete_event");
      return 1;
      if Mcc_Window.Close_Callback /= null then
         Mcc_Window.Close_Callback.all(Mcc_Window.all);
      elsif Window'Class(Mcc_Window.all) in Main_Window'Class then
         Gtk.Window.Destroy(
            Gtk.Window.Gtk_Window(
               Gtk.Fixed.Get_Parent(Gtk.Fixed.Gtk_Fixed (Mcc_Window.My_Peer))));
         Gtk.Main.Main_Quit;
      end if;
   end Mcc_Close_Callback;

   ------------
   -- Create --
   ------------

   --Each window is a window with a fixed frame inside.  Obj.My_Peer points
   --to the frame.  To access the window, must return frame's parent.
   procedure Common_Create (
         Obj    : in out Window'Class; 
         X      : in     Natural;      
         Y      : in     Natural;      
         Width  : in     Natural;      
         Height : in     Natural       ) is 

      Window : Gtk.Window.Gtk_Window;  
      Frame  : Gtk.Fixed.Gtk_Fixed;  

   begin --Common_Create

      Gtk.Window.Gtk_New(
        Window   => Window,                   
        The_Type => Gtk.Enums.Window_Toplevel);

      Gtk.Window.Set_Uposition(
        Widget => Window,   
        X      => Gint (X), 
        Y      => Gint (Y));

      Gtk.Window.Set_Default_Size (
        Window => Window,       
        Width  => Gint (Width), 
        Height => Gint (Height));

      --Create Frame inside of window
      Gtk.Fixed.Gtk_New(Widget => Frame);

      Gtk.Fixed.Set_Usize (
        Widget => Frame,        
        Width  => Gint (Width), 
        Height => Gint (Height));

      --Add Frame to window
      Gtk.Window.Add(
        Container => Window, 
        Widget    => Frame);
      Gtk.Fixed.Show(Frame);
      --Set object to point to window
      Obj.My_Peer := Gdk.Root_Type_Access(Frame);
      Show(Obj);
   end Common_Create;

   procedure Create (
         Obj    : in out Main_Window; 
         X      : in     Natural;     
         Y      : in     Natural;     
         Width  : in     Natural;     
         Height : in     Natural      ) is 

      Cb_Id  : Glib.Guint;  
      Window : Gtk.Widget.Gtk_Widget;  

   begin
      Common_Create(
        Obj    => Obj,   
        X      => X,     
        Y      => Y,     
        Width  => Width, 
        Height => Height);

      Window := Gtk.Fixed.Get_Parent(Widget => Gtk.Fixed.Gtk_Fixed (Obj.My_Peer));
      Cb_Id  := Mcc_Window_Callback.Connect(
        Obj  => Gtk.Window.Gtk_Window (Window), 
        Name => "delete_event",                      
        Func => Mcc_Close_Callback'access,
        Slot_Object => Obj'unchecked_access,
        After  => False);
   end Create;

   ------------
   -- Create --
   ------------

   procedure Create (
         Obj    : in out Subwindow; 
         X      : in     Natural;   
         Y      : in     Natural;   
         Width  : in     Natural;   
         Height : in     Natural    ) is 
   begin
      Common_Create(
        Obj    => Obj,   
        X      => X,     
        Y      => Y,     
        Width  => Width, 
        Height => Height);
   end Create;

   ----------------
   -- Event_Loop --
   ----------------

   procedure Event_Loop is 
   begin
      Gtk.Main.Main;
   end Event_Loop;

   -----------------------
   -- Get_Close_Handler --
   -----------------------

   function Get_Close_Handler (
         Obj : in     Window'Class ) 
     return Close_Handler is 
   begin
      return Obj.Close_Callback;
   end Get_Close_Handler;

   ------------------------
   -- Get_Resize_Handler --
   ------------------------

   function Get_Resize_Handler (
         Obj : in     Window'Class ) 
     return Resize_Handler is 
   begin
      return Obj.Resize_Callback;
   end Get_Resize_Handler;

   ----------
   -- Hide --
   ----------

   procedure Hide (
         Obj : in     Window ) is 
      Window : Gtk.Widget.Gtk_Widget;  
   begin
      Window := Gtk.Fixed.Get_Parent(Widget => Gtk.Fixed.Gtk_Fixed (Obj.My_Peer));
      Gtk.Widget.Hide(Widget => Window);
   end Hide;

   -----------------------
   -- Set_Close_Handler --
   -----------------------

   procedure Set_Close_Handler (
         Obj     : in     Window_Pointer; 
         Handler : in     Close_Handler   ) is 
   begin
      Obj.Close_Callback := Handler;
   end Set_Close_Handler;

   ------------------------
   -- Set_Resize_Handler --
   ------------------------

   procedure Set_Resize_Handler (
         Obj     : in     Window_Pointer; 
         Handler : in     Resize_Handler  ) is 
   begin
      Obj.Resize_Callback := Handler;
   end Set_Resize_Handler;

   ---------------
   -- Set_Title --
   ---------------

   procedure Set_Title (
         Obj   : in out Window; 
         Title : in     String  ) is 
      Window : Gtk.Widget.Gtk_Widget;  
   begin
      Window := Gtk.Fixed.Get_Parent(Widget => Gtk.Fixed.Gtk_Fixed (Obj.My_Peer));
      Gtk.Window.Set_Title(
        Window => Gtk.Window.Gtk_Window (Window), 
        Title  => Title);
   end Set_Title;

   ----------
   -- Show --
   ----------

   procedure Show (
         Obj : in     Window ) is 
      Window : Gtk.Widget.Gtk_Widget;  
   begin
      Window := Gtk.Fixed.Get_Parent(Widget => Gtk.Fixed.Gtk_Fixed (Obj.My_Peer));
      Gtk.Widget.Show(Widget => Window);
   end Show;

   ------------
   -- To_Top --
   ------------

   procedure To_Top (
         Obj : in     Window ) is 
      Window : Gtk.Widget.Gtk_Widget;  
   begin
      Window := Gtk.Fixed.Get_Parent(Widget => Gtk.Fixed.Gtk_Fixed (Obj.My_Peer));
      Gtk.Widget.Hide(Widget => Window);
      Gtk.Widget.Show(Widget => Window);
   end To_Top;
begin
   Gtk.Main.Set_Locale;
   Gtk.Main.Init;
end Mcc.Gui.Container.Window;