-------------------------------------------------------------
-- This file is free software; you can redistribute it and/or
-- modify without restriction.  We do ask that you please keep
-- the original author information, and clearly indicate if the
-- software has been modified.
--
-- This software is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
--
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
-------------------------------------------------------------
with Ada.Unchecked_Deallocation;
package body Expanding_Array is

   ------------
   -- Insert --
   ------------

   procedure Insert
     (Table    : in out Expander;
      Element  : in Element_Type;
      Location : out Natural)
   is
      procedure Free is new Ada.Unchecked_Deallocation (
         Object => Element_Array,
         Name => Element_Array_Pointer);
      New_Table : Element_Array_Pointer;
   begin
      if Table.Size = Table.Table'Last then
         New_Table                   :=
           new Element_Array (1 .. Table.Size * 2);
         New_Table (1 .. Table.Size) := Table.Table (1 .. Table.Size);
         Free (Table.Table);
         Table.Table := New_Table;
      end if;

      Table.Size               := Table.Size + 1;
      Table.Table (Table.Size) := Element;
      Location                 := Table.Size;
   end Insert;

   -------------
   -- Replace --
   -------------

   procedure Replace
     (Table    : in out Expander;
      Element  : in Element_Type;
      Location : in Natural)
   is
   begin
      Table.Table (Location) := Element;
   end Replace;

   --------------
   -- Retrieve --
   --------------

   function Retrieve
     (Table    : Expander;
      Location : Natural)
      return     Element_Type
   is
   begin
      return Table.Table (Location);
   end Retrieve;

end Expanding_Array;
