---------------------------------------------------------------
--
--  RAPID - Rapid Ada Portable Interface Designer
--
--  GUI-WIDGET-SCALE.ADS
--  Description : GUI Widget Scale
--
--  By: Martin Carlisle, Patrick Maes, and W. Blair Watkinson II
--
-- RAPID is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- RAPID is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
--
-- Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
---------------------------------------------------------------
with mcc.Gui.Widget.Text_Entry;
with mcc.Gui.Widget.Button.Radio;
with mcc.Gui.Widget.Scale;
with mcc.Gui.Container;

package gui.Widget.Scale is

   type Scale is new gui.Widget.GUI_Widget with record
      Min        : Integer := 1;
      Max        : Integer := 100;
      By         : Integer := 10;
      Mark_Every : Integer := 10;
      -- Pick either vertical or horizontal (default horizontal)
      Orientation : mcc.Gui.Widget.Scale.Scale_Orientation :=
        mcc.Gui.Widget.Scale.Horizontal;
      -- pointers into dialog
      Min_Entry    : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Max_Entry    : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      By_Entry     : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Mark_Entry   : mcc.Gui.Widget.Text_Entry.Text_Entry_Pointer;
      Orient_Group : mcc.Gui.Widget.Button.Radio.Radio_Group_Pointer;
      Horiz_Radio  : mcc.Gui.Widget.Button.Radio.Radio_Pointer;
      Vert_Radio   : mcc.Gui.Widget.Button.Radio.Radio_Pointer;
   end record;

   -- reads information from file into GUI_Widget,
   -- assumes keyword already read.
   procedure Read_Widget (Widget : in out Scale);

   -- Writes information to file from GUI_Widget
   procedure Write_Widget (Widget : in Scale);

   -- wbw 6/6/99
   procedure Generate_Widget_Context_Clause
     (Widget : in Scale);

   -- wbw 6/6/99
   procedure Generate_Widget_Declaration
     (Widget : in Scale);

   -- wbw 5/10/99
   procedure Generate_Widget_Creation
     (Widget      : in Scale;
      Window_Name : in String);

   procedure Display_Widget
     (Widget    : in out Scale;
      Container : in out mcc.Gui.Container.Container'Class);

   procedure Set_Properties (Widget : in out Scale);

   procedure Apply_Properties (Widget : in out Scale);

   procedure Check_Properties (Widget : in out Scale; Ok : out Boolean);

end Gui.Widget.Scale;
