-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER
--           MCC GUI PACKAGE LIBRARY - TCL IMPLEMENTATION
--           Copyright (C) 1999 Martin C. Carlisle.
--
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston,
-- MA 02111-1307, USA.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
-----------------------------------------------------------------------------
with mcc.Gui.Widget.Listbox;
package body mcc.Gui.Fonts is
   type String_Pointer is access all String;
   type Family_Array is array (Font_Family) of String_Pointer;
   type Style_Array is array (Font_Style) of String_Pointer;
   Family_Names : Family_Array :=
     (Serif      => new String'("Times"),
      Sans_Serif => new String'("Helvetica"),
      Monospaced => new String'("Courier"));
   Style_Names  : Style_Array  :=
     (Plain       => new String'(""),
      Bold        => new String'("bold"),
      Italic      => new String'("italic"),
      Bold_Italic => new String'("{ bold italic }"));

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Font;
      Family : in Font_Family := Serif;
      Size   : in Font_Size   := 12;
      Style  : in Font_Style  := Plain)
   is
   begin
      Obj.My_Peer.Name :=
        new String'("{ " &
                    Family_Names (Family).all &
                    Font_Size'Image (Size) &
                    " " &
                    Style_Names (Style).all &
                    "}");
   end Create;

   --------------
   -- Set_Font --
   --------------

   procedure Set_Font (Obj : in out Sized_Object'Class; New_Font : in Font) is
   begin
      if Sized_Object'Class (Obj) in mcc.Gui.Widget.Listbox.Listbox'Class then
         peer.Eval
           (Obj.My_Peer.Name.all &
            ".list configure -font " &
            New_Font.My_Peer.Name.all);
      else
         peer.Eval
           (Obj.My_Peer.Name.all &
            " configure -font " &
            New_Font.My_Peer.Name.all);
      end if;
   end Set_Font;

end Mcc.Gui.Fonts;
