---------------------------------------------------------------
--
--  GENERATE_HELPERS
--  Description : Use to auto generate either Tcl or Ada (TASH) code
--
--  Copyright (C) 1999, Martin C. Carlisle <carlislem@acm.org>
--
-- This is free software; you can redistribute it and/or
-- modify it without restriction.  However, we ask that you
-- please retain the original author information, and clearly
-- indicate if it has been modified.
--
-- This is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
--
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an
-- executable, this unit does not by itself cause the resulting
-- executable to be covered by the GNU General Public License.
-- This exception does not however invalidate any other reasons
-- why the executable file might be covered by the GNU Public
-- License.
---------------------------------------------------------------

package Generate_Helpers is

   -- Expects 'Action' to start with a valid Ada subprogram name.
   -- Writes this name to the given output file.
   -- Does not transfer possible parameters that follow after the
   -- subprogram name in 'Action'.
   procedure Generate_Subprogram_Name (Action : in String);

   -- Generate context clause for package
   procedure Generate_With (Pkg : in String);

   -- Generate context clause needed for fully qualified variable name
   procedure Generate_With_For_FQN (FQN : in String);

   -- Reset the "with list". This is an internal list of all withed units
   -- and is needed to avoid generating multiple "with" statements for
   -- the same package.
   procedure Reset_Withlist;

   -- return name with "." converted to "_"
   function Undot_Name (Name : in String) return String;

   -- make sure every " inside is ""
   function Quote_String (Item : in String) return String;

end Generate_Helpers;

