-------------------------------------------------------------------
--           RAPID - RAPID ADA PORTABLE INTERFACE DESIGNER         
--           MCC GUI PACKAGE LIBRARY                               
--           Copyright (C) 1999 Martin C. Carlisle.                
--                                                                 
-- RAPID is free software;  you can  redistribute it  and/or modify
-- it under terms of the  GNU General Public License as published  
-- by the Free Software  Foundation;  either version 2,  or (at your
-- option) any later version.  RAPID is distributed in the hope that 
-- it will be useful, but WITHOUT ANY WARRANTY;  without even the 
-- implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
-- PURPOSE.  See the GNU General Public License for more details.  
-- You should have  received  a copy of the GNU General Public License
-- distributed with RAPID; see file COPYING.  If not, write to the 
-- Free Software Foundation,  59 Temple Place - Suite 330,  Boston, 
-- MA 02111-1307, USA.                                                 
--                                                                     
-- As a special exception, if other files instantiate generics from
-- this unit, or you link this unit with other files to produce an 
-- executable, this unit does not by itself cause the resulting 
-- executable to be covered by the GNU General Public License.  
-- This exception does not however invalidate any other reasons 
-- why the executable file might be covered by the GNU Public 
-- License.  This exception does not apply to executables which
-- are GUI design tools, or that could act as a replacement
-- for RAPID.
------------------------------------------------------------------------------
package body Mcc.Gui.Widget.Text_Entry is

   -----------
   -- Clear --
   -----------

   procedure Clear (Obj  : in out Text_Entry) is
   begin
      null;
   end Clear;

   ------------
   -- Create --
   ------------

   procedure Create
     (Obj    : in out Text_Entry;
      Parent : in     Mcc.Gui.Container.Container'Class;
      X      : in     Integer;
      Y      : in     Integer;
      Width  : in     Natural;
      Height : in     Natural)
   is
   begin
      null;
   end Create;

   procedure Disable(Obj : in out Text_Entry) is
   begin
      null;
   end Disable;

   procedure Enable(Obj : in out Text_Entry) is
   begin
      null;
   end Enable;

   --------------
   -- Get_Text --
   --------------

   function Get_Text (Obj : in Text_Entry) return String is
   begin
      return Get_Text (Obj);
   end Get_Text;

   --------------
   -- Get_Text --
   --------------

   function Get_Text (Obj : in Text_Entry) return Integer is
   begin
      return Get_Text (Obj);
   end Get_Text;

   --------------
   -- Get_Text --
   --------------

   function Get_Text (Obj : in Text_Entry) return Float is
   begin
      return Get_Text (Obj);
   end Get_Text;

   ---------------------
   -- Get_Text_Length --
   ---------------------

   function Get_Text_Length (Obj : in Text_Entry) return Natural is
   begin
      return Get_Text_Length (Obj);
   end Get_Text_Length;

   ---------------
   -- Highlight --
   ---------------

   procedure Highlight (Obj : in out Text_Entry) is
   begin
      null;
   end Highlight;

   ---------------
   -- Highlight --
   ---------------

   procedure Highlight
     (Obj   : in out Text_Entry;
      Start : in     Natural;
      Stop  : in     Natural)
   is
   begin
      null;
   end Highlight;

   --------------
   -- Set_Text --
   --------------

   procedure Set_Text
     (Obj  : in out Text_Entry;
      Text : in     String)
   is
   begin
      null;
   end Set_Text;

   procedure Set_Text(Obj  : in out Text_Entry; Item : in Integer) is
      Text : constant String := Integer'Image (Item);
   begin
      if Text (1) = ' ' then
         -- set image of integer w/o leading space
         Set_Text(Obj, Text (2 .. Text'Last));
      else
         Set_Text(Obj, Text);
      end if;
   end Set_Text;

   procedure Set_Text(Obj  : in out Text_Entry; Item : in Float) is
      Text : constant String := Float'Image (Item);
   begin
      if Text (1) = ' ' then
         -- set image of float w/o leading space
         Set_Text(Obj, Text (2 .. Text'Last));
      else
         Set_Text(Obj, Text);
      end if;
   end Set_Text;

end Mcc.Gui.Widget.Text_Entry;

