/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.culture.sdx.search.lucene.query;

import fr.gouv.culture.sdx.utils.Utilities;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;

public class CachingRewrittenQueryWrapper
extends Query {
    protected Query originalQuery = null;
    protected ArrayList rewrittenQueries = new ArrayList();

    public CachingRewrittenQueryWrapper(Query originalQuery) {
        this.originalQuery = originalQuery;
    }

    public BooleanQuery getRewrittenQueries() {
        BooleanQuery l_rewrittenQueries = Utilities.newBooleanQuery();
        for (int i = 0; i < this.rewrittenQueries.size(); ++i) {
            Query rewrittenQuery = (Query)this.rewrittenQueries.get(i);
            l_rewrittenQueries.add(rewrittenQuery, BooleanClause.Occur.SHOULD);
        }
        return l_rewrittenQueries;
    }

    public void resetRewrittenQueries() {
        this.rewrittenQueries = new ArrayList();
    }

    public Query getOriginalQuery() {
        return this.originalQuery;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query rewrittenQuery = this.originalQuery.rewrite(reader);
        if (!this.rewrittenQueries.contains(rewrittenQuery)) {
            this.rewrittenQueries.add(rewrittenQuery);
        }
        return rewrittenQuery;
    }

    public Query combine(Query[] queries) {
        return this.originalQuery.combine(queries);
    }

    public Similarity getSimilarity(Searcher searcher) {
        return this.originalQuery.getSimilarity(searcher);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    public String toString() {
        return this.originalQuery.toString();
    }

    public String toString(String field) {
        return this.originalQuery.toString(field);
    }
}

