/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml.xpath;

import java.util.HashMap;
import javax.xml.transform.TransformerException;
import org.apache.avalon.excalibur.xml.xpath.EmptyNodeList;
import org.apache.avalon.excalibur.xml.xpath.XPathProcessor;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.XPathAPI;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class XPathProcessorImpl
extends AbstractLogEnabled
implements XPathProcessor,
Configurable,
PrefixResolver,
Component,
ThreadSafe {
    private String m_baseURI;
    private final HashMap m_mappings = new HashMap();

    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration namespaceMappings = configuration.getChild("namespace-mappings", true);
        this.m_baseURI = namespaceMappings.getAttribute("base-uri", null);
        Configuration[] namespaces = namespaceMappings.getChildren("namespace");
        int i = 0;
        while (i < namespaces.length) {
            String prefix = namespaces[i].getAttribute("prefix");
            String uri = namespaces[i].getAttribute("uri");
            this.m_mappings.put(prefix, uri);
            ++i;
        }
    }

    public Node selectSingleNode(Node contextNode, String str) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (PrefixResolver)this);
            return result.nodeset().nextNode();
        }
        catch (TransformerException te) {
            return null;
        }
    }

    public NodeList selectNodeList(Node contextNode, String str) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (PrefixResolver)this);
            return result.nodelist();
        }
        catch (TransformerException te) {
            return new EmptyNodeList();
        }
    }

    public boolean evaluateAsBoolean(Node contextNode, String str) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (PrefixResolver)this);
            return result.bool();
        }
        catch (TransformerException te) {
            return false;
        }
    }

    public Number evaluateAsNumber(Node contextNode, String str) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (PrefixResolver)this);
            return new Double(result.num());
        }
        catch (TransformerException te) {
            return null;
        }
    }

    public String evaluateAsString(Node contextNode, String str) {
        try {
            XObject result = XPathAPI.eval((Node)contextNode, (String)str, (PrefixResolver)this);
            return result.str();
        }
        catch (TransformerException te) {
            return null;
        }
    }

    public String getBaseIdentifier() {
        return this.m_baseURI;
    }

    public String getNamespaceForPrefix(String prefix) {
        return (String)this.m_mappings.get(prefix);
    }

    public String getNamespaceForPrefix(String prefix, Node node) {
        return this.getNamespaceForPrefix(prefix);
    }

    public boolean handlesNullPrefixes() {
        return true;
    }
}

