/*
 * Decompiled with CFR 0.152.
 */
package org.jfor.jfor.rtflib.rtfdoc;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.jfor.jfor.rtflib.rtfdoc.RtfAttributes;
import org.jfor.jfor.rtflib.rtfdoc.RtfContainer;
import org.jfor.jfor.rtflib.rtfdoc.RtfElement;
import org.jfor.jfor.tools.ImageConstants;
import org.jfor.jfor.tools.ImageUtil;
import org.jfor.jfor.tools.jpeg.Encoder;
import org.jfor.jfor.tools.jpeg.JPEGException;

public class RtfExternalGraphic
extends RtfElement {
    protected URL url = null;
    protected int height = -1;
    protected int heightPercent = -1;
    protected int heightDesired = -1;
    protected boolean perCentH = false;
    protected int width = -1;
    protected int widthPercent = -1;
    protected int widthDesired = -1;
    protected boolean perCentW = false;
    protected boolean scaleUniform = false;
    protected int graphicCompressionRate = 80;

    public RtfExternalGraphic(RtfContainer rtfContainer, Writer writer) throws IOException {
        super(rtfContainer, writer);
    }

    public RtfExternalGraphic(RtfContainer rtfContainer, Writer writer, RtfAttributes rtfAttributes) throws IOException {
        super(rtfContainer, writer, rtfAttributes);
    }

    protected void writeRtfContent() throws IOException {
        try {
            this.writeRtfContentWithException();
        }
        catch (ExternalGraphicException externalGraphicException) {
            this.writeExceptionInRtf(externalGraphicException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeRtfContentWithException() throws IOException {
        int n;
        Object object;
        int n2;
        Object object2;
        byte[] byArray;
        block44: {
            int n3;
            if (this.m_writer == null) {
                return;
            }
            if (this.url == null) {
                throw new ExternalGraphicException("The attribute 'url' of <fo:external-graphic> is null.");
            }
            this.getRtfFile().getLog().logInfo("Writing image '" + this.url + "'.");
            byArray = null;
            try {
                object2 = new BufferedInputStream(this.url.openStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while (true) {
                    if ((n3 = ((BufferedInputStream)object2).read()) == -1) {
                        byteArrayOutputStream.flush();
                        byArray = byteArrayOutputStream.toByteArray();
                        break;
                    }
                    byteArrayOutputStream.write(n3);
                }
            }
            catch (Exception exception) {
                throw new ExternalGraphicException("The attribute 'src' of <fo:external-graphic> has a invalid value: '" + this.url + "' (" + exception + ")");
            }
            if (byArray == null) {
                return;
            }
            object2 = this.url.getFile();
            n2 = this.determineImageType(byArray, ((String)object2).substring(((String)object2).lastIndexOf(".") + 1));
            if (n2 >= ImageConstants.I_TO_CONVERT_BASIS) {
                n3 = ImageConstants.CONVERT_TO[n2 - ImageConstants.I_TO_CONVERT_BASIS];
                if (n3 == ImageConstants.I_JPG) {
                    object = null;
                    try {
                        Object var8_13;
                        try {
                            object = new ByteArrayOutputStream();
                            Encoder encoder = new Encoder(this.graphicCompressionRate, (OutputStream)object);
                            encoder.encodeJPEG(byArray);
                            byArray = ((ByteArrayOutputStream)object).toByteArray();
                            n2 = n3;
                        }
                        catch (JPEGException jPEGException) {
                            jPEGException.setMessage("Image from tag <fo:external-graphic> could not be created (src = '" + this.url + "'");
                            var8_13 = null;
                            ((ByteArrayOutputStream)object).close();
                            break block44;
                        }
                        var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        ((ByteArrayOutputStream)object).close();
                        throw throwable;
                    }
                    ((ByteArrayOutputStream)object).close();
                } else {
                    n2 = ImageConstants.I_NOT_SUPPORTED;
                }
            }
        }
        if (n2 == ImageConstants.I_NOT_SUPPORTED) {
            throw new ExternalGraphicException("The tag <fo:external-graphic> does not support " + ((String)object2).substring(((String)object2).lastIndexOf(".") + 1) + " - image type.");
        }
        String string = ImageConstants.RTF_TAGS[n2];
        this.writeGroupMark(true);
        this.writeStarControlWord("shppict");
        this.writeGroupMark(true);
        this.writeControlWord("pict");
        object = new StringBuffer(byArray.length * 3);
        this.writeControlWord(string);
        if (n2 == ImageConstants.I_PNG) {
            this.width = ImageUtil.getIntFromByteArray(byArray, 16, 4, true);
            this.height = ImageUtil.getIntFromByteArray(byArray, 20, 4, true);
        } else if (n2 == ImageConstants.I_JPG) {
            int n4 = -1;
            n = -1;
            int n5 = -64;
            int n6 = 0;
            while (n6 < byArray.length) {
                int n7 = byArray[n6];
                if (n7 == n && n6 != byArray.length - 1 && (n7 = byArray[n6 + 1]) == n5) {
                    n4 = n6 + 5;
                    break;
                }
                ++n6;
            }
            if (n4 != -1) {
                this.width = ImageUtil.getIntFromByteArray(byArray, n4 + 2, 2, true);
                this.height = ImageUtil.getIntFromByteArray(byArray, n4, 2, true);
            }
        } else if (n2 == ImageConstants.I_EMF) {
            this.width = ImageUtil.getIntFromByteArray(byArray, 151, 4, false);
            this.height = ImageUtil.getIntFromByteArray(byArray, 155, 4, false);
        }
        if (this.width != -1) {
            this.writeControlWord("picw" + this.width);
        }
        if (this.height != -1) {
            this.writeControlWord("pich" + this.height);
        }
        if (this.widthDesired != -1) {
            if (this.perCentW) {
                this.writeControlWord("picscalex" + this.widthDesired);
            } else {
                this.writeControlWord("picscalex" + this.widthDesired * 100 / this.width);
            }
            this.writeControlWord("picwgoal" + this.widthDesired);
        } else if (this.scaleUniform && this.heightDesired != -1) {
            if (this.perCentH) {
                this.writeControlWord("picscalex" + this.heightDesired);
            } else {
                this.writeControlWord("picscalex" + this.heightDesired * 100 / this.height);
            }
        }
        if (this.heightDesired != -1) {
            if (this.perCentH) {
                this.writeControlWord("picscaley" + this.heightDesired);
            } else {
                this.writeControlWord("picscaley" + this.heightDesired * 100 / this.height);
            }
            this.writeControlWord("pichgoal" + this.heightDesired);
        } else if (this.scaleUniform && this.widthDesired != -1) {
            if (this.perCentW) {
                this.writeControlWord("picscaley" + this.widthDesired);
            } else {
                this.writeControlWord("picscaley" + this.widthDesired * 100 / this.width);
            }
        }
        int n8 = 0;
        while (true) {
            if (n8 >= byArray.length) {
                n = ((StringBuffer)object).length();
                char[] cArray = new char[n];
                ((StringBuffer)object).getChars(0, n, cArray, 0);
                this.m_writer.write(cArray);
                this.writeGroupMark(false);
                this.writeGroupMark(false);
                return;
            }
            n = byArray[n8];
            if (n < 0) {
                n += 256;
            }
            if (n < 16) {
                ((StringBuffer)object).append('0');
            }
            ((StringBuffer)object).append(Integer.toHexString(n));
            ++n8;
        }
    }

    public void setHeight(String string) {
        this.heightDesired = ImageUtil.getInt(string);
        this.perCentH = ImageUtil.isPercent(string);
    }

    public void setWidth(String string) {
        this.widthDesired = ImageUtil.getInt(string);
        this.perCentW = ImageUtil.isPercent(string);
    }

    public void setScaling(String string) {
        if (string.equalsIgnoreCase("uniform")) {
            this.scaleUniform = true;
        }
    }

    public void setURL(String string) throws IOException {
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            try {
                uRL = new File(string).toURL();
            }
            catch (MalformedURLException malformedURLException2) {
                throw new ExternalGraphicException("The attribute 'src' of <fo:external-graphic> has a invalid value: '" + string + "' (" + malformedURLException2 + ")");
            }
        }
        this.url = uRL;
    }

    public int getCompressionRate() {
        return this.graphicCompressionRate;
    }

    public boolean setCompressionRate(int n) {
        if (n < 1 || n > 100) {
            return false;
        }
        this.graphicCompressionRate = n;
        return true;
    }

    private boolean isJPEG(byte[] byArray) {
        byte[] byArray2 = new byte[]{-1, -40};
        return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
    }

    private boolean isPNG(byte[] byArray) {
        byte[] byArray2 = new byte[]{80, 78, 71};
        return ImageUtil.compareHexValues(byArray2, byArray, 1, true);
    }

    private boolean isEMF(byte[] byArray) {
        byte[] byArray2 = new byte[]{1, 0, 0};
        return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
    }

    private boolean isGIF(byte[] byArray) {
        byte[] byArray2 = new byte[]{71, 73, 70, 56};
        return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
    }

    private boolean isBMP(byte[] byArray) {
        byte[] byArray2 = new byte[]{66, 77};
        return ImageUtil.compareHexValues(byArray2, byArray, 0, true);
    }

    private int determineImageType(byte[] byArray, String string) {
        int n = ImageConstants.I_NOT_SUPPORTED;
        if (this.isPNG(byArray)) {
            n = ImageConstants.I_PNG;
        } else if (this.isJPEG(byArray)) {
            n = ImageConstants.I_JPG_C;
        } else if (this.isEMF(byArray)) {
            n = ImageConstants.I_EMF;
        } else if (this.isGIF(byArray)) {
            n = ImageConstants.I_GIF;
        } else {
            Object v = ImageConstants.SUPPORTED_IMAGE_TYPES.get(string.toLowerCase());
            if (v != null) {
                n = (Integer)v;
            }
        }
        return n;
    }

    public boolean isEmpty() {
        return this.url == null;
    }

    public static class ExternalGraphicException
    extends IOException {
        ExternalGraphicException(String string) {
            super(string);
        }
    }
}

