/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeError
extends IdScriptable {
    private static final int Id_message = 1;
    private static final int Id_name = 2;
    private static final int MAX_INSTANCE_ID = 2;
    private static final int Id_constructor = 3;
    private static final int Id_toString = 4;
    private static final int MAX_PROTOTYPE_ID = 4;
    private Object messageValue = Scriptable.NOT_FOUND;
    private Object nameValue = Scriptable.NOT_FOUND;
    private boolean prototypeFlag;

    public static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeError nativeError = new NativeError();
        nativeError.prototypeFlag = true;
        nativeError.messageValue = "";
        nativeError.nameValue = "Error";
        nativeError.addAsPrototype(4, context, scriptable, bl);
    }

    protected int getIdDefaultAttributes(int n) {
        if (n == 1 || n == 2) {
            return 0;
        }
        return super.getIdDefaultAttributes(n);
    }

    protected boolean hasIdValue(int n) {
        if (n == 1) {
            return this.messageValue != Scriptable.NOT_FOUND;
        }
        if (n == 2) {
            return this.nameValue != Scriptable.NOT_FOUND;
        }
        return super.hasIdValue(n);
    }

    protected Object getIdValue(int n) {
        if (n == 1) {
            return this.messageValue;
        }
        if (n == 2) {
            return this.nameValue;
        }
        return super.getIdValue(n);
    }

    protected void setIdValue(int n, Object object) {
        if (n == 1) {
            this.messageValue = object;
            return;
        }
        if (n == 2) {
            this.nameValue = object;
            return;
        }
        super.setIdValue(n, object);
    }

    protected void deleteIdValue(int n) {
        if (n == 1) {
            this.messageValue = Scriptable.NOT_FOUND;
            return;
        }
        if (n == 2) {
            this.nameValue = Scriptable.NOT_FOUND;
            return;
        }
        super.deleteIdValue(n);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            if (n == 3) {
                return 1;
            }
            if (n == 4) {
                return 0;
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            if (n == 3) {
                return NativeError.jsConstructor(context, objectArray, idFunction, scriptable2 == null);
            }
            if (n == 4) {
                return this.realThis(scriptable2, idFunction).toString();
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private NativeError realThis(Scriptable scriptable, IdFunction idFunction) {
        while (!(scriptable instanceof NativeError)) {
            scriptable = this.nextInstanceCheck(scriptable, idFunction, true);
        }
        return (NativeError)scriptable;
    }

    private static Object jsConstructor(Context context, Object[] objectArray, Function function, boolean bl) {
        NativeError nativeError = new NativeError();
        if (objectArray.length >= 1) {
            nativeError.messageValue = ScriptRuntime.toString(objectArray[0]);
        }
        nativeError.setPrototype(ScriptableObject.getClassPrototype(function, "Error"));
        return nativeError;
    }

    public String getClassName() {
        return "Error";
    }

    public String toString() {
        Object object = ScriptableObject.getProperty((Scriptable)this, "name");
        if (object == Scriptable.NOT_FOUND) {
            object = Undefined.instance;
        }
        return object + ": " + this.getMessage();
    }

    public String getName() {
        Object object = this.nameValue;
        return ScriptRuntime.toString(object != Scriptable.NOT_FOUND ? object : Undefined.instance);
    }

    public String getMessage() {
        Object object = this.messageValue;
        return ScriptRuntime.toString(object != Scriptable.NOT_FOUND ? object : Undefined.instance);
    }

    protected int maxInstanceId() {
        return 2;
    }

    protected String getIdName(int n) {
        if (n == 1) {
            return "message";
        }
        if (n == 2) {
            return "name";
        }
        if (this.prototypeFlag) {
            if (n == 3) {
                return "constructor";
            }
            if (n == 4) {
                return "toString";
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        int n = 0;
        String string2 = null;
        int n2 = string.length();
        if (n2 == 4) {
            string2 = "name";
            n = 2;
        } else if (n2 == 7) {
            string2 = "message";
            n = 1;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        if (n != 0 || !this.prototypeFlag) {
            return n;
        }
        n = 0;
        string2 = null;
        n2 = string.length();
        if (n2 == 8) {
            string2 = "toString";
            n = 4;
        } else if (n2 == 11) {
            string2 = "constructor";
            n = 3;
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

