/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.de;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.de.GermanStemmer;

public final class GermanStemFilter
extends TokenFilter {
    private Token token = null;
    private GermanStemmer stemmer = new GermanStemmer();
    private Hashtable exclusions = null;

    public GermanStemFilter(TokenStream in) {
        super(in);
    }

    public GermanStemFilter(TokenStream in, Hashtable exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        if (this.exclusions != null && this.exclusions.contains(this.token.termText())) {
            return this.token;
        }
        String s = this.stemmer.stem(this.token.termText());
        if (!s.equals(this.token.termText())) {
            return new Token(s, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(GermanStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionTable(Hashtable exclusiontable) {
        this.exclusions = exclusiontable;
    }
}

