/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractValidatorAction;
import org.apache.cocoon.acting.ValidatorActionHelper;
import org.apache.cocoon.acting.ValidatorActionResult;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.Tokenizer;

public class FormValidatorAction
extends AbstractValidatorAction
implements ThreadSafe {
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        Request req = ObjectModelHelper.getRequest(objectModel);
        if (req == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No request object");
            }
            return null;
        }
        boolean reloadable = true;
        if (this.settings.containsKey("reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get("reloadable"));
        }
        try {
            Configuration conf = this.getConfiguration(parameters.getParameter("descriptor", (String)this.settings.get("descriptor")), resolver, parameters.getParameterAsBoolean("reloadable", reloadable));
            String valstr = parameters.getParameter("validate", (String)this.settings.get("validate", ""));
            String valsetstr = parameters.getParameter("validate-set", (String)this.settings.get("validate-set", ""));
            Configuration[] desc = conf.getChildren("parameter");
            Configuration[] csets = conf.getChildren("constraint-set");
            HashMap<String, Object> actionMap = new HashMap<String, Object>();
            HashMap<String, ValidatorActionResult> resultMap = new HashMap<String, ValidatorActionResult>();
            boolean allOK = true;
            if (!"".equals(valstr.trim())) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Validating parameters as specified via 'validate' parameter");
                }
                String[] rparams = null;
                if (!"*".equals(valstr.trim())) {
                    rparams = Tokenizer.tokenize(valstr, ",", false);
                } else {
                    rparams = new String[desc.length];
                    int i = 0;
                    while (i < desc.length) {
                        rparams[i] = desc[i].getAttribute("name", "");
                        if ("".equals(rparams[i])) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("Wrong syntax of the 'validate' parameter");
                            }
                            return null;
                        }
                        ++i;
                    }
                }
                ValidatorActionHelper result = null;
                String name = null;
                HashMap<String, String> params = new HashMap<String, String>(rparams.length);
                int i = 0;
                while (i < rparams.length) {
                    name = rparams[i];
                    if (name == null || "".equals(name.trim())) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Wrong syntax of the 'validate' parameter");
                        }
                        return null;
                    }
                    name = name.trim();
                    params.put(name, req.getParameter(name));
                    ++i;
                }
                int i2 = 0;
                while (i2 < rparams.length) {
                    name = rparams[i2].trim();
                    result = this.validateParameter(name, null, desc, params, true);
                    if (!result.isOK()) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Validation failed for parameter " + name);
                        }
                        allOK = false;
                    }
                    actionMap.put(name, result.getObject());
                    resultMap.put(name, result.getResult());
                    ++i2;
                }
            }
            if (!"".equals(valsetstr.trim())) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Validating parameters from given constraint-set " + valsetstr);
                }
                Configuration cset = null;
                String setname = null;
                int j = 0;
                boolean found = false;
                j = 0;
                while (j < csets.length) {
                    setname = csets[j].getAttribute("name", "");
                    if (valsetstr.trim().equals(setname.trim())) {
                        found = true;
                        break;
                    }
                    ++j;
                }
                if (!found) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Given set " + valsetstr + " does not exist in a description file");
                    }
                    return null;
                }
                cset = csets[j];
                Configuration[] set = cset.getChildren("validate");
                ValidatorActionHelper result = null;
                String name = null;
                HashMap<String, Object> params = new HashMap<String, Object>(set.length);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Given set " + valsetstr + " contains " + set.length + " rules");
                }
                int i = 0;
                while (i < set.length) {
                    name = set[i].getAttribute("name", "").trim();
                    if ("".equals(name)) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Wrong syntax  of 'validate' children nr. " + i);
                        }
                        return null;
                    }
                    String[] values = req.getParameterValues(name);
                    if (values != null) {
                        switch (values.length) {
                            case 0: {
                                params.put(name, null);
                                break;
                            }
                            case 1: {
                                params.put(name, values[0]);
                                break;
                            }
                            default: {
                                params.put(name, values);
                                break;
                            }
                        }
                    } else {
                        params.put(name, values);
                    }
                    ++i;
                }
                String rule = null;
                int i3 = 0;
                while (i3 < set.length) {
                    name = set[i3].getAttribute("name", null);
                    result = this.validateParameter(name, rule = set[i3].getAttribute("rule", name), set[i3], desc, params, true);
                    if (!result.isOK()) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Validation failed for parameter " + name);
                        }
                        allOK = false;
                    }
                    actionMap.put(name, result.getObject());
                    resultMap.put(name, result.getResult());
                    ++i3;
                }
            }
            if (!allOK) {
                actionMap = null;
                resultMap.put("*", ValidatorActionResult.ERROR);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("All form params validated. An error occurred.");
                }
            } else {
                resultMap.put("*", ValidatorActionResult.OK);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("All form params successfully validated");
                }
            }
            req.setAttribute("org.apache.cocoon.acting.FormValidatorAction.results", resultMap);
            return actionMap;
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("exception: ", (Throwable)e);
            }
            return null;
        }
    }
}

