/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements;

import java.io.IOException;
import java.util.Hashtable;
import org.apache.cocoon.components.elementprocessor.ElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.BaseElementProcessor;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.EPStyle;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.UnderlineType;
import org.apache.cocoon.components.elementprocessor.impl.poi.hssf.elements.Workbook;
import org.apache.cocoon.components.elementprocessor.types.Attribute;
import org.apache.cocoon.components.elementprocessor.types.BooleanConverter;
import org.apache.cocoon.components.elementprocessor.types.BooleanResult;
import org.apache.cocoon.components.elementprocessor.types.NumericConverter;
import org.apache.cocoon.components.elementprocessor.types.NumericResult;
import org.apache.cocoon.components.elementprocessor.types.Validator;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.util.HSSFColor;

public class EPFont
extends BaseElementProcessor {
    private NumericResult _unit = null;
    private BooleanResult _bold = null;
    private BooleanResult _italic = null;
    private NumericResult _underline = null;
    private BooleanResult _strike_through = null;
    private String _font = null;
    private static final String _unit_attribute = "Unit";
    private static final String _bold_attribute = "Bold";
    private static final String _italic_attribute = "Italic";
    private static final String _underline_attribute = "Underline";
    private static final String _strike_through_attribute = "StrikeThrough";
    private static final Validator _underline_type_validator = new Validator(){

        public IOException validate(Number number) {
            return UnderlineType.isValid(number.intValue()) ? null : new IOException("\"" + number + "\" is not a legal value");
        }
    };

    public EPFont() {
        super(null);
    }

    public void initialize(Attribute[] attributes, ElementProcessor parent) throws IOException {
        super.initialize(attributes, parent);
        EPStyle pstyle = (EPStyle)parent;
        if (pstyle.isValid()) {
            Hashtable colorhash = pstyle.getColorHash();
            HSSFColor color = null;
            HSSFCellStyle style = pstyle.getStyle();
            Workbook workbook = this.getWorkbook();
            HSSFFont font = workbook.createFont();
            style.setFont(font);
            font.setFontHeightInPoints((short)this.getUnit());
            font.setFontName(this.getFont());
            font.setItalic(this.getItalic());
            if (this.getBold()) {
                font.setBoldweight((short)700);
            } else {
                font.setBoldweight((short)190);
            }
            font.setUnderline((byte)this.getUnderline());
            font.setStrikeout(this.getStrikeThrough());
            color = (HSSFColor)colorhash.get(pstyle.getForegroundColor().toString());
            if (color == null) {
                color = new HSSFColor.BLACK();
            }
            font.setColor(color.getIndex());
        }
    }

    public double getUnit() throws IOException {
        if (this._unit == null) {
            this._unit = NumericConverter.extractDouble(this.getValue(_unit_attribute));
        }
        return this._unit.doubleValue();
    }

    public boolean getBold() throws IOException {
        if (this._bold == null) {
            this._bold = BooleanConverter.extractBoolean(this.getValue(_bold_attribute));
        }
        return this._bold.booleanValue();
    }

    public boolean getItalic() throws IOException {
        if (this._italic == null) {
            this._italic = BooleanConverter.extractBoolean(this.getValue(_italic_attribute));
        }
        return this._italic.booleanValue();
    }

    public int getUnderline() throws IOException {
        if (this._underline == null) {
            this._underline = NumericConverter.extractInteger(this.getValue(_underline_attribute), _underline_type_validator);
        }
        return this._underline.intValue();
    }

    public boolean getStrikeThrough() throws IOException {
        if (this._strike_through == null) {
            this._strike_through = BooleanConverter.extractBoolean(this.getValue(_strike_through_attribute));
        }
        return this._strike_through.booleanValue();
    }

    public String getFont() {
        if (this._font == null) {
            this._font = this.getData();
        }
        return this._font;
    }
}

