/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.parser;

import java.io.IOException;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.cocoon.components.parser.Parser;
import org.apache.cocoon.components.resolver.Resolver;
import org.apache.cocoon.xml.AbstractXMLProducer;
import org.apache.xerces.dom.CoreDocumentImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.dom.DocumentTypeImpl;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.parsers.SAXParser;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XercesParser
extends AbstractXMLProducer
implements Parser,
ErrorHandler,
Composable,
Disposable {
    final SAXParser parser = new SAXParser();
    protected ComponentManager manager;
    protected Resolver resolver = null;

    public XercesParser() throws SAXException {
        this.parser.setFeature("http://xml.org/sax/features/validation", false);
        this.parser.setFeature("http://xml.org/sax/features/namespaces", true);
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.getLogger().debug("Looking up org.apache.cocoon.components.resolver.Resolver");
        if (manager.hasComponent("org.apache.cocoon.components.resolver.Resolver")) {
            this.resolver = (Resolver)manager.lookup("org.apache.cocoon.components.resolver.Resolver");
        }
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.resolver);
        }
    }

    public void parse(InputSource in) throws SAXException, IOException {
        this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", (Object)this.lexicalHandler);
        this.parser.setErrorHandler((ErrorHandler)this);
        this.parser.setContentHandler(this.contentHandler);
        if (this.resolver != null) {
            this.parser.setEntityResolver((EntityResolver)this.resolver);
        }
        this.parser.parse(in);
    }

    public Document newDocument() {
        return this.newDocument(null, null, null);
    }

    public Document newDocument(String name) {
        return this.newDocument(name, null, null);
    }

    public Document newDocument(String name, String pub, String sys) {
        DocumentImpl doc = new DocumentImpl();
        if (pub != null || sys != null) {
            DocumentTypeImpl dtd = new DocumentTypeImpl((CoreDocumentImpl)doc, name, pub, sys);
            doc.appendChild((Node)dtd);
        } else if (name != null) {
            DocumentTypeImpl dtd = new DocumentTypeImpl((CoreDocumentImpl)doc, name);
            doc.appendChild((Node)dtd);
        }
        return doc;
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        DOMParser parser = null;
        try {
            parser = new DOMParser();
            parser.setFeature("http://xml.org/sax/features/validation", false);
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.parse(input);
        }
        catch (Exception pce) {
            this.getLogger().error("Could not build DocumentBuilder", (Throwable)pce);
            return null;
        }
        return parser.getDocument();
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void warning(SAXParseException e) throws SAXException {
        throw new SAXException("Warning parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }
}

