/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.search;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import org.apache.cocoon.components.search.IndexHelperField;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.helpers.AttributesImpl;

public class LuceneIndexContentHandler
implements ContentHandler {
    public static final String LUCENE_URI = "http://apache.org/cocoon/lucene/1.0";
    public static final String LUCENE_ATTR_TO_TEXT_ATTRIBUTE = "text-attr";
    StringBuffer bodyText = new StringBuffer();
    private List documents;
    private Document bodyDocument = new Document();
    private Stack elementStack;

    public LuceneIndexContentHandler() {
        this.documents = new ArrayList();
        this.documents.add(this.bodyDocument);
        this.elementStack = new Stack();
    }

    public void setDocumentLocator(Locator locator) {
    }

    public List allDocuments() {
        return this.documents;
    }

    public Iterator iterator() {
        return this.documents.iterator();
    }

    public void characters(char[] ch, int start, int length) {
        if (ch.length > 0 && start >= 0 && length > 1) {
            String text = new String(ch, start, length);
            if (this.elementStack.size() > 0) {
                IndexHelperField tos = (IndexHelperField)this.elementStack.peek();
                tos.appendText(text);
            }
            this.bodyText.append(text);
        }
    }

    public void endDocument() {
        this.bodyDocument.add(Field.UnStored((String)"body", (String)this.bodyText.toString()));
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        IndexHelperField tos = (IndexHelperField)this.elementStack.pop();
        String lname = tos.getLocalFieldName();
        StringBuffer text = tos.getText();
        Attributes atts = tos.getAttributes();
        boolean attributesToText = atts.getIndex(LUCENE_URI, LUCENE_ATTR_TO_TEXT_ATTRIBUTE) != -1;
        int i = 0;
        while (i < atts.getLength()) {
            if (!LUCENE_URI.equals(atts.getURI(i))) {
                String atts_lname = atts.getLocalName(i);
                String atts_value = atts.getValue(i);
                this.bodyDocument.add(Field.UnStored((String)(lname + "@" + atts_lname), (String)atts_value));
                if (attributesToText) {
                    text.append(atts_value);
                    text.append(' ');
                    this.bodyText.append(atts_value);
                    this.bodyText.append(' ');
                }
            }
            ++i;
        }
        if (text != null && text.length() > 0) {
            this.bodyDocument.add(Field.UnStored((String)lname, (String)text.toString()));
        }
    }

    public void endPrefixMapping(String prefix) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void skippedEntity(String name) {
    }

    public void startDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        IndexHelperField ihf = new IndexHelperField(localName, qName, new AttributesImpl(atts));
        this.elementStack.push(ihf);
    }

    public void startPrefixMapping(String prefix, String uri) {
    }
}

