/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ConcurrentModificationException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.AbstractStreamWriteableSource;
import org.apache.cocoon.environment.WriteableSource;

public class FileSource
extends AbstractStreamWriteableSource
implements WriteableSource {
    private File file;
    private String systemId = null;
    private boolean isHTMLContent;

    public FileSource(String url, ComponentManager manager) {
        super(manager);
        if (!url.startsWith("file:")) {
            throw new IllegalArgumentException("Malformed url for a file source : " + url);
        }
        if (url.endsWith(".htm") || url.endsWith(".html")) {
            this.isHTMLContent = true;
        }
        this.file = new File(url.substring(5));
    }

    public boolean exists() {
        return this.file.exists();
    }

    protected boolean isHTMLContent() {
        return this.isHTMLContent;
    }

    public String getSystemId() {
        if (this.systemId == null) {
            try {
                this.systemId = this.file.toURL().toExternalForm();
            }
            catch (MalformedURLException mue) {
                this.systemId = "file:" + this.file.getPath();
            }
        }
        return this.systemId;
    }

    public InputStream getInputStream() throws IOException, ProcessingException {
        try {
            return new FileInputStream(this.file);
        }
        catch (FileNotFoundException e) {
            throw new ResourceNotFoundException("Resource not found " + this.getSystemId(), e);
        }
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public long getContentLength() {
        return this.file.length();
    }

    public OutputStream getOutputStream() throws IOException, ProcessingException {
        File tmpFile = new File(this.file.getPath() + ".tmp");
        tmpFile.getParentFile().mkdirs();
        if (this.file.exists() && !this.file.canWrite()) {
            throw new IOException("Cannot write to file " + this.file.getPath());
        }
        if (!tmpFile.createNewFile()) {
            throw new ConcurrentModificationException("File " + this.file.getPath() + " is already being written by another thread");
        }
        return new FileSourceOutputStream(tmpFile);
    }

    public boolean canCancel(OutputStream stream) {
        FileSourceOutputStream fsos;
        if (stream instanceof FileSourceOutputStream && (fsos = (FileSourceOutputStream)stream).getSource() == this) {
            return fsos.canCancel();
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    public void cancel(OutputStream stream) throws Exception {
        FileSourceOutputStream fsos;
        if (stream instanceof FileSourceOutputStream && (fsos = (FileSourceOutputStream)stream).getSource() == this) {
            fsos.cancel();
            return;
        }
        throw new IllegalArgumentException("The stream is not associated to this source");
    }

    private class FileSourceOutputStream
    extends FileOutputStream {
        private File tmpFile;
        private boolean isClosed = false;

        public FileSourceOutputStream(File tmpFile) throws IOException {
            super(tmpFile);
            this.tmpFile = tmpFile;
        }

        public FileSource getSource() {
            return FileSource.this;
        }

        public void close() throws IOException {
            block4: {
                super.close();
                try {
                    if (FileSource.this.file.exists()) {
                        FileSource.this.file.delete();
                    }
                    this.tmpFile.renameTo(FileSource.this.file);
                    Object var2_1 = null;
                    if (!this.tmpFile.exists()) break block4;
                    this.tmpFile.delete();
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    if (this.tmpFile.exists()) {
                        this.tmpFile.delete();
                    }
                    this.isClosed = true;
                    throw throwable;
                }
                {
                }
            }
            this.isClosed = true;
        }

        public boolean canCancel() {
            return !this.isClosed;
        }

        public void cancel() throws Exception {
            if (this.isClosed) {
                throw new IllegalStateException("Cannot cancel : outputstrem is already closed");
            }
            this.isClosed = true;
            super.close();
            this.tmpFile.delete();
        }

        public void finalize() {
            if (!this.isClosed && this.tmpFile.exists()) {
                this.tmpFile.delete();
            }
        }
    }
}

