/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Recomposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.NamespacedSAXConfigurationHandler;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.cocoon.components.ExtendedComponentSelector;
import org.apache.cocoon.components.LifecycleHelper;
import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.LinkedProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.ParameterizableProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNode;
import org.apache.cocoon.components.treeprocessor.ProcessingNodeBuilder;
import org.apache.cocoon.components.treeprocessor.TreeBuilder;
import org.apache.cocoon.components.treeprocessor.TreeProcessor;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolverFactory;
import org.apache.cocoon.environment.Source;
import org.apache.cocoon.sitemap.PatternException;
import org.xml.sax.ContentHandler;

public class DefaultTreeBuilder
extends AbstractLoggable
implements TreeBuilder,
Recomposable,
Configurable,
Contextualizable,
LogKitManageable,
RoleManageable,
Recyclable,
Disposable {
    protected TreeProcessor processor;
    protected Context context;
    protected LogKitManager logKit;
    protected ComponentManager parentManager;
    protected RoleManager parentRoleManager;
    protected Configuration configuration;
    protected ComponentManager manager;
    protected RoleManager roleManager;
    protected ComponentSelector builderSelector;
    protected LifecycleHelper lifecycle;
    protected String namespace;
    protected String parameterElement;
    protected String languageName;
    protected String fileName;
    private List initializableNodes = new ArrayList();
    private List disposableNodes = new ArrayList();
    private List linkedBuilders = new ArrayList();
    private boolean canGetNode = false;
    private Map registeredNodes = new HashMap();

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void setLogKitManager(LogKitManager logKit) {
        this.logKit = logKit;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.parentManager = manager;
    }

    public void recompose(ComponentManager manager) throws ComponentException {
        this.parentManager = manager;
    }

    public void setRoleManager(RoleManager rm) {
        this.parentRoleManager = rm;
    }

    public void configure(Configuration config2) throws ConfigurationException {
        this.configuration = config2;
        this.languageName = config2.getAttribute("name");
        this.getLogger().debug("Configuring Builder for language : " + this.languageName);
        this.fileName = config2.getChild("file").getAttribute("name");
        this.namespace = config2.getChild("namespace").getAttribute("uri", "");
        this.parameterElement = config2.getChild("parameter").getAttribute("element", "parameter");
    }

    protected RoleManager createRoleManager() throws Exception {
        DefaultRoleManager roles = new DefaultRoleManager();
        LifecycleHelper.setupComponent(roles, this.getLogger(), this.context, this.manager, this.parentRoleManager, this.logKit, this.configuration.getChild("roles"));
        return roles;
    }

    protected ComponentManager createComponentManager(Configuration tree) throws Exception {
        return this.parentManager;
    }

    protected ComponentSelector createBuilderSelector() throws Exception {
        ExtendedComponentSelector selector = new ExtendedComponentSelector(){

            protected String getComponentInstanceName() {
                return "node";
            }

            protected String getClassAttributeName() {
                return "builder";
            }
        };
        LifecycleHelper.setupComponent((Object)selector, this.getLogger(), this.context, this.manager, this.roleManager, this.logKit, this.configuration.getChild("nodes"));
        return selector;
    }

    public void setProcessor(TreeProcessor processor) {
        this.processor = processor;
    }

    public TreeProcessor getProcessor() {
        return this.processor;
    }

    public String getLanguage() {
        return this.languageName;
    }

    public String getParameterName() {
        return this.parameterElement;
    }

    public void registerNode(String name, ProcessingNode node) {
        this.registeredNodes.put(name, node);
    }

    public ProcessingNode getRegisteredNode(String name) {
        if (this.canGetNode) {
            return (ProcessingNode)this.registeredNodes.get(name);
        }
        throw new IllegalArgumentException("Categories are only available during buildNode()");
    }

    public ProcessingNodeBuilder createNodeBuilder(Configuration config2) throws Exception {
        ProcessingNodeBuilder builder;
        String nodeName = config2.getName();
        this.getLogger().debug("Creating node builder for " + nodeName);
        try {
            builder = (ProcessingNodeBuilder)this.builderSelector.select((Object)nodeName);
        }
        catch (ComponentException ce) {
            if (this.builderSelector.hasComponent((Object)nodeName)) {
                throw ce;
            }
            String msg = "Unkown element '" + nodeName + "' at " + config2.getLocation();
            this.getLogger().error(msg);
            throw new ConfigurationException(msg);
        }
        if (builder instanceof Recomposable) {
            ((Recomposable)builder).recompose(this.manager);
        }
        builder.setBuilder(this);
        if (builder instanceof LinkedProcessingNodeBuilder) {
            this.linkedBuilders.add(builder);
        }
        return builder;
    }

    protected ProcessingNode createTree(Configuration tree) throws Exception {
        ProcessingNodeBuilder rootBuilder = this.createNodeBuilder(tree);
        return rootBuilder.buildNode(tree);
    }

    protected void linkNodes() throws Exception {
        Iterator iter = this.linkedBuilders.iterator();
        while (iter.hasNext()) {
            ((LinkedProcessingNodeBuilder)iter.next()).linkNode();
        }
    }

    public String getNamespace() {
        return this.namespace;
    }

    public ProcessingNode build(Source source) throws Exception {
        try {
            NamespacedSAXConfigurationHandler handler = new NamespacedSAXConfigurationHandler();
            source.toSAX((ContentHandler)handler);
            Configuration treeConfig = handler.getConfiguration();
            return this.build(treeConfig);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to load " + this.languageName + " from " + source.getSystemId(), (Throwable)e);
            throw e;
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public ProcessingNode build(Configuration tree) throws Exception {
        this.roleManager = this.createRoleManager();
        this.manager = this.createComponentManager(tree);
        this.lifecycle = new LifecycleHelper(this.getLogger(), this.context, this.manager, this.roleManager, this.logKit, null);
        this.builderSelector = this.createBuilderSelector();
        this.canGetNode = false;
        ProcessingNode result = this.createTree(tree);
        this.canGetNode = true;
        this.linkNodes();
        Iterator iter = this.initializableNodes.iterator();
        while (iter.hasNext()) {
            ((Initializable)iter.next()).initialize();
        }
        return result;
    }

    public List getDisposableNodes() {
        return this.disposableNodes;
    }

    public ProcessingNode setupNode(ProcessingNode node, Configuration config2) throws Exception {
        if (node instanceof AbstractProcessingNode) {
            ((AbstractProcessingNode)node).setLocation(config2.getLocation());
        }
        this.lifecycle.setupComponent(node, false);
        if (node instanceof ParameterizableProcessingNode) {
            Map params = this.getParameters(config2);
            ((ParameterizableProcessingNode)node).setParameters(params);
        }
        if (node instanceof Initializable) {
            this.initializableNodes.add(node);
        }
        if (node instanceof Disposable) {
            this.disposableNodes.add(node);
        }
        return node;
    }

    protected Map getParameters(Configuration config2) throws ConfigurationException {
        Configuration[] children = config2.getChildren(this.parameterElement);
        if (children.length == 0) {
            return null;
        }
        HashMap<VariableResolver, VariableResolver> params = new HashMap<VariableResolver, VariableResolver>();
        int i = 0;
        while (i < children.length) {
            Configuration child = children[i];
            String name = child.getAttribute("name");
            String value = child.getAttribute("value");
            try {
                params.put(VariableResolverFactory.getResolver(name, this.manager), VariableResolverFactory.getResolver(value, this.manager));
            }
            catch (PatternException pe) {
                String msg = "Invalid pattern '" + value + "' at " + child.getLocation();
                this.getLogger().error(msg, (Throwable)((Object)pe));
                throw new ConfigurationException(msg, (Throwable)((Object)pe));
            }
            ++i;
        }
        return params;
    }

    public String getTypeForStatement(Configuration statement, String role) throws ConfigurationException {
        String type = statement.getAttribute("type", null);
        ComponentSelector selector = null;
        try {
            try {
                selector = (ComponentSelector)this.manager.lookup(role);
            }
            catch (ComponentException ce) {
                String msg = "Cannot get component selector for '" + statement.getName() + "' at " + statement.getLocation();
                this.getLogger().error(msg, (Throwable)ce);
                throw new ConfigurationException(msg, (Throwable)ce);
            }
            if (type == null && selector instanceof ExtendedComponentSelector) {
                type = ((ExtendedComponentSelector)selector).getDefaultHint();
            }
            if (type == null) {
                String msg = "No default type exists for '" + statement.getName() + "' at " + statement.getLocation();
                this.getLogger().error(msg);
                throw new ConfigurationException(msg);
            }
            if (!selector.hasComponent((Object)type)) {
                String msg = "Type '" + type + "' is not defined for '" + statement.getName() + "' at " + statement.getLocation();
                this.getLogger().error(msg);
                throw new ConfigurationException(msg);
            }
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.manager.release((Component)selector);
            throw throwable;
        }
        this.manager.release((Component)selector);
        return type;
    }

    public void recycle() {
        this.lifecycle = null;
        this.initializableNodes.clear();
        this.linkedBuilders.clear();
        this.canGetNode = false;
        this.registeredNodes.clear();
        this.disposableNodes = new ArrayList();
        this.processor = null;
        this.manager = null;
        this.roleManager = null;
    }

    public void dispose() {
        LifecycleHelper.dispose(this.builderSelector);
    }
}

