/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.xslt;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TemplatesHandler;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.ParameterException;
import org.apache.avalon.framework.parameters.Parameterizable;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.caching.AggregatedCacheValidity;
import org.apache.cocoon.caching.CacheValidity;
import org.apache.cocoon.caching.TimeStampCacheValidity;
import org.apache.cocoon.components.store.Store;
import org.apache.cocoon.components.xslt.XSLTProcessor;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.util.TraxErrorHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLFilter;

public class XSLTProcessorImpl
extends AbstractLoggable
implements XSLTProcessor,
Composable,
Disposable,
Parameterizable,
URIResolver {
    protected ComponentManager manager;
    protected Store store;
    protected SAXTransformerFactory tfactory;
    protected Class tfactoryClass;
    protected boolean useStore = true;
    protected boolean incrementalProcessing = false;
    protected SourceResolver resolver;
    protected List includes;
    static /* synthetic */ Class class$javax$xml$transform$TransformerFactory;

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.getLogger().debug("XSLTProcessorImpl component initialized.");
        this.store = (Store)manager.lookup("org.apache.cocoon.components.store.Store/TransientCache");
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.store);
            this.store = null;
        }
        this.manager = null;
        this.tfactoryClass = null;
        this.tfactory = null;
    }

    public void parameterize(Parameters params) throws ParameterException {
        this.useStore = params.getParameterAsBoolean("use-store", true);
        this.incrementalProcessing = params.getParameterAsBoolean("incremental-processing", false);
        String factoryName = params.getParameter("transformer-factory", null);
        if (factoryName == null) {
            this.tfactoryClass = null;
        } else {
            this.getLogger().debug("Using factory " + factoryName);
            try {
                this.tfactoryClass = ClassUtils.loadClass(factoryName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new ParameterException("Cannot load TransformerFactory class", (Throwable)cnfe);
            }
            if (!(class$javax$xml$transform$TransformerFactory == null ? (class$javax$xml$transform$TransformerFactory = XSLTProcessorImpl.class$("javax.xml.transform.TransformerFactory")) : class$javax$xml$transform$TransformerFactory).isAssignableFrom(this.tfactoryClass)) {
                throw new ParameterException("Class " + factoryName + " isn't a TransformerFactory");
            }
        }
    }

    public CacheValidity getTransformerValidity(org.apache.cocoon.environment.Source stylesheet) {
        if (stylesheet.getLastModified() == 0L) {
            return null;
        }
        if (!this.useStore) {
            return new TimeStampCacheValidity(stylesheet.getLastModified());
        }
        String id = stylesheet.getSystemId();
        Object[] templateAndTimeAndIncludes = (Object[])this.store.get(id);
        if (templateAndTimeAndIncludes != null && templateAndTimeAndIncludes[2] != null) {
            List includes = (List)templateAndTimeAndIncludes[2];
            AggregatedCacheValidity validity = new AggregatedCacheValidity();
            validity.add(new TimeStampCacheValidity(stylesheet.getLastModified()));
            int i = includes.size() - 1;
            while (i >= 0) {
                Object[] pair = (Object[])includes.get(i);
                long time = (Long)pair[1];
                validity.add(new TimeStampCacheValidity(time));
                --i;
            }
            return validity;
        }
        return new TimeStampCacheValidity(stylesheet.getLastModified());
    }

    public TransformerHandler getTransformerHandler(org.apache.cocoon.environment.Source stylesheet) throws ProcessingException {
        return this.getTransformerHandler(stylesheet, null);
    }

    public TransformerHandler getTransformerHandler(org.apache.cocoon.environment.Source stylesheet, XMLFilter filter) throws ProcessingException {
        try {
            String id = stylesheet.getSystemId();
            Templates templates = this.getTemplates(stylesheet, id);
            if (templates == null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Creating new Templates for " + id);
                }
                TemplatesHandler templatesHandler = this.getTransformerFactory().newTemplatesHandler();
                if (filter != null) {
                    filter.setContentHandler(templatesHandler);
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Source = " + stylesheet + ", templatesHandler = " + templatesHandler);
                }
                this.includes = new ArrayList();
                stylesheet.toSAX(filter != null ? (ContentHandler)((Object)filter) : templatesHandler);
                templates = templatesHandler.getTemplates();
                if (null == templates) {
                    throw new ProcessingException("Unable to create templates for stylesheet: " + stylesheet.getSystemId());
                }
                this.putTemplates(templates, stylesheet, id);
                this.includes = null;
            } else if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Reusing Templates for " + id);
            }
            TransformerHandler handler = this.getTransformerFactory().newTransformerHandler(templates);
            handler.getTransformer().setErrorListener(new TraxErrorHandler(this.getLogger()));
            handler.getTransformer().setURIResolver(this);
            return handler;
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (SAXException e) {
            if (e.getException() == null) {
                throw new ProcessingException("Exception in creating Transform Handler", e);
            }
            this.getLogger().debug("Got SAXException. Rethrowing cause exception.", (Throwable)e);
            throw new ProcessingException("Exception in creating Transform Handler", e.getException());
        }
        catch (Exception e) {
            throw new ProcessingException("Exception in creating Transform Handler", e);
        }
    }

    public void transform(org.apache.cocoon.environment.Source source, org.apache.cocoon.environment.Source stylesheet, Parameters params, Result result) throws ProcessingException {
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("XSLTProcessorImpl: transform source = " + source + ", stylesheet = " + stylesheet + ", parameters = " + params + ", result = " + result);
            }
            TransformerHandler handler = this.getTransformerHandler(stylesheet);
            if (params != null) {
                Transformer transformer = handler.getTransformer();
                transformer.clearParameters();
                String[] names = params.getNames();
                int i = names.length - 1;
                while (i >= 0) {
                    transformer.setParameter(names[i], params.getParameter(names[i]));
                    --i;
                }
            }
            handler.setResult(result);
            source.toSAX(handler);
            this.getLogger().debug("XSLTProcessorImpl: transform done");
        }
        catch (ProcessingException e) {
            throw e;
        }
        catch (ParameterException e) {
            throw new ProcessingException("Error in running Transformation", e);
        }
        catch (SAXException e) {
            if (e.getException() == null) {
                throw new ProcessingException("Error in running Transformation", e);
            }
            this.getLogger().debug("Got SAXException. Rethrowing cause exception.", (Throwable)e);
            throw new ProcessingException("Error in running Transformation", e.getException());
        }
    }

    private SAXTransformerFactory getTransformerFactory() throws Exception {
        if (this.tfactory == null) {
            this.tfactory = this.tfactoryClass == null ? (SAXTransformerFactory)TransformerFactory.newInstance() : (SAXTransformerFactory)this.tfactoryClass.newInstance();
            this.tfactory.setErrorListener(new TraxErrorHandler(this.getLogger()));
            this.tfactory.setURIResolver(this);
            if (this.tfactory.getClass().getName().equals("org.apache.xalan.processor.TransformerFactoryImpl")) {
                this.tfactory.setAttribute("http://xml.apache.org/xalan/features/incremental", new Boolean(this.incrementalProcessing));
            }
        }
        return this.tfactory;
    }

    private Templates getTemplates(org.apache.cocoon.environment.Source stylesheet, String id) throws ProcessingException, IOException, SAXException {
        if (!this.useStore) {
            return null;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("XSLTProcessorImpl getTemplates: stylesheet " + id);
        }
        if (stylesheet.getLastModified() == 0L) {
            this.store.remove(id);
            return null;
        }
        Object[] templateAndTimeAndIncludes = (Object[])this.store.get(id);
        if (templateAndTimeAndIncludes == null) {
            return null;
        }
        long storedTime = (Long)templateAndTimeAndIncludes[1];
        if (storedTime != stylesheet.getLastModified()) {
            this.store.remove(id);
            return null;
        }
        List includes = (List)templateAndTimeAndIncludes[2];
        if (includes != null) {
            int i = includes.size() - 1;
            while (i >= 0) {
                Object[] pair = (Object[])includes.get(i);
                org.apache.cocoon.environment.Source included = this.resolver.resolve((String)pair[0]);
                if (included.getLastModified() != ((Long)pair[1]).longValue()) {
                    this.store.remove(id);
                    return null;
                }
                --i;
            }
        }
        return (Templates)templateAndTimeAndIncludes[0];
    }

    private void putTemplates(Templates templates, org.apache.cocoon.environment.Source stylesheet, String id) throws IOException {
        if (!this.useStore) {
            return;
        }
        if (stylesheet.getLastModified() != 0L) {
            int i = this.includes.size() - 1;
            while (i >= 0) {
                Object[] pair = (Object[])this.includes.get(i);
                if ((Long)pair[1] == 0L) {
                    return;
                }
                --i;
            }
            Object[] templateAndTimeAndIncludes = new Object[3];
            templateAndTimeAndIncludes[0] = templates;
            templateAndTimeAndIncludes[1] = new Long(stylesheet.getLastModified());
            if (this.includes.size() > 0) {
                templateAndTimeAndIncludes[2] = this.includes;
            }
            this.store.hold(id, templateAndTimeAndIncludes);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Source resolve(String href, String base) throws TransformerException {
        Object parent22;
        org.apache.cocoon.environment.Source xslSource;
        block22: {
            Source source;
            block21: {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("resolve(href = " + href + ", base = " + base + "); resolver = " + this.resolver);
                }
                xslSource = null;
                try {
                    try {
                        if (base == null || href.indexOf(":") > 1) {
                            xslSource = this.resolver.resolve(href);
                        } else if (href.length() == 0) {
                            xslSource = this.resolver.resolve(base);
                        } else if (!base.startsWith("file:")) {
                            int lastPathElementPos = base.lastIndexOf(47);
                            if (lastPathElementPos == -1) {
                                source = null;
                                Object var10_12 = null;
                                if (xslSource == null) return source;
                                break block21;
                            }
                            xslSource = this.resolver.resolve(base.substring(0, lastPathElementPos) + "/" + href);
                        } else {
                            File parent = new File(base.substring(5));
                            parent22 = new File(parent.getParentFile(), href);
                            xslSource = this.resolver.resolve(((File)parent22).toURL().toExternalForm());
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("xslSource = " + xslSource + ", system id = " + xslSource.getSystemId());
                        }
                        InputSource is = xslSource.getInputSource();
                        if (this.includes != null) {
                            this.includes.add(new Object[]{xslSource.getSystemId(), new Long(xslSource.getLastModified())});
                        }
                        parent22 = new StreamSource(is.getByteStream(), is.getSystemId());
                        break block22;
                    }
                    catch (ResourceNotFoundException rnfe) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)((Object)rnfe));
                        }
                        Source parent22 = null;
                        Object var10_14 = null;
                        if (xslSource == null) return parent22;
                        xslSource.recycle();
                        return parent22;
                    }
                    catch (MalformedURLException mue) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)mue);
                        }
                        Source source2 = null;
                        Object var10_15 = null;
                        if (xslSource == null) return source2;
                        xslSource.recycle();
                        return source2;
                    }
                    catch (IOException ioe) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Failed to resolve " + href + "(base = " + base + "), return null", (Throwable)ioe);
                        }
                        Source source3 = null;
                        Object var10_16 = null;
                        if (xslSource == null) return source3;
                        xslSource.recycle();
                        return source3;
                    }
                    catch (SAXException se) {
                        throw new TransformerException(se);
                    }
                    catch (ProcessingException pe) {
                        throw new TransformerException((Throwable)((Object)pe));
                    }
                }
                catch (Throwable throwable) {
                    Object var10_17 = null;
                    if (xslSource == null) throw throwable;
                    xslSource.recycle();
                    throw throwable;
                }
            }
            xslSource.recycle();
            return source;
        }
        Object var10_13 = null;
        if (xslSource == null) return parent22;
        xslSource.recycle();
        return parent22;
    }

    public void setSourceResolver(SourceResolver resolver) {
        this.resolver = resolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

