/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.environment.wrapper;

import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.cocoon.Processor;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.environment.AbstractEnvironment;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.wrapper.RequestWrapper;
import org.apache.log.Logger;

public class EnvironmentWrapper
extends AbstractEnvironment
implements Environment {
    protected Environment environment;
    protected Map objectModel;
    protected String redirectURL;
    protected Request request;
    protected URL lastContext;
    protected String lastPrefix;
    protected String lastURI;
    protected OutputStream outputStream;
    protected Processor processor;

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger) throws MalformedURLException {
        this(env, requestURI, queryString, logger, false);
    }

    public EnvironmentWrapper(Environment env, String requestURI, String queryString, Logger logger, boolean rawMode) throws MalformedURLException {
        super(env.getURI(), env.getView(), env.getRootContext(), env.getAction());
        this.setLogger(logger);
        this.environment = env;
        this.context = env.getContext();
        this.prefix = new StringBuffer(env.getURIPrefix());
        this.setSourceHandler(env.getSourceHandler());
        this.objectModel = new HashMap(4);
        Map oldObjectModel = env.getObjectModel();
        Iterator keys = oldObjectModel.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            this.objectModel.put(key, oldObjectModel.get(key));
        }
        this.request = new RequestWrapper(ObjectModelHelper.getRequest(oldObjectModel), requestURI, queryString, this, rawMode);
        this.objectModel.put("request", this.request);
        this.objectModel.put("Internal-Request", "true");
    }

    public void redirect(boolean sessionmode, String newURL) throws IOException {
        this.redirectURL = newURL;
        if (sessionmode) {
            this.request.getSession(true);
        }
    }

    public void globalRedirect(boolean sessionmode, String newURL) throws IOException {
        if (this.environment instanceof EnvironmentWrapper) {
            ((EnvironmentWrapper)this.environment).globalRedirect(sessionmode, newURL);
        } else {
            this.environment.redirect(sessionmode, newURL);
        }
    }

    public void setComponentManager(ComponentManager manager) {
        super.setComponentManager(manager);
        this.processor = CocoonComponentManager.getCurrentProcessor();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.outputStream == null ? this.environment.getOutputStream() : this.outputStream;
    }

    public void setOutputStream(OutputStream stream) {
        this.outputStream = stream;
    }

    public String getRedirectURL() {
        return this.redirectURL;
    }

    public void reset() {
        this.redirectURL = null;
    }

    public void setStatus(int statusCode) {
    }

    public void setContentLength(int length) {
    }

    public void setContentType(String contentType) {
    }

    public String getContentType() {
        return null;
    }

    public Map getObjectModel() {
        return this.objectModel;
    }

    public void setURI(String prefix, String uris) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Setting uri (prefix=" + prefix + ", uris=" + uris + ")");
        }
        if (prefix != null) {
            this.setContext(this.getRootContext());
            this.setURIPrefix(prefix);
        }
        this.uris = uris;
        this.lastURI = uris;
        this.lastContext = this.context;
        this.lastPrefix = this.prefix.toString();
    }

    public void changeContext(String prefix, String context) throws MalformedURLException {
        super.changeContext(prefix, context);
        this.lastContext = this.context;
        this.lastPrefix = this.prefix.toString();
        this.lastURI = this.uris;
    }

    public Processor changeToLastContext() {
        this.setContext(this.lastContext);
        this.setURIPrefix(this.lastPrefix);
        this.uris = this.lastURI;
        return this.processor;
    }

    public Object getAttribute(String name) {
        Object value = super.getAttribute(name);
        if (value == null) {
            value = this.environment.getAttribute(name);
        }
        return value;
    }

    public void removeAttribute(String name) {
        super.removeAttribute(name);
        this.environment.removeAttribute(name);
    }
}

