/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

public class ClassUtils {
    public static Object newInstance(String className) throws Exception {
        return ClassUtils.loadClass(className).newInstance();
    }

    public static Class loadClass(String className) throws ClassNotFoundException {
        return ClassUtils.getClassLoader().loadClass(className);
    }

    public static URL getResource(String resource) throws MalformedURLException {
        return ClassUtils.getClassLoader().getResource(resource);
    }

    public static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static boolean implementsInterface(String className, String iface) throws Exception {
        Class class1 = ClassUtils.loadClass(className);
        Class class2 = ClassUtils.loadClass(iface);
        return ClassUtils.implementsInterface(class1, class2);
    }

    public static boolean implementsInterface(Class class1, Class iface) {
        return iface.isAssignableFrom(class1);
    }

    public static long lastModified(Class aClass) throws IOException, IllegalArgumentException {
        URL url = aClass.getProtectionDomain().getCodeSource().getLocation();
        if (!url.getProtocol().equals("file")) {
            throw new IllegalArgumentException("Class was not loaded from a file url");
        }
        File directory = new File(url.getFile());
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Class was not loaded from a directory");
        }
        String className = aClass.getName();
        String basename = className.substring(className.lastIndexOf(".") + 1);
        File file = new File(directory, basename + ".class");
        return file.lastModified();
    }

    public static String which(Class aClass) {
        String path = null;
        try {
            path = aClass.getProtectionDomain().getCodeSource().getLocation().toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return path;
    }
}

