/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.compiler;

import org.apache.commons.jxpath.ri.Compiler;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.Constant;
import org.apache.commons.jxpath.ri.compiler.CoreFunction;
import org.apache.commons.jxpath.ri.compiler.CoreOperation;
import org.apache.commons.jxpath.ri.compiler.Expression;
import org.apache.commons.jxpath.ri.compiler.ExpressionPath;
import org.apache.commons.jxpath.ri.compiler.ExtensionFunction;
import org.apache.commons.jxpath.ri.compiler.LocationPath;
import org.apache.commons.jxpath.ri.compiler.NameAttributeTest;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.compiler.ProcessingInstructionTest;
import org.apache.commons.jxpath.ri.compiler.Step;
import org.apache.commons.jxpath.ri.compiler.VariableReference;

public class TreeCompiler
implements Compiler {
    private static final QName QNAME_NAME = new QName(null, "name");

    public Object number(String value) {
        return new Constant(new Double(value));
    }

    public Object literal(String value) {
        return new Constant(value);
    }

    public Object qname(String prefix, String name) {
        return new QName(prefix, name);
    }

    public Object sum(Object[] arguments) {
        return new CoreOperation(1, this.toExpressionArray(arguments));
    }

    public Object minus(Object left, Object right) {
        return new CoreOperation(2, (Expression)left, (Expression)right);
    }

    public Object multiply(Object left, Object right) {
        return new CoreOperation(3, (Expression)left, (Expression)right);
    }

    public Object divide(Object left, Object right) {
        return new CoreOperation(4, (Expression)left, (Expression)right);
    }

    public Object mod(Object left, Object right) {
        return new CoreOperation(10, (Expression)left, (Expression)right);
    }

    public Object lessThan(Object left, Object right) {
        return new CoreOperation(11, (Expression)left, (Expression)right);
    }

    public Object lessThanOrEqual(Object left, Object right) {
        return new CoreOperation(13, (Expression)left, (Expression)right);
    }

    public Object greaterThan(Object left, Object right) {
        return new CoreOperation(12, (Expression)left, (Expression)right);
    }

    public Object greaterThanOrEqual(Object left, Object right) {
        return new CoreOperation(14, (Expression)left, (Expression)right);
    }

    public Object equal(Object left, Object right) {
        if (this.isNameAttributeTest((Expression)left)) {
            return new NameAttributeTest((Expression)left, (Expression)right);
        }
        return new CoreOperation(15, (Expression)left, (Expression)right);
    }

    public Object notEqual(Object left, Object right) {
        return new CoreOperation(16, (Expression)left, (Expression)right);
    }

    public Object minus(Object argument) {
        return new CoreOperation(9, (Expression)argument);
    }

    public Object variableReference(Object qName) {
        return new VariableReference((QName)qName);
    }

    public Object function(int code, Object[] args) {
        return new CoreFunction(code, this.toExpressionArray(args));
    }

    public Object function(Object name, Object[] args) {
        return new ExtensionFunction((QName)name, this.toExpressionArray(args));
    }

    public Object and(Object[] arguments) {
        return new CoreOperation(7, this.toExpressionArray(arguments));
    }

    public Object or(Object[] arguments) {
        return new CoreOperation(8, this.toExpressionArray(arguments));
    }

    public Object union(Object[] arguments) {
        return new CoreOperation(19, this.toExpressionArray(arguments));
    }

    public Object locationPath(boolean absolute, Object[] steps) {
        return new LocationPath(absolute, this.toStepArray(steps));
    }

    public Object expressionPath(Object expression, Object[] predicates, Object[] steps) {
        return new ExpressionPath((Expression)expression, this.toExpressionArray(predicates), this.toStepArray(steps));
    }

    public Object nodeNameTest(Object qname) {
        return new NodeNameTest((QName)qname);
    }

    public Object nodeTypeTest(int nodeType) {
        return new NodeTypeTest(nodeType);
    }

    public Object processingInstructionTest(String instruction) {
        return new ProcessingInstructionTest(instruction);
    }

    public Object step(int axis, Object nodeTest, Object[] predicates) {
        return new Step(axis, (NodeTest)nodeTest, this.toExpressionArray(predicates));
    }

    private Expression[] toExpressionArray(Object[] array) {
        Expression[] expArray = null;
        if (array != null) {
            expArray = new Expression[array.length];
            int i = 0;
            while (i < expArray.length) {
                expArray[i] = (Expression)array[i];
                ++i;
            }
        }
        return expArray;
    }

    private Step[] toStepArray(Object[] array) {
        Step[] stepArray = null;
        if (array != null) {
            stepArray = new Step[array.length];
            int i = 0;
            while (i < stepArray.length) {
                stepArray[i] = (Step)array[i];
                ++i;
            }
        }
        return stepArray;
    }

    private boolean isNameAttributeTest(Expression arg) {
        if (arg.getExpressionTypeCode() != 20) {
            return false;
        }
        Step[] steps = ((LocationPath)arg).getSteps();
        if (steps.length != 1) {
            return false;
        }
        if (steps[0].getAxis() != 5) {
            return false;
        }
        NodeTest test = steps[0].getNodeTest();
        if (!(test instanceof NodeNameTest)) {
            return false;
        }
        return ((NodeNameTest)test).getNodeName().equals(QNAME_NAME);
    }
}

