/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.tutorial;

import com.hp.hpl.mesa.rdf.jena.mem.ModelMem;
import com.hp.hpl.mesa.rdf.jena.model.Property;
import com.hp.hpl.mesa.rdf.jena.model.RDFNode;
import com.hp.hpl.mesa.rdf.jena.model.Resource;
import com.hp.hpl.mesa.rdf.jena.model.Statement;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;
import com.hp.hpl.mesa.rdf.jena.vocabulary.DC;

public class tutorial03 {
    static String tutorialURI = "http://hostname/rdf/tutorial/";
    static String briansName = "Brian McBride";
    static String briansEmail1 = "brian_mcbride@hp.com";
    static String briansEmail2 = "brian_mcbride@hpl.hp.com";
    static String title = "An Introduction to RDF and the Jena API";
    static String date = "23/01/2001";

    public static void main(String[] stringArray) {
        try {
            ModelMem modelMem = new ModelMem();
            Property property = modelMem.createProperty(tutorialURI, "name");
            Property property2 = modelMem.createProperty(tutorialURI, "emailAddress");
            Resource resource = modelMem.createResource();
            resource.addProperty(property, briansName).addProperty(property2, briansEmail1).addProperty(property2, briansEmail2);
            Resource resource2 = modelMem.createResource(tutorialURI);
            resource2.addProperty(DC.creator, resource).addProperty(DC.title, title).addProperty(DC.date, date);
            StmtIterator stmtIterator = modelMem.listStatements();
            while (stmtIterator.hasNext()) {
                Statement statement = stmtIterator.next();
                Resource resource3 = statement.getSubject();
                Property property3 = statement.getPredicate();
                RDFNode rDFNode = statement.getObject();
                System.out.print("(" + property3.toString() + ",");
                System.out.print(" " + resource3.toString() + ",");
                if (rDFNode instanceof Resource) {
                    System.out.print(" " + rDFNode.toString());
                } else {
                    System.out.print(" \"" + rDFNode.toString() + "\"");
                }
                System.out.println(")");
            }
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception);
        }
    }
}

