<?xml version="1.0" encoding="UTF-8"?>
<!--
SDX: Documentary System in XML.
Copyright (C) 2000, 2001, 2002  Ministere de la culture et de la communication (France), AJLSM

Ministere de la culture et de la communication,
Mission de la recherche et de la technologie
3 rue de Valois, 75042 Paris Cedex 01 (France)
mrt@culture.fr, michel.bottin@culture.fr

AJLSM, 17, rue Vital Carles, 33000 Bordeaux (France)
sevigny@ajlsm.com

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the
Free Software Foundation, Inc.
59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
or connect to:
http://www.fsf.org/copyleft/gpl.html
-->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx" exclude-result-prefixes="sdx">
    <xsl:import href="skin.xsl"/>
    <xsl:template match="sdx:results">
        <h2>Résultats de recherche (bases sdx:world et sdx:doc)</h2>
        <table width="100%" cellpadding="0" cellspacing="0" border="0">
            <tr>
                <td class="highlight">
                    <div>
                        <xsl:apply-templates select="." mode="sdx:head">
                            <xsl:with-param name="bqidParam" select="'bqid'"/>
                        </xsl:apply-templates>
                    </div>
                </td>
            </tr>
        </table>
        <br/>
        <xsl:apply-templates>
            <xsl:with-param name="action" select="'document.xsp'"/>
        </xsl:apply-templates>
        <br/>
        <div class="highlight">
            <xsl:apply-templates select="." mode="sdx:foot"/>
        </div>
    </xsl:template>
    <!--
    <xsl:template match="sdx:result">
        <div style="white-space:nowrap">
            <b>
                <xsl:value-of select="@no"/>
            </b>
            <xsl:text>&#160;</xsl:text>
            <a href="document.xsp?app={sdx:field[@name='sdxappid']}&amp;base={sdx:field[@name='sdxdbid']}&amp;id={sdx:field[@name='sdxdocid']}&amp;qid={../@id}&amp;n={@no}&amp;q={/sdx:document/sdx:parameters/sdx:parameter[@name='q']/@value}">
                <xsl:text>&#160;</xsl:text>
                <xsl:value-of select="sdx:field[@name='titre']"/>
            </a>
            <xsl:text>&#160;</xsl:text>
            <small>base=<b>
                    <xsl:value-of select="sdx:field[@name='sdxdbid']"/>
                </b>
            </small>
            <xsl:text>&#160;</xsl:text>
            <small>id=<xsl:value-of select="sdx:field[@name='sdxdocid']"/>
            </small>
        </div>
    </xsl:template>
-->
    <xsl:template match="sdx:field"/>
    <xsl:template match="sdx:field[@name='titre']">
        <a href="document.xsp?app={../sdx:field[@name='sdxappid']/@value}&amp;base={../sdx:field[@name='sdxdbid']/@value}&amp;id={../sdx:field[@name='sdxdocid']/@value}&amp;qid={../../@qid}&amp;n={../@no}&amp;q={/../../@escapedText}">
            <xsl:text>&#160;</xsl:text>
            <xsl:value-of select="."/>
        </a>
    </xsl:template>
</xsl:stylesheet>
