<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sdx="http://www.culture.gouv.fr/ns/sdx/sdx">
    <!-- theese params are provide by sdx for all indexation transformation -->
    <xsl:param name="sdxDate"/>
    <xsl:param name="sdxFormattedDate"/>
    <!-- this param is given by upload.xsp -->
    <xsl:param name="jour"/>
    <xsl:param name="url"/>
    <xsl:variable name="base">
        <xsl:choose>
            <xsl:when test="
            contains($url, '.html')
            or contains($url, '.htm')
            or contains($url, '.xsp')
            or contains($url, '.php')
            or contains($url, '.asp')
            ">
                <xsl:call-template name="substring-before-last">
                    <xsl:with-param name="string" select="$url"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="substring($url, string-length($url), 1)='/'">
                <xsl:value-of select="substring($url, 1, string-length($url)-1)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$url"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <!--

	Indexing HTML documents 
	
	source could be in lots of namespace
	    http://www.w3.org/TR/xhtml1/strict
	    http://www.w3.org/1999/xhtml
	    http://www.w3.org/2002/06/xhtml2
	    
	so matching is in forms like *[local-name()='title' or local-name()='h1'] 
-->
    <xsl:template match="/">
        <xsl:apply-templates/>
    </xsl:template>
    <xsl:template match="/*">
        <!-- output root element, creates an SDX document with the given @id attribute  -->
        <sdx:document id="{$url}">
            <!--  For a full text field, we "apply-templates" accross the whole document, except that we need a space between the each element's text ; that's why it's called "fulltext" mode  -->
            <sdx:field code="contenu">
                <xsl:apply-templates mode="fulltext"/>
            </sdx:field>
            <sdx:field code="date">
                <xsl:value-of select="$sdxFormattedDate"/>
            </sdx:field>
            <xsl:if test="$jour">
                <sdx:field code="jour">
                    <xsl:value-of select="$jour"/>
                </sdx:field>
            </xsl:if>
            <sdx:field name="url">
                <xsl:value-of select="normalize-space($url)"/>
            </sdx:field>
            <sdx:field name="base">
                <xsl:value-of select="normalize-space($base)"/>
            </sdx:field>
            <sdx:field name="type">text/html</sdx:field>
            <xsl:apply-templates/>
        </sdx:document>
    </xsl:template>
    <!-- title -->
    <xsl:template match="*[local-name()='title' or local-name()='h1']">
        <sdx:field code="titre">
            <xsl:value-of select="normalize-space(.)"/>
        </sdx:field>
    </xsl:template>
    <!-- pass -->
    <xsl:template match="*">
        <xsl:apply-templates/>
    </xsl:template>
    <!-- tokenizer -->
    <xsl:template name="substring-before-last">
        <xsl:param name="string" select="."/>
        <xsl:param name="token" select="'/'"/>
        <xsl:value-of select="substring-before($string, $token)"/>
        <xsl:choose>
            <xsl:when test="contains(substring-after($string, $token), $token)">
                <xsl:value-of select="$token"/>
                <xsl:call-template name="substring-before-last">
                    <xsl:with-param name="string" select="substring-after($string, $token)"/>
                    <xsl:with-param name="token" select="$token"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise/>
        </xsl:choose>
    </xsl:template>
    <!-- a very simple template, puts a space between all elements
	and cut extra spaces and break-lines  -->
    <xsl:template match="*" mode="fulltext">
        <xsl:apply-templates select="*|text()" mode="fulltext"/>
    </xsl:template>
    <xsl:template match="text()" mode="fulltext">
        <xsl:value-of select="normalize-space(.)"/>
        <xsl:if test="normalize-space(.) !=''">
            <xsl:text>&#32;</xsl:text>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
