/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.build.conflict;

import net.sourceforge.chaperon.build.ItemSetCollection;
import net.sourceforge.chaperon.build.conflict.Conflict;
import net.sourceforge.chaperon.model.grammar.Grammar;
import net.sourceforge.chaperon.model.symbol.Terminal;

public class ReduceReduceConflict
extends Conflict {
    private Grammar grammar;
    private ItemSetCollection itemsets;
    private int state;
    private Terminal symbol;
    private int firstproduction;
    private int secondproduction;

    public ReduceReduceConflict(Grammar grammar, ItemSetCollection itemsets, int state, Terminal symbol, int firstproduction, int secondproduction) {
        this.grammar = grammar;
        this.itemsets = itemsets;
        this.state = state;
        this.symbol = symbol;
        this.firstproduction = firstproduction;
        this.secondproduction = secondproduction;
    }

    public int getState() {
        return this.state;
    }

    public Terminal getSymbol() {
        return this.symbol;
    }

    public int getFirstProduction() {
        return this.firstproduction;
    }

    public int getSecondProduction() {
        return this.secondproduction;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Reduce/Reduce conflict in state ");
        buffer.append(String.valueOf(this.state));
        buffer.append(" between");
        buffer.append(System.getProperty("line.separator"));
        buffer.append(this.grammar.getProduction(this.firstproduction));
        buffer.append("[priority=");
        buffer.append(String.valueOf(this.grammar.getPriority(this.grammar.getProduction(this.firstproduction))));
        buffer.append("]");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("and");
        buffer.append(System.getProperty("line.separator"));
        buffer.append(this.grammar.getProduction(this.secondproduction));
        buffer.append("[priority=");
        buffer.append(String.valueOf(this.grammar.getPriority(this.grammar.getProduction(this.secondproduction))));
        buffer.append("]");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("for symbol ");
        buffer.append(this.symbol);
        buffer.append("[priority=");
        buffer.append(String.valueOf(this.grammar.getPriority(this.symbol)));
        buffer.append(" associativity=");
        buffer.append(String.valueOf(this.grammar.getAssociativity(this.symbol)));
        buffer.append("]");
        return buffer.toString();
    }
}

