/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.common;

public class Decoder {
    public static final String STRING = "\"";
    public static final String CHAR = "'";
    public static final String CLASS = "[^- ]";
    public static final String REGEX = "+*?^$() ";

    public static String toString(String string) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(STRING);
        int i = 0;
        while (i < string.length()) {
            buffer.append(Decoder.decode(string.charAt(i), STRING));
            ++i;
        }
        buffer.append(STRING);
        return buffer.toString();
    }

    public static String toChar(char character) {
        return CHAR + Decoder.decode(character, CHAR) + CHAR;
    }

    public static String toClass(char minimum, char maximum) {
        if (minimum == maximum) {
            return Decoder.toChar(minimum);
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[");
        buffer.append(Decoder.decode(minimum, CLASS));
        buffer.append("-");
        buffer.append(Decoder.decode(maximum, CLASS));
        buffer.append("]");
        return buffer.toString();
    }

    public static String toNegativeClass(char minimum, char maximum) {
        if (minimum == maximum) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[^");
            buffer.append(Decoder.decode(minimum, CLASS));
            buffer.append("]");
            return buffer.toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[^");
        buffer.append(Decoder.decode(minimum, CLASS));
        buffer.append("-");
        buffer.append(Decoder.decode(maximum, CLASS));
        buffer.append("]");
        return buffer.toString();
    }

    public static String decode(char character, String masked) {
        if (character == '\n') {
            return "\\n";
        }
        if (character == '\t') {
            return "\\t";
        }
        if (character == '\r') {
            return "\\r";
        }
        if (character == '\\') {
            return "\\\\";
        }
        if (character >= ' ' && character <= '~' && masked.indexOf(character) < 0) {
            return String.valueOf(character);
        }
        if (character >= ' ' && character <= '~') {
            return "\\" + character;
        }
        String hexstring = Integer.toHexString(character);
        String zeros = "0000";
        return "\\u" + zeros.substring(hexstring.length()) + hexstring;
    }

    public static String decode(String string, String masked) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            buffer.append(Decoder.decode(string.charAt(i), masked));
            ++i;
        }
        return buffer.toString();
    }
}

