/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation.asciiart;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public class AsciiArtPad {
    private int width;
    private int height;
    private List pad;
    private double xGrid;
    private double yGrid;

    public AsciiArtPad() {
        this.pad = new ArrayList();
    }

    public AsciiArtPad(int w, int h) {
        this.width = w;
        this.height = h;
        this.pad = new ArrayList();
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setXGrid(double xGrid) {
        this.xGrid = xGrid;
    }

    public void setYGrid(double yGrid) {
        this.yGrid = yGrid;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public double getXGrid() {
        return this.xGrid;
    }

    public double getYGrid() {
        return this.yGrid;
    }

    public void add(Object o) {
        this.pad.add(o);
    }

    public Iterator iterator() {
        return this.pad.iterator();
    }

    public static interface AsciiArtElement {
    }

    public static class AsciiArtPadBuilder {
        private AsciiArtPad asciiArtPad;
        private AsciiArt aa;
        final String EDGE_GROUP = "[+\\\\/]";
        final String HLINE_GROUP = "[\\-~=+]";
        final String VLINE_GROUP = "[|+]";
        final String STRING_SUFFIX_GROUP = "[^\\-|~=\\/+ \\\\]";
        final String STRING_PREFIX_GROUP = "[^\\-|~=\\/+ \\\\]";

        public AsciiArtPadBuilder(AsciiArtPad asciiArtPad) {
            this.asciiArtPad = asciiArtPad;
        }

        public void build(String[] asciiArt) {
            this.aa = new AsciiArt(asciiArt);
            this.asciiArtPad.setWidth(this.aa.getW());
            this.asciiArtPad.setHeight(this.aa.getH());
            this.findRectPattern();
            this.findCornerPattern();
            this.findLinePattern();
            this.findStringPattern();
        }

        protected void findRectPattern() {
        }

        protected void findCornerPattern() {
            AsciiArtCoordinate aacStart = new AsciiArtCoordinate(this.asciiArtPad);
            aacStart.setTransXY(0.0, this.asciiArtPad.getYGrid() / 2.0);
            AsciiArtCoordinate aacEnd = new AsciiArtCoordinate(this.asciiArtPad);
            aacEnd.setTransXY(0.0, this.asciiArtPad.getYGrid() / 2.0);
            try {
                RE reCorner = new RE("[+\\\\/]");
                int r = 0;
                while (r < this.aa.getH()) {
                    String row = this.aa.getRow(r);
                    int startIndex = 0;
                    while (reCorner.match(row, startIndex)) {
                        String s = reCorner.getParen(0);
                        int mStart = reCorner.getParenStart(0);
                        int mEnd = reCorner.getParenEnd(0);
                        if (s.equals("\\")) {
                            aacStart.setXY(mStart, r - 1);
                            aacEnd.setXY(mStart + 1, r);
                        } else if (s.equals("/")) {
                            aacStart.setXY(mStart + 1, r - 1);
                            aacEnd.setXY(mStart, r);
                        } else {
                            aacStart.setXY(mStart, r);
                            aacEnd.setXY(mStart, r);
                        }
                        AsciiArtLine aal = new AsciiArtLine(aacStart, aacEnd);
                        this.asciiArtPad.add(aal);
                        if (startIndex >= mEnd) break;
                        startIndex = mEnd;
                    }
                    ++r;
                }
            }
            catch (RESyntaxException rese) {
                rese.printStackTrace();
            }
        }

        protected void findLinePattern() {
            AsciiArtLine aal;
            int mEnd;
            int mStart;
            int startIndex;
            AsciiArtCoordinate aacStart = new AsciiArtCoordinate(this.asciiArtPad);
            aacStart.setTransXY(0.0, this.asciiArtPad.getYGrid() / 2.0);
            AsciiArtCoordinate aacEnd = new AsciiArtCoordinate(this.asciiArtPad);
            aacEnd.setTransXY(0.0, this.asciiArtPad.getYGrid() / 2.0);
            try {
                RE reHorLine = new RE("[\\-~=+]+");
                int r = 0;
                while (r < this.aa.getH()) {
                    String row = this.aa.getRow(r);
                    startIndex = 0;
                    while (reHorLine.match(row, startIndex)) {
                        mStart = reHorLine.getParenStart(0);
                        mEnd = reHorLine.getParenEnd(0);
                        aacStart.setXY(mStart, r);
                        aacEnd.setXY(mEnd - 1, r);
                        aal = new AsciiArtLine(aacStart, aacEnd);
                        this.asciiArtPad.add(aal);
                        if (startIndex >= mEnd) break;
                        startIndex = mEnd;
                    }
                    ++r;
                }
            }
            catch (RESyntaxException rese) {
                rese.printStackTrace();
            }
            try {
                RE reVerLine = new RE("[|+]+");
                int c = 0;
                while (c < this.aa.getW()) {
                    String col = this.aa.getColumn(c);
                    startIndex = 0;
                    while (reVerLine.match(col, startIndex)) {
                        mStart = reVerLine.getParenStart(0);
                        mEnd = reVerLine.getParenEnd(0);
                        aacStart.setXY(c, mStart);
                        aacEnd.setXY(c, mEnd - 1);
                        aal = new AsciiArtLine(aacStart, aacEnd);
                        this.asciiArtPad.add(aal);
                        if (startIndex >= mEnd) break;
                        startIndex = mEnd;
                    }
                    ++c;
                }
            }
            catch (RESyntaxException rese) {
                rese.printStackTrace();
            }
        }

        protected void findStringPattern() {
            AsciiArtCoordinate aacStart = new AsciiArtCoordinate(this.asciiArtPad);
            aacStart.setTransXY(0.0, 3.0 * this.asciiArtPad.getYGrid() / 4.0);
            try {
                RE reString = new RE("[^\\-|~=\\/+ \\\\][^\\-|~=\\/+ \\\\]*");
                int r = 0;
                while (r < this.aa.getH()) {
                    String row = this.aa.getRow(r);
                    int startIndex = 0;
                    while (reString.match(row, startIndex)) {
                        String s = reString.getParen(0);
                        int mStart = reString.getParenStart(0);
                        int mEnd = reString.getParenEnd(0);
                        aacStart.setXY(mStart, r);
                        AsciiArtString aas = new AsciiArtString(aacStart, s);
                        this.asciiArtPad.add(aas);
                        if (startIndex >= mEnd) break;
                        startIndex = mEnd;
                    }
                    ++r;
                }
            }
            catch (RESyntaxException rese) {
                rese.printStackTrace();
            }
        }
    }

    public static class AsciiArt {
        private String[] s;
        private int w;
        private int h;

        public AsciiArt(String[] s) {
            int length;
            this.s = s;
            this.h = length = s.length;
            this.w = 0;
            int i = 0;
            while (i < length) {
                String line = s[i];
                if (line != null && line.length() > this.w) {
                    this.w = line.length();
                }
                ++i;
            }
        }

        public int getW() {
            return this.w;
        }

        public int getH() {
            return this.h;
        }

        public String getRow(int r) {
            String row = this.s[r];
            return row;
        }

        public String getColumn(int c) {
            StringBuffer column = new StringBuffer();
            String EMPTY_CHAR = " ";
            int i = 0;
            while (i < this.s.length) {
                if (this.s[i] != null && c < this.s[i].length()) {
                    column.append(this.s[i].charAt(c));
                } else {
                    column.append(" ");
                }
                ++i;
            }
            return column.toString();
        }
    }

    public static class AsciiArtCoordinate {
        int x;
        int y;
        AsciiArtPad asciiArtPad;
        double tx;
        double ty;

        public AsciiArtCoordinate() {
        }

        public AsciiArtCoordinate(AsciiArtPad asciiArtPad) {
            this.setAsciiArtPad(asciiArtPad);
        }

        public AsciiArtCoordinate(int x, int y) {
            this.setXY(x, y);
        }

        public void setAsciiArtPad(AsciiArtPad asciiArtPad) {
            this.asciiArtPad = asciiArtPad;
        }

        public void setTransXY(double tx, double ty) {
            this.tx = tx;
            this.ty = ty;
        }

        public void setXY(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public double getXDouble() {
            return (double)this.x * this.asciiArtPad.getXGrid() + this.tx;
        }

        public double getYDouble() {
            return (double)this.y * this.asciiArtPad.getYGrid() + this.ty;
        }
    }

    public static class AsciiArtString
    implements AsciiArtElement {
        private double x;
        private double y;
        private String s;

        public AsciiArtString(AsciiArtCoordinate aac, String s) {
            this.x = aac.getXDouble();
            this.y = aac.getYDouble();
            this.s = s;
        }

        public void setX(double x) {
            this.x = x;
        }

        public void setY(double y) {
            this.y = y;
        }

        public void setS(String s) {
            this.s = s;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public String getS() {
            return this.s;
        }

        public String toString() {
            String s = "[x:" + String.valueOf(this.x) + "]" + "[y:" + String.valueOf(this.y) + "]" + "[s:" + String.valueOf(this.s) + "]";
            return s;
        }
    }

    public static class AsciiArtRect
    implements AsciiArtElement {
        double xUpperLeft;
        double yUpperLeft;
        double xLowerRight;
        double yLowerRight;

        public AsciiArtRect(AsciiArtCoordinate upperLeft, AsciiArtCoordinate lowerRight) {
            this.xUpperLeft = upperLeft.getXDouble();
            this.yUpperLeft = upperLeft.getYDouble();
            this.xLowerRight = lowerRight.getXDouble();
            this.yLowerRight = lowerRight.getYDouble();
        }

        public void setXUpperLeft(double xUpperLeft) {
            this.xUpperLeft = xUpperLeft;
        }

        public void setYUpperLeft(double yUpperLeft) {
            this.yUpperLeft = yUpperLeft;
        }

        public void setXLowerRight(double xLowerRight) {
            this.xLowerRight = xLowerRight;
        }

        public void setYLowerRight(double yLowerRight) {
            this.yLowerRight = yLowerRight;
        }

        public double getXUpperLeft() {
            return this.xUpperLeft;
        }

        public double getYUpperLeft() {
            return this.yUpperLeft;
        }

        public double getXLowerRight() {
            return this.xLowerRight;
        }

        public double getYLowerRight() {
            return this.yLowerRight;
        }

        public double getWidth() {
            return Math.abs(this.xUpperLeft - this.xLowerRight);
        }

        public double getHeight() {
            return Math.abs(this.yUpperLeft - this.yLowerRight);
        }

        public String toString() {
            String s = "[xUpperLeft:" + String.valueOf(this.xUpperLeft) + "]" + "[yUpperLeft:" + String.valueOf(this.yUpperLeft) + "]" + "[xLowerRight:" + String.valueOf(this.xLowerRight) + "]" + "[yLowerRight:" + String.valueOf(this.yLowerRight) + "]";
            return s;
        }
    }

    public static class AsciiArtLine
    implements AsciiArtElement {
        double xStart;
        double yStart;
        double xEnd;
        double yEnd;

        public AsciiArtLine(AsciiArtCoordinate start, AsciiArtCoordinate end) {
            this.xStart = start.getXDouble();
            this.yStart = start.getYDouble();
            this.xEnd = end.getXDouble();
            this.yEnd = end.getYDouble();
        }

        public void setXStart(double xStart) {
            this.xStart = xStart;
        }

        public void setYStart(double yStart) {
            this.yStart = yStart;
        }

        public void setXEnd(double xEnd) {
            this.xEnd = xEnd;
        }

        public void setYEnd(double yEnd) {
            this.yEnd = yEnd;
        }

        public double getXStart() {
            return this.xStart;
        }

        public double getYStart() {
            return this.yStart;
        }

        public double getXEnd() {
            return this.xEnd;
        }

        public double getYEnd() {
            return this.yEnd;
        }

        public String toString() {
            String s = "[xStart:" + String.valueOf(this.xStart) + "]" + "[yStart:" + String.valueOf(this.yStart) + "]" + "[xEnd:" + String.valueOf(this.xEnd) + "]" + "[yEnd:" + String.valueOf(this.yEnd) + "]";
            return s;
        }
    }
}

