/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.slop.parsing;

import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.slop.interfaces.SlopConstants;
import org.apache.cocoon.slop.interfaces.SlopParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleSlopParser
implements SlopParser,
SlopConstants {
    private ContentHandler contentHandler;
    private static final String DEFAULT_TAGNAME_CHARS = "-_";
    private String tagnameChars = "-_";
    static final String VALID_TAGNAME_CHARS = "_-";
    static final String TAGNAME_REPLACEMENT_CHAR = "_";
    private boolean preserveSpace = false;
    private int lineCounter;

    static String filterElementName(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (Character.isLetter(c)) {
                sb.append(c);
            } else if (Character.isDigit(c) && i > 0) {
                sb.append(c);
            } else if (VALID_TAGNAME_CHARS.indexOf(c) >= 0) {
                sb.append(c);
            } else {
                sb.append(TAGNAME_REPLACEMENT_CHAR);
            }
            ++i;
        }
        return sb.toString();
    }

    public void setValidTagnameChars(String str) {
        this.tagnameChars = str == null ? DEFAULT_TAGNAME_CHARS : str.trim();
    }

    public void setPreserveWhitespace(boolean b) {
        this.preserveSpace = b;
    }

    public void startDocument(ContentHandler destination) throws SAXException, ProcessingException {
        this.contentHandler = destination;
        this.contentHandler.startDocument();
        this.contentHandler.startPrefixMapping("", "http://apache.org/cocoon/slop/parser/1.0");
        AttributesImpl atts = new AttributesImpl();
        this.contentHandler.startElement("http://apache.org/cocoon/slop/parser/1.0", "parsed-text", "parsed-text", atts);
    }

    public void endDocument() throws SAXException, ProcessingException {
        this.contentHandler.endElement("http://apache.org/cocoon/slop/parser/1.0", "parsed-text", "parsed-text");
        this.contentHandler.endPrefixMapping("");
        this.contentHandler.endDocument();
        this.contentHandler = null;
    }

    private void setAttribute(AttributesImpl attr, String name, String value) {
        String ATTR_TYPE = "NMTOKEN";
        attr.addAttribute("", name, name, "NMTOKEN", value);
    }

    public void processLine(String line) throws SAXException, ProcessingException {
        if (this.contentHandler == null) {
            throw new ProcessingException("SimpleSlopParser content handler is null (startDocument not called?)");
        }
        ParsedLine p = this.parseLine(line);
        ++this.lineCounter;
        AttributesImpl atts = new AttributesImpl();
        this.setAttribute(atts, "line-number", String.valueOf(this.lineCounter));
        this.contentHandler.startElement("http://apache.org/cocoon/slop/parser/1.0", p.name, p.name, atts);
        this.contentHandler.characters(p.contents.toCharArray(), 0, p.contents.length());
        this.contentHandler.endElement("http://apache.org/cocoon/slop/parser/1.0", p.name, p.name);
    }

    protected ParsedLine parseLine(String line) {
        int colonPos;
        ParsedLine result = null;
        if (line == null || line.trim().length() == 0) {
            result = new ParsedLine("empty-line", "");
        }
        if (result == null && (colonPos = line.indexOf(58)) > 0) {
            boolean fieldFound = true;
            int i = 0;
            while (i < colonPos) {
                boolean isFieldChar;
                char c = line.charAt(i);
                boolean bl = isFieldChar = Character.isLetter(c) || this.tagnameChars.indexOf(c) >= 0;
                if (!isFieldChar) {
                    fieldFound = false;
                    break;
                }
                ++i;
            }
            if (fieldFound) {
                String contents = "";
                if (line.length() > colonPos + 1) {
                    String str = line.substring(colonPos + 1);
                    contents = this.preserveSpace ? str : str.trim();
                }
                result = new ParsedLine(line.substring(0, colonPos), contents);
            }
        }
        if (result == null) {
            String str = this.preserveSpace ? line : line.trim();
            result = new ParsedLine("line", str);
        }
        return result;
    }

    static class ParsedLine {
        final String name;
        final String contents;

        ParsedLine(String elementName, String elementContents) {
            this.name = SimpleSlopParser.filterElementName(elementName);
            this.contents = elementContents;
        }
    }
}

