/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.disk.indexed;

import java.io.File;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.disk.AbstractDiskCache;
import org.apache.jcs.auxiliary.disk.LRUMapJCS;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDisk;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCacheAttributes;
import org.apache.jcs.auxiliary.disk.indexed.IndexedDiskElementDescriptor;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.apache.jcs.utils.locking.ReadWriteLock;

public class IndexedDiskCache
extends AbstractDiskCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache == null ? (class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache = IndexedDiskCache.class$("org.apache.jcs.auxiliary.disk.indexed.IndexedDiskCache")) : class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache));
    private String fileName;
    private IndexedDisk dataFile;
    private IndexedDisk keyFile;
    private LRUMapJCS keyHash;
    private int maxKeySize;
    private File rafDir;
    IndexedDiskCacheAttributes cattr;
    protected ReadWriteLock storageLock = new ReadWriteLock();
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$disk$indexed$IndexedDiskCache;

    public IndexedDiskCache(IndexedDiskCacheAttributes cattr) {
        super(cattr.getCacheName());
        String cacheName = cattr.getCacheName();
        String rootDirName = cattr.getDiskPath();
        this.maxKeySize = cattr.getMaxKeySize();
        this.cattr = cattr;
        this.fileName = cacheName;
        this.rafDir = new File(rootDirName);
        this.rafDir.mkdirs();
        log.info((Object)("Cache file root directory: " + rootDirName));
        try {
            this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"));
            this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"));
            if (this.keyFile.length() > 0L) {
                this.loadKeys();
                if (this.keyHash.size() == 0) {
                    this.dataFile.reset();
                }
            } else {
                this.keyHash = new LRUMapJCS(this.maxKeySize);
                if (this.dataFile.length() > 0L) {
                    this.dataFile.reset();
                }
            }
            this.alive = true;
        }
        catch (Exception e) {
            log.error((Object)("Failure initializing for fileName: " + this.fileName + " and root directory: " + rootDirName), (Throwable)e);
        }
    }

    private void loadKeys() throws InterruptedException {
        this.storageLock.writeLock();
        if (log.isInfoEnabled()) {
            log.info((Object)("loading keys for " + this.keyFile.toString()));
        }
        try {
            block10: {
                try {
                    this.keyHash = (LRUMapJCS)((Object)this.keyFile.readObject(0L));
                    if (this.keyHash == null) {
                        this.keyHash = new LRUMapJCS(this.maxKeySize);
                    } else {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Loaded keys from: " + this.fileName + ", key count: " + this.keyHash.size()));
                        }
                        this.keyHash.setMaximumSize(this.maxKeySize);
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Reset maxKeySize to: '" + this.maxKeySize + "'"));
                        }
                    }
                    if (!log.isDebugEnabled()) break block10;
                    Iterator itr = this.keyHash.entrySet().iterator();
                    while (itr.hasNext()) {
                        Map.Entry e = (Map.Entry)itr.next();
                        String key = (String)e.getKey();
                        IndexedDiskElementDescriptor de = (IndexedDiskElementDescriptor)e.getValue();
                        log.debug((Object)("key entry: " + key + ", ded.pos" + de.pos + ", ded.len" + de.len));
                    }
                }
                catch (Exception e) {
                    log.error((Object)this.fileName, (Throwable)e);
                    Object var6_7 = null;
                    this.storageLock.done();
                }
            }
            Object var6_6 = null;
            this.storageLock.done();
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.storageLock.done();
            throw throwable;
        }
    }

    private void saveKeys() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saving keys to: " + this.fileName + ", key count: " + this.keyHash.size()));
            }
            this.storageLock.writeLock();
            try {
                this.keyFile.reset();
                if (this.keyHash.size() > 0) {
                    this.keyFile.writeObject((Serializable)((Object)this.keyHash), 0L);
                }
                Object var2_1 = null;
                this.storageLock.done();
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this.storageLock.done();
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    public void doUpdate(ICacheElement ce) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing element on disk, key: " + ce.getKey()));
        }
        IndexedDiskElementDescriptor ded = null;
        try {
            ded = new IndexedDiskElementDescriptor();
            byte[] data = IndexedDisk.serialize(ce);
            ded.init(this.dataFile.length(), data);
            this.storageLock.writeLock();
            try {
                if (!this.alive) {
                    Object var6_5 = null;
                    this.storageLock.done();
                    return;
                }
                IndexedDiskElementDescriptor old = (IndexedDiskElementDescriptor)this.keyHash.put(ce.getKey(), ded);
                if (old != null && ded.len <= old.len) {
                    ded.pos = old.pos;
                }
                this.dataFile.write(data, ded.pos);
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.storageLock.done();
                throw throwable;
            }
            Object var6_6 = null;
            this.storageLock.done();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Put to file: " + this.fileName + ", key: " + ce.getKey() + ", position: " + ded.pos + ", size: " + ded.len));
            }
        }
        catch (ConcurrentModificationException cme) {
        }
        catch (Exception e) {
            log.error((Object)("Failure updating element, cacheName: " + this.cacheName + ", key: " + ce.getKey()), (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ICacheElement doGet(Serializable key) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Trying to get from disk: " + key));
        }
        CacheElement object = null;
        try {
            try {
                this.storageLock.readLock();
                if (!this.alive) {
                    log.debug((Object)("No longer alive so returning null, cacheName: " + this.cacheName + ", key = " + key));
                    ICacheElement iCacheElement = null;
                    Object var5_5 = null;
                    this.storageLock.done();
                    return iCacheElement;
                }
                object = this.readElement(key);
            }
            catch (Exception e) {
                log.error((Object)("Failure getting from disk, cacheName: " + this.cacheName + ", key = " + key), (Throwable)e);
                Object var5_7 = null;
                this.storageLock.done();
                return object;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            this.storageLock.done();
            throw throwable;
        }
        Object var5_6 = null;
        this.storageLock.done();
        return object;
    }

    private CacheElement readElement(Serializable key) throws Exception {
        CacheElement object = null;
        IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)this.keyHash.get(key);
        if (ded != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found on disk, key: " + key));
            }
            object = (CacheElement)this.dataFile.readObject(ded.pos);
        }
        return object;
    }

    public Set getGroupKeys(String groupName) {
        GroupId groupId = new GroupId(this.cacheName, groupName);
        HashSet<Object> keys = new HashSet<Object>();
        try {
            try {
                this.storageLock.readLock();
                Iterator itr = this.keyHash.keySet().iterator();
                while (itr.hasNext()) {
                    Object k = itr.next();
                    if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(groupId)) continue;
                    keys.add(((GroupAttrName)k).attrName);
                }
            }
            catch (Exception e) {
                log.error((Object)("Failure getting from disk, cacheName: " + this.cacheName + ", group = " + groupName), (Throwable)e);
                Object var7_8 = null;
                this.storageLock.done();
            }
            Object var7_7 = null;
            this.storageLock.done();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            this.storageLock.done();
            throw throwable;
        }
        return keys;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doRemove(Serializable key) {
        boolean iter3;
        block10: {
            boolean removed = false;
            try {
                try {
                    this.storageLock.writeLock();
                    if (key instanceof String && key.toString().endsWith(":")) {
                        Iterator iter2 = this.keyHash.entrySet().iterator();
                        while (true) {
                            if (!iter2.hasNext()) {
                                boolean entry = removed;
                                Object var7_12 = null;
                                this.storageLock.done();
                                return entry;
                            }
                            Map.Entry entry = (Map.Entry)iter2.next();
                            Object k = entry.getKey();
                            if (!(k instanceof String) || !k.toString().startsWith(key.toString())) continue;
                            iter2.remove();
                            removed = true;
                        }
                    }
                    if (!(key instanceof GroupId)) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Disk removal: Removed from key hash, key " + key));
                        }
                        iter3 = this.keyHash.remove(key) != null;
                        break block10;
                    }
                    Iterator iter3 = this.keyHash.entrySet().iterator();
                    while (iter3.hasNext()) {
                        Map.Entry entry = (Map.Entry)iter3.next();
                        Object k = entry.getKey();
                        if (!(k instanceof GroupAttrName) || !((GroupAttrName)k).groupId.equals(key)) continue;
                        iter3.remove();
                        removed = true;
                    }
                    Object var7_14 = null;
                    this.storageLock.done();
                    return false;
                }
                catch (Exception e) {
                    log.error((Object)e);
                    this.reset();
                    Object var7_15 = null;
                    this.storageLock.done();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var7_16 = null;
                this.storageLock.done();
                throw throwable;
            }
        }
        Object var7_13 = null;
        this.storageLock.done();
        return iter3;
    }

    public void doRemoveAll() {
        try {
            try {
                this.reset();
            }
            catch (Exception e) {
                log.error((Object)e);
                this.reset();
                Object var3_2 = null;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    private void reset() {
        log.debug((Object)"Reseting cache");
        try {
            try {
                this.storageLock.writeLock();
                this.dataFile.close();
                File file = new File(this.rafDir, this.fileName + ".data");
                file.delete();
                this.keyFile.close();
                File file2 = new File(this.rafDir, this.fileName + ".key");
                file2.delete();
                this.dataFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".data"));
                this.keyFile = new IndexedDisk(new File(this.rafDir, this.fileName + ".key"));
                this.keyHash = new LRUMapJCS(this.maxKeySize);
            }
            catch (Exception e) {
                log.error((Object)"Failure reseting state", (Throwable)e);
                Object var4_5 = null;
                this.storageLock.done();
            }
            Object var4_4 = null;
            this.storageLock.done();
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.storageLock.done();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doDispose() {
        try {
            block14: {
                this.storageLock.writeLock();
                if (this.alive) break block14;
                IndexedDiskCache.log.debug((Object)("Not alive and dispose was called, filename: " + this.fileName));
                var3_1 = null;
                this.alive = false;
                ** GOTO lbl48
            }
            try {
                this.optimizeFile();
            }
            catch (Exception e) {
                IndexedDiskCache.log.error((Object)this.fileName, (Throwable)e);
            }
            try {
                IndexedDiskCache.log.warn((Object)("Closing files, base filename: " + this.fileName));
                this.dataFile.close();
                this.dataFile = null;
                this.keyFile.close();
                this.keyFile = null;
            }
            catch (Exception e) {
                IndexedDiskCache.log.error((Object)("Failure closing files in dispose, filename: " + this.fileName), (Throwable)e);
            }
            ** GOTO lbl54
        }
        catch (Exception e) {
            IndexedDiskCache.log.error((Object)"Failure in dispose", (Throwable)e);
            var3_3 = null;
            this.alive = false;
            try {
                this.storageLock.done();
                return;
            }
            catch (Exception e) {
                IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
                return;
            }
        }
        {
            catch (Throwable var2_12) {
                var3_4 = null;
                this.alive = false;
                ** try [egrp 4[TRYBLOCK] [4 : 194->204)] { 
lbl43:
                // 1 sources

                this.storageLock.done();
                throw var2_12;
lbl45:
                // 1 sources

                catch (Exception e) {
                    IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
                }
                throw var2_12;
            }
lbl48:
            // 1 sources

            ** try [egrp 4[TRYBLOCK] [4 : 194->204)] { 
lbl49:
            // 1 sources

            this.storageLock.done();
            return;
lbl51:
            // 1 sources

            catch (Exception e) {
                IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
            }
            return;
lbl54:
            // 2 sources

            var3_2 = null;
            this.alive = false;
            try {}
            catch (Exception e) {}
            IndexedDiskCache.log.error((Object)("Failure releasing lock on shutdown " + e));
            return;
            this.storageLock.done();
            return;
        }
    }

    private void optimizeFile() {
        try {
            LRUMapJCS keyHashTemp = new LRUMapJCS(this.maxKeySize);
            IndexedDisk dataFileTemp = new IndexedDisk(new File(this.rafDir, this.fileName + "Temp.data"));
            if (log.isInfoEnabled()) {
                log.info((Object)("Optomizing file keyHash.size()=" + this.keyHash.size()));
            }
            Object[] keys = this.keyHash.keySet().toArray();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                Serializable key = (Serializable)keys[i];
                CacheElement tempDe = this.readElement(key);
                try {
                    IndexedDiskElementDescriptor ded = new IndexedDiskElementDescriptor();
                    byte[] data = IndexedDisk.serialize(tempDe);
                    ded.init(dataFileTemp.length(), data);
                    dataFileTemp.write(data, ded.pos);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Optomize: Put to temp disk cache: " + this.fileName + ", key: " + key + ", ded.pos:" + ded.pos + ", ded.len:" + ded.len));
                    }
                    keyHashTemp.put(key, ded);
                }
                catch (Exception e) {
                    log.error((Object)("Failed to put to temp disk cache: " + this.fileName + ", key: " + key), (Throwable)e);
                }
                ++i;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)(this.fileName + " -- keyHashTemp.size(): " + keyHashTemp.size() + ", keyHash.size(): " + this.keyHash.size()));
            }
            dataFileTemp.close();
            this.dataFile.close();
            File oldData = new File(this.rafDir, this.fileName + ".data");
            if (oldData.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.fileName + " -- oldData.length() = " + oldData.length()));
                }
                oldData.delete();
            }
            File newData = new File(this.rafDir, this.fileName + "Temp.data");
            File newFileName = new File(this.rafDir, this.fileName + ".data");
            if (newData.exists()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)(this.fileName + " -- newData.length() = " + newData.length()));
                }
                newData.renameTo(newFileName);
            }
            this.keyHash = keyHashTemp;
            this.keyFile.reset();
            this.saveKeys();
        }
        catch (Exception e) {
            log.error((Object)this.fileName, (Throwable)e);
        }
    }

    public int getSize() {
        return this.keyHash.size();
    }

    public void dump() {
        log.debug((Object)("[dump] Number of keys: " + this.keyHash.size()));
        Iterator itr = this.keyHash.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            Serializable key = (Serializable)e.getKey();
            IndexedDiskElementDescriptor ded = (IndexedDiskElementDescriptor)e.getValue();
            ICacheElement val = this.get(key);
            log.debug((Object)("[dump] Disk element, key: " + key + ", val: " + val + ", pos: " + ded.pos));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

