/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.tidy;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.tidy.Lexer;
import org.w3c.tidy.Report;
import org.w3c.tidy.TagTable;

public class Configuration
implements Serializable {
    public static final int RAW = 0;
    public static final int ASCII = 1;
    public static final int LATIN1 = 2;
    public static final int UTF8 = 3;
    public static final int ISO2022 = 4;
    public static final int MACROMAN = 5;
    public static final int DOCTYPE_OMIT = 0;
    public static final int DOCTYPE_AUTO = 1;
    public static final int DOCTYPE_STRICT = 2;
    public static final int DOCTYPE_LOOSE = 3;
    public static final int DOCTYPE_USER = 4;
    protected int spaces = 2;
    protected int wraplen = 68;
    protected int CharEncoding = 1;
    protected int tabsize = 4;
    protected int docTypeMode = 1;
    protected String altText = null;
    protected String slidestyle = null;
    protected String docTypeStr = null;
    protected String errfile = null;
    protected boolean writeback = false;
    protected boolean OnlyErrors = false;
    protected boolean ShowWarnings = true;
    protected boolean Quiet = false;
    protected boolean IndentContent = false;
    protected boolean SmartIndent = false;
    protected boolean HideEndTags = false;
    protected boolean XmlTags = false;
    protected boolean XmlOut = false;
    protected boolean xHTML = false;
    protected boolean XmlPi = false;
    protected boolean RawOut = false;
    protected boolean UpperCaseTags = false;
    protected boolean UpperCaseAttrs = false;
    protected boolean MakeClean = false;
    protected boolean LogicalEmphasis = false;
    protected boolean DropFontTags = false;
    protected boolean DropEmptyParas = true;
    protected boolean FixComments = true;
    protected boolean BreakBeforeBR = false;
    protected boolean BurstSlides = false;
    protected boolean NumEntities = false;
    protected boolean QuoteMarks = false;
    protected boolean QuoteNbsp = true;
    protected boolean QuoteAmpersand = true;
    protected boolean WrapAttVals = false;
    protected boolean WrapScriptlets = false;
    protected boolean WrapSection = true;
    protected boolean WrapAsp = true;
    protected boolean WrapJste = true;
    protected boolean WrapPhp = true;
    protected boolean FixBackslash = true;
    protected boolean IndentAttributes = false;
    protected boolean XmlPIs = false;
    protected boolean XmlSpace = false;
    protected boolean EncloseBodyText = false;
    protected boolean EncloseBlockText = false;
    protected boolean KeepFileTimes = true;
    protected boolean Word2000 = false;
    protected boolean TidyMark = true;
    protected boolean Emacs = false;
    protected boolean LiteralAttribs = false;
    protected TagTable tt;
    private transient Properties _properties = new Properties();

    public void addProps(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            this._properties.put(string, string2);
        }
        this.parseProps();
    }

    public void parseFile(String string) {
        try {
            this._properties.load(new FileInputStream(string));
        }
        catch (IOException iOException) {
            System.err.println(string + iOException.toString());
            return;
        }
        this.parseProps();
    }

    private void parseProps() {
        String string = this._properties.getProperty("indent-spaces");
        if (string != null) {
            this.spaces = Configuration.parseInt(string, "indent-spaces");
        }
        if ((string = this._properties.getProperty("wrap")) != null) {
            this.wraplen = Configuration.parseInt(string, "wrap");
        }
        if ((string = this._properties.getProperty("wrap-attributes")) != null) {
            this.WrapAttVals = Configuration.parseBool(string, "wrap-attributes");
        }
        if ((string = this._properties.getProperty("wrap-script-literals")) != null) {
            this.WrapScriptlets = Configuration.parseBool(string, "wrap-script-literals");
        }
        if ((string = this._properties.getProperty("wrap-sections")) != null) {
            this.WrapSection = Configuration.parseBool(string, "wrap-sections");
        }
        if ((string = this._properties.getProperty("wrap-asp")) != null) {
            this.WrapAsp = Configuration.parseBool(string, "wrap-asp");
        }
        if ((string = this._properties.getProperty("wrap-jste")) != null) {
            this.WrapJste = Configuration.parseBool(string, "wrap-jste");
        }
        if ((string = this._properties.getProperty("wrap-php")) != null) {
            this.WrapPhp = Configuration.parseBool(string, "wrap-php");
        }
        if ((string = this._properties.getProperty("literal-attributes")) != null) {
            this.LiteralAttribs = Configuration.parseBool(string, "literal-attributes");
        }
        if ((string = this._properties.getProperty("tab-size")) != null) {
            this.tabsize = Configuration.parseInt(string, "tab-size");
        }
        if ((string = this._properties.getProperty("markup")) != null) {
            this.OnlyErrors = Configuration.parseInvBool(string, "markup");
        }
        if ((string = this._properties.getProperty("quiet")) != null) {
            this.Quiet = Configuration.parseBool(string, "quiet");
        }
        if ((string = this._properties.getProperty("tidy-mark")) != null) {
            this.TidyMark = Configuration.parseBool(string, "tidy-mark");
        }
        if ((string = this._properties.getProperty("indent")) != null) {
            this.IndentContent = this.parseIndent(string, "indent");
        }
        if ((string = this._properties.getProperty("indent-attributes")) != null) {
            this.IndentAttributes = Configuration.parseBool(string, "ident-attributes");
        }
        if ((string = this._properties.getProperty("hide-endtags")) != null) {
            this.HideEndTags = Configuration.parseBool(string, "hide-endtags");
        }
        if ((string = this._properties.getProperty("input-xml")) != null) {
            this.XmlTags = Configuration.parseBool(string, "input-xml");
        }
        if ((string = this._properties.getProperty("output-xml")) != null) {
            this.XmlOut = Configuration.parseBool(string, "output-xml");
        }
        if ((string = this._properties.getProperty("output-xhtml")) != null) {
            this.xHTML = Configuration.parseBool(string, "output-xhtml");
        }
        if ((string = this._properties.getProperty("add-xml-pi")) != null) {
            this.XmlPi = Configuration.parseBool(string, "add-xml-pi");
        }
        if ((string = this._properties.getProperty("add-xml-decl")) != null) {
            this.XmlPi = Configuration.parseBool(string, "add-xml-decl");
        }
        if ((string = this._properties.getProperty("assume-xml-procins")) != null) {
            this.XmlPIs = Configuration.parseBool(string, "assume-xml-procins");
        }
        if ((string = this._properties.getProperty("raw")) != null) {
            this.RawOut = Configuration.parseBool(string, "raw");
        }
        if ((string = this._properties.getProperty("uppercase-tags")) != null) {
            this.UpperCaseTags = Configuration.parseBool(string, "uppercase-tags");
        }
        if ((string = this._properties.getProperty("uppercase-attributes")) != null) {
            this.UpperCaseAttrs = Configuration.parseBool(string, "uppercase-attributes");
        }
        if ((string = this._properties.getProperty("clean")) != null) {
            this.MakeClean = Configuration.parseBool(string, "clean");
        }
        if ((string = this._properties.getProperty("logical-emphasis")) != null) {
            this.LogicalEmphasis = Configuration.parseBool(string, "logical-emphasis");
        }
        if ((string = this._properties.getProperty("word-2000")) != null) {
            this.Word2000 = Configuration.parseBool(string, "word-2000");
        }
        if ((string = this._properties.getProperty("drop-empty-paras")) != null) {
            this.DropEmptyParas = Configuration.parseBool(string, "drop-empty-paras");
        }
        if ((string = this._properties.getProperty("drop-font-tags")) != null) {
            this.DropFontTags = Configuration.parseBool(string, "drop-font-tags");
        }
        if ((string = this._properties.getProperty("enclose-text")) != null) {
            this.EncloseBodyText = Configuration.parseBool(string, "enclose-text");
        }
        if ((string = this._properties.getProperty("enclose-block-text")) != null) {
            this.EncloseBlockText = Configuration.parseBool(string, "enclose-block-text");
        }
        if ((string = this._properties.getProperty("alt-text")) != null) {
            this.altText = string;
        }
        if ((string = this._properties.getProperty("add-xml-space")) != null) {
            this.XmlSpace = Configuration.parseBool(string, "add-xml-space");
        }
        if ((string = this._properties.getProperty("fix-bad-comments")) != null) {
            this.FixComments = Configuration.parseBool(string, "fix-bad-comments");
        }
        if ((string = this._properties.getProperty("split")) != null) {
            this.BurstSlides = Configuration.parseBool(string, "split");
        }
        if ((string = this._properties.getProperty("break-before-br")) != null) {
            this.BreakBeforeBR = Configuration.parseBool(string, "break-before-br");
        }
        if ((string = this._properties.getProperty("numeric-entities")) != null) {
            this.NumEntities = Configuration.parseBool(string, "numeric-entities");
        }
        if ((string = this._properties.getProperty("quote-marks")) != null) {
            this.QuoteMarks = Configuration.parseBool(string, "quote-marks");
        }
        if ((string = this._properties.getProperty("quote-nbsp")) != null) {
            this.QuoteNbsp = Configuration.parseBool(string, "quote-nbsp");
        }
        if ((string = this._properties.getProperty("quote-ampersand")) != null) {
            this.QuoteAmpersand = Configuration.parseBool(string, "quote-ampersand");
        }
        if ((string = this._properties.getProperty("write-back")) != null) {
            this.writeback = Configuration.parseBool(string, "write-back");
        }
        if ((string = this._properties.getProperty("keep-time")) != null) {
            this.KeepFileTimes = Configuration.parseBool(string, "keep-time");
        }
        if ((string = this._properties.getProperty("show-warnings")) != null) {
            this.ShowWarnings = Configuration.parseBool(string, "show-warnings");
        }
        if ((string = this._properties.getProperty("error-file")) != null) {
            this.errfile = Configuration.parseName(string, "error-file");
        }
        if ((string = this._properties.getProperty("slide-style")) != null) {
            this.slidestyle = Configuration.parseName(string, "slide-style");
        }
        if ((string = this._properties.getProperty("new-inline-tags")) != null) {
            this.parseInlineTagNames(string, "new-inline-tags");
        }
        if ((string = this._properties.getProperty("new-blocklevel-tags")) != null) {
            this.parseBlockTagNames(string, "new-blocklevel-tags");
        }
        if ((string = this._properties.getProperty("new-empty-tags")) != null) {
            this.parseEmptyTagNames(string, "new-empty-tags");
        }
        if ((string = this._properties.getProperty("new-pre-tags")) != null) {
            this.parsePreTagNames(string, "new-pre-tags");
        }
        if ((string = this._properties.getProperty("char-encoding")) != null) {
            this.CharEncoding = Configuration.parseCharEncoding(string, "char-encoding");
        }
        if ((string = this._properties.getProperty("doctype")) != null) {
            this.docTypeStr = this.parseDocType(string, "doctype");
        }
        if ((string = this._properties.getProperty("fix-backslash")) != null) {
            this.FixBackslash = Configuration.parseBool(string, "fix-backslash");
        }
        if ((string = this._properties.getProperty("gnu-emacs")) != null) {
            this.Emacs = Configuration.parseBool(string, "gnu-emacs");
        }
    }

    public void adjust() {
        if (this.EncloseBlockText) {
            this.EncloseBodyText = true;
        }
        if (this.SmartIndent) {
            this.IndentContent = true;
        }
        if (this.wraplen == 0) {
            this.wraplen = Integer.MAX_VALUE;
        }
        if (this.Word2000) {
            this.tt.defineInlineTag("o:p");
        }
        if (this.xHTML) {
            this.XmlOut = true;
            this.UpperCaseTags = false;
            this.UpperCaseAttrs = false;
        }
        if (this.XmlTags) {
            this.XmlOut = true;
            this.XmlPIs = true;
        }
        if (this.XmlOut) {
            this.QuoteAmpersand = true;
            this.HideEndTags = false;
        }
    }

    private static int parseInt(String string, String string2) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            Report.badArgument(string2);
            n = -1;
        }
        return n;
    }

    private static boolean parseBool(String string, String string2) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            if (c == 't' || c == 'T' || c == 'Y' || c == 'y' || c == '1') {
                bl = true;
            } else if (c == 'f' || c == 'F' || c == 'N' || c == 'n' || c == '0') {
                bl = false;
            } else {
                Report.badArgument(string2);
            }
        }
        return bl;
    }

    private static boolean parseInvBool(String string, String string2) {
        boolean bl = false;
        if (string != null && string.length() > 0) {
            char c = string.charAt(0);
            if (c == 't' || c == 'T' || c == 'Y' || c == 'y') {
                bl = true;
            } else if (c == 'f' || c == 'F' || c == 'N' || c == 'n') {
                bl = false;
            } else {
                Report.badArgument(string2);
            }
        }
        return !bl;
    }

    private static String parseName(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String string3 = null;
        if (stringTokenizer.countTokens() >= 1) {
            string3 = stringTokenizer.nextToken();
        } else {
            Report.badArgument(string2);
        }
        return string3;
    }

    private static int parseCharEncoding(String string, String string2) {
        int n = 1;
        if (Lexer.wstrcasecmp(string, "ascii") == 0) {
            n = 1;
        } else if (Lexer.wstrcasecmp(string, "latin1") == 0) {
            n = 2;
        } else if (Lexer.wstrcasecmp(string, "raw") == 0) {
            n = 0;
        } else if (Lexer.wstrcasecmp(string, "utf8") == 0) {
            n = 3;
        } else if (Lexer.wstrcasecmp(string, "iso2022") == 0) {
            n = 4;
        } else if (Lexer.wstrcasecmp(string, "mac") == 0) {
            n = 5;
        } else {
            Report.badArgument(string2);
        }
        return n;
    }

    private boolean parseIndent(String string, String string2) {
        boolean bl = this.IndentContent;
        if (Lexer.wstrcasecmp(string, "yes") == 0) {
            bl = true;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "true") == 0) {
            bl = true;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "no") == 0) {
            bl = false;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "false") == 0) {
            bl = false;
            this.SmartIndent = false;
        } else if (Lexer.wstrcasecmp(string, "auto") == 0) {
            bl = true;
            this.SmartIndent = true;
        } else {
            Report.badArgument(string2);
        }
        return bl;
    }

    private void parseInlineTagNames(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            this.tt.defineInlineTag(stringTokenizer.nextToken());
        }
    }

    private void parseBlockTagNames(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            this.tt.defineBlockTag(stringTokenizer.nextToken());
        }
    }

    private void parseEmptyTagNames(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            this.tt.defineEmptyTag(stringTokenizer.nextToken());
        }
    }

    private void parsePreTagNames(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        while (stringTokenizer.hasMoreTokens()) {
            this.tt.definePreTag(stringTokenizer.nextToken());
        }
    }

    protected String parseDocType(String string, String string2) {
        if ((string = string.trim()).startsWith("\"")) {
            this.docTypeMode = 4;
            return string;
        }
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\n\r,");
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (Lexer.wstrcasecmp(string3, "omit") == 0) {
            this.docTypeMode = 0;
        } else if (Lexer.wstrcasecmp(string3, "strict") == 0) {
            this.docTypeMode = 2;
        } else if (Lexer.wstrcasecmp(string3, "loose") == 0 || Lexer.wstrcasecmp(string3, "transitional") == 0) {
            this.docTypeMode = 3;
        } else if (Lexer.wstrcasecmp(string3, "auto") == 0) {
            this.docTypeMode = 1;
        } else {
            this.docTypeMode = 1;
            Report.badArgument(string2);
        }
        return null;
    }
}

