/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.servlet.multipart;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.cocoon.servlet.multipart.Part;

public class MultipartHttpServletRequest
implements HttpServletRequest {
    private HttpServletRequest request = null;
    private Hashtable values = null;

    public MultipartHttpServletRequest(HttpServletRequest request, Hashtable values) {
        this.request = request;
        this.values = values;
    }

    public void cleanup() throws IOException {
        Enumeration e = this.getParameterNames();
        while (e.hasMoreElements()) {
            Part part;
            Object o = this.get((String)e.nextElement());
            if (!(o instanceof Part) || !(part = (Part)o).disposeWithRequest()) continue;
            part.dispose();
        }
    }

    public Object get(String name) {
        Vector<String> result = null;
        if (this.values != null) {
            result = (Vector<String>)this.values.get(name);
            if (result instanceof Vector) {
                if (((Vector)result).size() == 1) {
                    return ((Vector)result).elementAt(0);
                }
                return result;
            }
        } else {
            String[] array = this.request.getParameterValues(name);
            Vector<String> vec = new Vector<String>();
            if (array != null) {
                int i = 0;
                while (i < array.length) {
                    vec.addElement(array[i]);
                    ++i;
                }
                result = vec.size() == 1 ? vec.elementAt(0) : vec;
            }
        }
        return result;
    }

    public Enumeration getParameterNames() {
        if (this.values != null) {
            return this.values.keys();
        }
        return this.request.getParameterNames();
    }

    public String getParameter(String name) {
        Object value = this.get(name);
        String result = null;
        if (value != null) {
            if (value instanceof Vector) {
                value = ((Vector)value).elementAt(0);
            }
            result = value.toString();
        }
        return result;
    }

    public String[] getParameterValues(String name) {
        if (this.values != null) {
            Object value = this.get(name);
            if (value != null) {
                if (value instanceof Vector) {
                    String[] results = new String[((Vector)value).size()];
                    int i = 0;
                    while (i < ((Vector)value).size()) {
                        results[i] = ((Vector)value).elementAt(i).toString();
                        ++i;
                    }
                    return results;
                }
                return new String[]{value.toString()};
            }
            return null;
        }
        return this.request.getParameterValues(name);
    }

    public Object getAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.request.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.request.getInputStream();
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getServerName() {
        return this.request.getServerName();
    }

    public int getServerPort() {
        return this.request.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.request.getReader();
    }

    public String getRemoteAddr() {
        return this.request.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.request.getRemoteHost();
    }

    public void setAttribute(String name, Object o) {
        this.request.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.request.removeAttribute(name);
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public Enumeration getLocales() {
        return this.request.getLocales();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return this.request.getRequestDispatcher(path);
    }

    public String getRealPath(String path) {
        return this.request.getRealPath(path);
    }

    public String getAuthType() {
        return this.request.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.request.getCookies();
    }

    public long getDateHeader(String name) {
        return this.request.getDateHeader(name);
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public Enumeration getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Enumeration getHeaderNames() {
        return this.request.getHeaderNames();
    }

    public int getIntHeader(String name) {
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public String getPathInfo() {
        return this.request.getPathInfo();
    }

    public String getPathTranslated() {
        return this.request.getPathTranslated();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getQueryString() {
        return this.request.getQueryString();
    }

    public String getRemoteUser() {
        return this.request.getRemoteUser();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public String getRequestedSessionId() {
        return this.request.getRequestedSessionId();
    }

    public String getRequestURI() {
        return this.request.getRequestURI();
    }

    public String getServletPath() {
        return this.request.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        return this.request.getSession(create);
    }

    public HttpSession getSession() {
        return this.request.getSession();
    }

    public boolean isRequestedSessionIdValid() {
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.request.isRequestedSessionIdFromURL();
    }

    public StringBuffer getRequestURL() {
        return null;
    }

    public Map getParameterMap() {
        return null;
    }

    public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
    }
}

