/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.serializers.encoding;

import org.apache.cocoon.components.serializers.encoding.Charset;

public abstract class AbstractCharset
implements Charset {
    private String name;
    private String[] aliases;

    public AbstractCharset(String name, String[] aliases) {
        if (name == null) {
            throw new NullPointerException("Invalid name");
        }
        if (aliases == null) {
            throw new NullPointerException("Invalid aliases");
        }
        this.name = name;
        this.aliases = aliases;
    }

    public String getName() {
        return this.name;
    }

    public String[] getAliases() {
        String[] array = new String[this.aliases.length];
        System.arraycopy(this.aliases, 0, array, 0, array.length);
        return array;
    }

    public boolean equals(Object object) {
        if (object instanceof Charset) {
            return this.equals((Charset)object);
        }
        return false;
    }

    public boolean equals(Charset charset) {
        if (charset == null) {
            return false;
        }
        return charset.getClass().getName().equals(this.getClass().getName()) && charset.getName().equals(this.getName());
    }

    public String toString() {
        return super.toString() + "[" + this.getName() + "]";
    }
}

