/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.webapps.authentication.components;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.components.ContextHelper;
import org.apache.cocoon.components.SitemapConfigurable;
import org.apache.cocoon.components.SitemapConfigurationHolder;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.util.ClassUtils;
import org.apache.cocoon.webapps.authentication.AuthenticationManager;
import org.apache.cocoon.webapps.authentication.components.Authenticator;
import org.apache.cocoon.webapps.authentication.components.DefaultHandlerManager;
import org.apache.cocoon.webapps.authentication.configuration.ApplicationConfiguration;
import org.apache.cocoon.webapps.authentication.configuration.HandlerConfiguration;
import org.apache.cocoon.webapps.authentication.context.AuthenticationContext;
import org.apache.cocoon.webapps.authentication.user.RequestState;
import org.apache.cocoon.webapps.authentication.user.UserHandler;
import org.apache.cocoon.webapps.authentication.user.UserState;
import org.apache.cocoon.webapps.session.ContextManager;
import org.apache.cocoon.webapps.session.SessionManager;
import org.apache.cocoon.webapps.session.context.SessionContext;
import org.apache.excalibur.source.SourceParameters;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.SourceUtil;
import org.apache.excalibur.xml.xpath.XPathProcessor;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DefaultAuthenticationManager
extends AbstractLogEnabled
implements AuthenticationManager,
SitemapConfigurable,
Serviceable,
Disposable,
ThreadSafe,
Contextualizable,
Component {
    public static final String SESSION_ATTRIBUTE_USER_STATUS = (class$org$apache$cocoon$webapps$authentication$components$DefaultAuthenticationManager == null ? (class$org$apache$cocoon$webapps$authentication$components$DefaultAuthenticationManager = DefaultAuthenticationManager.class$("org.apache.cocoon.webapps.authentication.components.DefaultAuthenticationManager")) : class$org$apache$cocoon$webapps$authentication$components$DefaultAuthenticationManager).getName() + "/UserStatus";
    protected SitemapConfigurationHolder holder;
    protected ServiceManager manager;
    protected SourceResolver resolver;
    protected Context context;
    protected Map authenticators = new HashMap();
    protected XPathProcessor xpathProcessor;
    private static final String REQUEST_STATE_KEY = (class$org$apache$cocoon$webapps$authentication$user$RequestState == null ? (class$org$apache$cocoon$webapps$authentication$user$RequestState = DefaultAuthenticationManager.class$("org.apache.cocoon.webapps.authentication.user.RequestState")) : class$org$apache$cocoon$webapps$authentication$user$RequestState).getName();
    static /* synthetic */ Class class$org$apache$cocoon$webapps$authentication$components$DefaultAuthenticationManager;
    static /* synthetic */ Class class$org$apache$cocoon$webapps$authentication$user$RequestState;

    public void configure(SitemapConfigurationHolder holder) throws ConfigurationException {
        this.holder = holder;
    }

    private Map getHandlerConfigurations() throws ProcessingException {
        Map configs = (Map)this.holder.getPreparedConfiguration();
        if (null == configs) {
            try {
                configs = DefaultHandlerManager.prepareHandlerConfiguration(ContextHelper.getObjectModel((Context)this.context), this.holder);
            }
            catch (ConfigurationException ce) {
                throw new ProcessingException("Configuration error.", (Throwable)ce);
            }
        }
        return configs;
    }

    private HandlerConfiguration getHandlerConfiguration(String name) throws ProcessingException {
        Map configs = this.getHandlerConfigurations();
        HandlerConfiguration c = null;
        if (configs != null) {
            c = (HandlerConfiguration)configs.get(name);
        }
        return c;
    }

    private Request getRequest() {
        return ContextHelper.getRequest((Context)this.context);
    }

    private Session getSession(boolean create) {
        return this.getRequest().getSession(create);
    }

    private UserState getUserState() {
        Session session = this.getSession(false);
        UserState status = null;
        if (session != null) {
            status = (UserState)session.getAttribute(SESSION_ATTRIBUTE_USER_STATUS);
        }
        return status;
    }

    private UserState createUserState() {
        UserState status = this.getUserState();
        if (status == null) {
            Session session = this.getSession(true);
            status = new UserState();
            session.setAttribute(SESSION_ATTRIBUTE_USER_STATUS, (Object)status);
        }
        return status;
    }

    private UserHandler getUserHandler(String name) {
        UserState status = this.getUserState();
        if (status != null) {
            return status.getHandler(name);
        }
        return null;
    }

    private void updateUserState() {
        Session session = this.getSession(true);
        Object status = session.getAttribute(SESSION_ATTRIBUTE_USER_STATUS);
        session.setAttribute(SESSION_ATTRIBUTE_USER_STATUS, status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserHandler login(String handlerName, String applicationName, SourceParameters parameters) throws ProcessingException {
        HandlerConfiguration config = this.getHandlerConfiguration(handlerName);
        if (config == null) {
            throw new ProcessingException("Unknown handler to authenticate: " + handlerName);
        }
        UserHandler handler = this.getUserHandler(handlerName);
        if (handler != null) {
            throw new ProcessingException("User is already authenticated using handler: " + handlerName);
        }
        Authenticator authenticator = this.lookupAuthenticator(config);
        try {
            Authenticator.AuthenticationResult result = authenticator.authenticate(config, parameters);
            if (result != null && result.valid) {
                AuthenticationContext authContext = new AuthenticationContext(this.context, this.xpathProcessor, this.resolver);
                handler = new UserHandler(config, authContext);
                authContext.init(result.result);
            } else if (result != null) {
                ContextManager contextManager = null;
                try {
                    try {
                        contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
                        SessionContext temp = contextManager.getContext("temporary");
                        DocumentFragment fragment = result.result.createDocumentFragment();
                        Element root = result.result.getDocumentElement();
                        root.normalize();
                        boolean appendedNode = false;
                        while (true) {
                            if (!root.hasChildNodes()) {
                                temp.appendXML("/", fragment);
                                break;
                            }
                            Node child = root.getFirstChild();
                            root.removeChild(child);
                            if (!appendedNode && child.getNodeType() == 3 && child.getNodeValue().trim().length() <= 0) continue;
                            fragment.appendChild(child);
                            appendedNode = true;
                        }
                    }
                    catch (ServiceException se) {
                        throw new ProcessingException("Unable to lookup session manager.", (Throwable)se);
                    }
                    Object var15_15 = null;
                }
                catch (Throwable throwable) {
                    Object var15_16 = null;
                    this.manager.release((Object)contextManager);
                    throw throwable;
                }
                this.manager.release((Object)contextManager);
            }
            Object var17_18 = null;
            this.releaseAuthenticator(authenticator, config);
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            this.releaseAuthenticator(authenticator, config);
            throw throwable;
        }
        if (handler != null) {
            UserState status = this.createUserState();
            status.addHandler(handler);
            this.updateUserState();
            RequestState state = new RequestState(handler, applicationName);
            this.setState(state);
            state.initialize(this.resolver);
            Iterator applications = handler.getHandlerConfiguration().getApplications().values().iterator();
            while (applications.hasNext()) {
                ApplicationConfiguration appHandler = (ApplicationConfiguration)applications.next();
                if (appHandler.getLoadOnDemand()) continue;
                handler.getContext().loadApplicationXML(appHandler, this.resolver);
            }
        }
        return handler;
    }

    protected void releaseAuthenticator(Authenticator authenticator, HandlerConfiguration config) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Authenticator lookupAuthenticator(HandlerConfiguration config) throws ProcessingException {
        String name = config.getAuthenticatorClassName();
        Authenticator authenticator = (Authenticator)this.authenticators.get(name);
        if (authenticator == null) {
            DefaultAuthenticationManager defaultAuthenticationManager = this;
            synchronized (defaultAuthenticationManager) {
                authenticator = (Authenticator)this.authenticators.get(name);
                if (authenticator == null) {
                    try {
                        authenticator = (Authenticator)ClassUtils.newInstance((String)name);
                        ContainerUtil.enableLogging((Object)authenticator, (Logger)this.getLogger());
                        ContainerUtil.contextualize((Object)authenticator, (Context)this.context);
                        ContainerUtil.service((Object)authenticator, (ServiceManager)this.manager);
                        ContainerUtil.initialize((Object)authenticator);
                        this.authenticators.put(name, authenticator);
                    }
                    catch (Exception e) {
                        throw new ProcessingException("Unable to initialize authenticator from class " + name, (Throwable)e);
                    }
                }
            }
        }
        return authenticator;
    }

    public boolean checkAuthentication(Redirector redirector, String handlerName, String applicationName) throws IOException, ProcessingException {
        boolean authenticated;
        HandlerConfiguration config = this.getHandlerConfiguration(handlerName);
        if (config == null) {
            throw new ProcessingException("Unknown handler to check: " + handlerName);
        }
        UserHandler handler = this.getUserHandler(handlerName);
        boolean bl = authenticated = handler != null;
        if (!authenticated) {
            if (redirector != null) {
                SourceParameters parameters = config.getRedirectParameters();
                if (parameters == null) {
                    parameters = new SourceParameters();
                }
                Request request = this.getRequest();
                String resource = request.getRequestURI();
                if (request.getQueryString() != null) {
                    resource = resource + '?' + request.getQueryString();
                }
                parameters.setSingleParameterValue("resource", resource);
                String redirectURI = config.getRedirectURI();
                redirector.globalRedirect(false, SourceUtil.appendParameters((String)redirectURI, (SourceParameters)parameters));
            }
        } else {
            RequestState state = new RequestState(handler, applicationName);
            this.setState(state);
            state.initialize(this.resolver);
        }
        return authenticated;
    }

    public String getForwardingURI(String handlerName) throws ProcessingException {
        HandlerConfiguration config = this.getHandlerConfiguration(handlerName);
        SourceParameters parameters = config.getRedirectParameters();
        if (parameters == null) {
            parameters = new SourceParameters();
        }
        Request request = this.getRequest();
        String resource = request.getRequestURI();
        if (request.getQueryString() != null) {
            resource = resource + '?' + request.getQueryString();
        }
        parameters.setSingleParameterValue("resource", resource);
        String redirectURI = config.getRedirectURI();
        return SourceUtil.appendParameters((String)redirectURI, (SourceParameters)parameters);
    }

    public UserHandler isAuthenticated(String handlerName) throws ProcessingException {
        return this.getUserHandler(handlerName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void logout(String handlerName, int mode) throws ProcessingException {
        HandlerConfiguration config = this.getHandlerConfiguration(handlerName);
        if (config == null) {
            throw new ProcessingException("Unknown handler to logout: " + handlerName);
        }
        UserHandler handler = this.getUserHandler(handlerName);
        if (handler == null) return;
        try {
            this.lookupAuthenticator(config).logout(handler);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        List applicationContexts = handler.getApplicationContexts();
        if (applicationContexts != null) {
            ContextManager contextManager = null;
            try {
                try {
                    contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
                    Iterator i = applicationContexts.iterator();
                    while (i.hasNext()) {
                        String current = (String)i.next();
                        contextManager.deleteContext(current);
                    }
                }
                catch (ServiceException ce) {
                    throw new ProcessingException("Unable to create session context.", (Throwable)ce);
                }
                Object var10_12 = null;
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                this.manager.release((Object)contextManager);
                throw throwable;
            }
            this.manager.release((Object)contextManager);
        }
        UserState status = this.getUserState();
        status.removeHandler(handlerName);
        this.updateUserState();
        SessionManager sessionManager = null;
        try {
            try {
                sessionManager = (SessionManager)this.manager.lookup(SessionManager.ROLE);
                if (mode == 0) {
                    sessionManager.terminateSession(true);
                } else if (mode == 1) {
                    if (!status.hasHandler()) {
                        sessionManager.terminateSession(false);
                    }
                } else {
                    if (mode != 2) throw new ProcessingException("Unknown logout mode: " + mode);
                    if (!status.hasHandler()) {
                        sessionManager.terminateSession(true);
                    }
                }
                Object var12_15 = null;
            }
            catch (ServiceException se) {
                throw new ProcessingException("Unable to lookup session manager.", (Throwable)se);
            }
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            this.manager.release((Object)sessionManager);
            throw throwable;
        }
        this.manager.release((Object)sessionManager);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
        this.resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
        this.xpathProcessor = (XPathProcessor)this.manager.lookup(XPathProcessor.ROLE);
    }

    public void dispose() {
        Iterator iter = this.authenticators.values().iterator();
        while (iter.hasNext()) {
            Authenticator authenticator = (Authenticator)iter.next();
            ContainerUtil.dispose((Object)authenticator);
        }
        if (this.manager != null) {
            this.manager.release((Object)this.resolver);
            this.manager.release((Object)this.xpathProcessor);
            this.resolver = null;
            this.xpathProcessor = null;
            this.manager = null;
        }
    }

    public RequestState getState() {
        return DefaultAuthenticationManager.getRequestState(this.context);
    }

    public static RequestState getRequestState(Context context) {
        Request req = ContextHelper.getRequest((Context)context);
        return (RequestState)req.getAttribute(REQUEST_STATE_KEY);
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    protected void setState(RequestState status) {
        Request req = ContextHelper.getRequest((Context)this.context);
        if (status != null) {
            req.setAttribute(REQUEST_STATE_KEY, (Object)status);
        } else {
            req.removeAttribute(REQUEST_STATE_KEY);
        }
    }

    public SessionContext createApplicationContext(String name, String loadURI, String saveURI) throws ProcessingException {
        ContextManager contextManager;
        SessionContext context;
        block7: {
            RequestState state = this.getState();
            UserHandler handler = state.getHandler();
            context = null;
            if (handler != null) {
                contextManager = null;
                try {
                    try {
                        contextManager = (ContextManager)this.manager.lookup(ContextManager.ROLE);
                        context = contextManager.createContext(name, loadURI, saveURI);
                        handler.addApplicationContext(name);
                    }
                    catch (ServiceException ce) {
                        throw new ProcessingException("Unable to create session context.", (Throwable)ce);
                    }
                    catch (IOException ioe) {
                        throw new ProcessingException("Unable to create session context.", (Throwable)ioe);
                    }
                    catch (SAXException saxe) {
                        throw new ProcessingException("Unable to create session context.", (Throwable)saxe);
                    }
                    Object var12_8 = null;
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var12_9 = null;
                    this.manager.release((Object)contextManager);
                    throw throwable;
                }
            }
            throw new ProcessingException("No handler defined. Unable to create application context.");
        }
        this.manager.release((Object)contextManager);
        return context;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

