/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.ant;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.cocoon.ant.UriType;
import org.apache.cocoon.util.NetUtils;

public class CocoonCrawling
extends AbstractLogEnabled {
    private Set visitedAlready = Collections.synchronizedSet(new HashSet());
    private List stillNotVisited = Collections.synchronizedList(new ArrayList());
    private String root;

    public void setRoot(UriType uriType) {
        this.root = uriType.getPath();
        this.add(uriType);
    }

    public void add(UriType uriType) {
        String normalizedUriType;
        if (this.root != null && !(normalizedUriType = NetUtils.normalize((String)uriType.getUri())).startsWith(this.root)) {
            this.getLogger().warn("Uri " + String.valueOf(normalizedUriType) + " does not match root " + String.valueOf(this.root));
            return;
        }
        if (!this.visitedAlready.contains(uriType) && !this.stillNotVisited.contains(uriType)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Add uri " + String.valueOf(uriType.getUri()) + " for visiting");
            }
            this.stillNotVisited.add(uriType);
        }
    }

    public Iterator iterator() {
        return new CocoonCrawlingIterator(this.visitedAlready, this.stillNotVisited);
    }

    public Iterator visitedAlreadyIterator() {
        return this.visitedAlready.iterator();
    }

    public static class CocoonCrawlingIterator
    implements Iterator {
        private List stillNotVisited;
        private Set visitedAlready;

        public CocoonCrawlingIterator(Set visitedAlready, List stillNotVisited) {
            this.visitedAlready = visitedAlready;
            this.stillNotVisited = stillNotVisited;
        }

        public boolean hasNext() {
            return !this.stillNotVisited.isEmpty();
        }

        public Object next() {
            Object nextElement = this.stillNotVisited.remove(0);
            this.visitedAlready.add(nextElement);
            return nextElement;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

