/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.source.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Map;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.ZipSource;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceException;
import org.apache.excalibur.source.SourceFactory;
import org.apache.excalibur.source.SourceResolver;

public class ZipSourceFactory
extends AbstractLogEnabled
implements SourceFactory,
ThreadSafe,
Serviceable {
    protected ServiceManager manager;
    public static String ZIP_SOURCE_SCHEME = "zip:";

    public Source getSource(String location, Map parameters) throws IOException, MalformedURLException {
        Source archive;
        int separatorPos;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Processing " + location);
        }
        if ((separatorPos = location.indexOf(64)) == -1) {
            throw new MalformedURLException("@ required in URI: " + location);
        }
        int protocolEnd = location.indexOf("://");
        if (protocolEnd == -1) {
            throw new MalformedURLException("URI does not contain '://' : " + location);
        }
        String documentName = location.substring(protocolEnd + 3, separatorPos);
        SourceResolver resolver = null;
        try {
            try {
                resolver = (SourceResolver)this.manager.lookup(SourceResolver.ROLE);
                archive = resolver.resolveURI(location.substring(separatorPos + 1));
            }
            catch (ServiceException se) {
                throw new SourceException("SourceResolver is not available.", (Throwable)se);
            }
            Object var10_8 = null;
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            this.manager.release((Object)resolver);
            throw throwable;
        }
        this.manager.release((Object)resolver);
        return new ZipSource(archive, documentName);
    }

    public void release(Source source) {
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }
}

