/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.generation;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.ResourceNotFoundException;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.generation.AbstractGenerator;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.impl.XMLParser;
import org.apache.excalibur.source.Source;
import org.xml.sax.SAXException;

public class JellyGenerator
extends AbstractGenerator {
    protected JellyContext jellyContext;
    protected XMLParser jellyParser = new XMLParser();

    public void recycle() {
        super.recycle();
        this.jellyContext = null;
    }

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters params) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, params);
        this.jellyContext = new JellyContext();
        this.updateContext(params);
    }

    public void generate() throws IOException, SAXException, ProcessingException {
        Source scriptSource = null;
        try {
            try {
                this.updateContext();
                XMLOutput xmlOutput = new XMLOutput(this.contentHandler, this.lexicalHandler);
                scriptSource = this.resolver.resolveURI(this.source);
                Script script = this.jellyParser.parse(SourceUtil.getInputSource((Source)scriptSource));
                script = script.compile();
                this.contentHandler.startDocument();
                script.run(this.jellyContext, xmlOutput);
                xmlOutput.flush();
                this.contentHandler.endDocument();
            }
            catch (IOException e) {
                this.getLogger().error("JellyGenerator.generate()", (Throwable)e);
                throw new ResourceNotFoundException("JellyGenerator could not find resource", (Throwable)e);
            }
            catch (Exception e) {
                this.getLogger().error("Could not get parser", (Throwable)e);
                throw new ProcessingException("Exception in JellyGenerator.generate()", (Throwable)e);
            }
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.resolver.release(scriptSource);
            throw throwable;
        }
        this.resolver.release(scriptSource);
    }

    protected void updateContext(Parameters params) throws ProcessingException {
        try {
            String[] pArray = params.getNames();
            int i = 0;
            while (i < pArray.length) {
                String var = pArray[i];
                String val = params.getParameter(var);
                this.jellyContext.setVariable(var, (Object)val);
                ++i;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error in JellyGenerator.updateContext(Parameters params)", (Throwable)e);
            throw new ProcessingException("Exception in JellyGenerator.updateContext(Parameters params)", (Throwable)e);
        }
    }

    protected void updateContext() throws ProcessingException {
        try {
            Request request = ObjectModelHelper.getRequest((Map)this.objectModel);
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String var = (String)enumeration.nextElement();
                String val = request.getParameter(var);
                this.jellyContext.setVariable(var, (Object)val);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error in JellyGenerator.updateContext()", (Throwable)e);
            throw new ProcessingException("Exception in JellyGenerator.updateContext()", (Throwable)e);
        }
    }
}

