/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.reading;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Map;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Response;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.portal.coplet.CopletInstanceData;
import org.apache.cocoon.portal.transformation.ProxyTransformer;
import org.apache.cocoon.reading.ServiceableReader;
import org.xml.sax.SAXException;

public class ProxyReader
extends ServiceableReader {
    protected CopletInstanceData copletInstanceData;
    protected Response response;
    protected Request request;

    public void setup(SourceResolver resolver, Map objectModel, String src, Parameters par) throws ProcessingException, SAXException, IOException {
        super.setup(resolver, objectModel, src, par);
        this.request = ObjectModelHelper.getRequest((Map)objectModel);
        this.response = ObjectModelHelper.getResponse((Map)objectModel);
        String copletID = this.request.getParameter("cocoon-portal-copletid");
        String portalName = this.request.getParameter("cocoon-portal-portalname");
        this.copletInstanceData = ProxyTransformer.getInstanceData(this.manager, copletID, portalName);
    }

    public void recycle() {
        this.response = null;
        this.request = null;
        super.recycle();
    }

    public void generate() throws IOException {
        this.processRequest();
    }

    protected void processRequest() throws IOException {
        String link = this.request.getRequestURI();
        link = link.substring(link.indexOf("proxy-") + "proxy-".length());
        String documentBase = (String)this.copletInstanceData.getAttribute("documentbase");
        String remoteURI = null;
        remoteURI = ProxyTransformer.resolveURI(link, documentBase);
        HttpURLConnection connection = this.connect(this.request, remoteURI);
        this.copyHeaderFields(connection, this.response);
        this.sendData(connection.getInputStream());
    }

    protected void sendData(InputStream in) throws IOException {
        int length = -1;
        byte[] buf = new byte[4096];
        while ((length = in.read(buf)) > -1) {
            this.out.write(buf, 0, length);
        }
        this.out.flush();
        in.close();
    }

    protected HttpURLConnection connect(Request request, String uri) throws IOException {
        String cookie = (String)this.copletInstanceData.getAttribute("cookie");
        Enumeration enumeration = request.getParameterNames();
        boolean firstattribute = true;
        StringBuffer query = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String paramName = (String)enumeration.nextElement();
            if (paramName.startsWith("cocoon-portal-")) continue;
            String[] paramValues = request.getParameterValues(paramName);
            int i = 0;
            while (i < paramValues.length) {
                if (firstattribute) {
                    query.append('?');
                    firstattribute = false;
                } else {
                    query.append('&');
                }
                query.append(URLEncoder.encode(paramName));
                query.append('=');
                query.append(URLEncoder.encode(paramValues[i]));
                ++i;
            }
        }
        uri = uri + query.toString();
        URL url = new URL(uri);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setInstanceFollowRedirects(true);
        if (cookie != null) {
            connection.setRequestProperty("cookie", cookie);
        }
        connection.connect();
        this.copletInstanceData.setAttribute("cookie", connection.getHeaderField("cookie"));
        return connection;
    }

    private void copyHeaderFields(HttpURLConnection connection, Response response) {
        String[] fieldNames = new String[]{"Content-Range", "Accept-Ranges", "Content-Length", "Last-Modified", "Content-Type", "Expires"};
        int i = 0;
        while (i < fieldNames.length) {
            String value = connection.getHeaderField(fieldNames[i]);
            if (value != null) {
                response.setHeader(fieldNames[i], value);
            }
            ++i;
        }
    }
}

